// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.apigatewayv2.auth.ApiGatewayV2AuthSchemeProvider
import aws.sdk.kotlin.services.apigatewayv2.auth.DefaultApiGatewayV2AuthSchemeProvider
import aws.sdk.kotlin.services.apigatewayv2.endpoints.ApiGatewayV2EndpointParameters
import aws.sdk.kotlin.services.apigatewayv2.endpoints.ApiGatewayV2EndpointProvider
import aws.sdk.kotlin.services.apigatewayv2.endpoints.DefaultApiGatewayV2EndpointProvider
import aws.sdk.kotlin.services.apigatewayv2.model.CreateApiMappingRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateApiMappingResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateApiRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateApiResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateAuthorizerRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateAuthorizerResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateDeploymentResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateDomainNameRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateDomainNameResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationResponseResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateModelRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateModelResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteResponseResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateStageRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateStageResponse
import aws.sdk.kotlin.services.apigatewayv2.model.CreateVpcLinkRequest
import aws.sdk.kotlin.services.apigatewayv2.model.CreateVpcLinkResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteAccessLogSettingsRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteAccessLogSettingsResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteApiMappingRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteApiMappingResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteApiRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteApiResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteAuthorizerRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteAuthorizerResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteCorsConfigurationRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteCorsConfigurationResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteDeploymentRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteDeploymentResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteDomainNameRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteDomainNameResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteIntegrationRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteIntegrationResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteIntegrationResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteIntegrationResponseResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteModelRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteModelResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteRouteRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteRouteRequestParameterRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteRouteRequestParameterResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteRouteResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteRouteResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteRouteResponseResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteRouteSettingsRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteRouteSettingsResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteStageRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteStageResponse
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteVpcLinkRequest
import aws.sdk.kotlin.services.apigatewayv2.model.DeleteVpcLinkResponse
import aws.sdk.kotlin.services.apigatewayv2.model.ExportApiRequest
import aws.sdk.kotlin.services.apigatewayv2.model.ExportApiResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetApiMappingRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetApiMappingResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetApiMappingsRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetApiMappingsResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetApiRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetApiResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetApisRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetApisResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetAuthorizerRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetAuthorizerResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetAuthorizersRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetAuthorizersResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetDeploymentRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetDeploymentResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetDeploymentsRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetDeploymentsResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetDomainNameRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetDomainNameResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetDomainNamesRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetDomainNamesResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationResponseResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationResponsesRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationResponsesResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationsRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationsResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetModelRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetModelResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetModelTemplateRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetModelTemplateResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetModelsRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetModelsResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetRouteRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetRouteResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetRouteResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetRouteResponseResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetRouteResponsesRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetRouteResponsesResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetRoutesRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetRoutesResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetStageRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetStageResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetStagesRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetStagesResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetTagsRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetTagsResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetVpcLinkRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetVpcLinkResponse
import aws.sdk.kotlin.services.apigatewayv2.model.GetVpcLinksRequest
import aws.sdk.kotlin.services.apigatewayv2.model.GetVpcLinksResponse
import aws.sdk.kotlin.services.apigatewayv2.model.ImportApiRequest
import aws.sdk.kotlin.services.apigatewayv2.model.ImportApiResponse
import aws.sdk.kotlin.services.apigatewayv2.model.ReimportApiRequest
import aws.sdk.kotlin.services.apigatewayv2.model.ReimportApiResponse
import aws.sdk.kotlin.services.apigatewayv2.model.ResetAuthorizersCacheRequest
import aws.sdk.kotlin.services.apigatewayv2.model.ResetAuthorizersCacheResponse
import aws.sdk.kotlin.services.apigatewayv2.model.TagResourceRequest
import aws.sdk.kotlin.services.apigatewayv2.model.TagResourceResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UntagResourceRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UntagResourceResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiMappingRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiMappingResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateAuthorizerRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateAuthorizerResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateDeploymentRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateDeploymentResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateDomainNameRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateDomainNameResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateModelRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateModelResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteResponseResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageResponse
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateVpcLinkRequest
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateVpcLinkResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ApiGatewayV2"
public const val SdkVersion: String = "1.3.94"
public const val ServiceApiVersion: String = "2018-11-29"

/**
 * Amazon API Gateway V2
 */
public interface ApiGatewayV2Client : SdkClient {
    /**
     * ApiGatewayV2Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ApiGatewayV2Client, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ApiGatewayV2",
                "APIGATEWAYV2",
                "apigatewayv2",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ApiGatewayV2Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ApiGatewayV2Client = DefaultApiGatewayV2Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ApiGatewayV2EndpointProvider = builder.endpointProvider ?: DefaultApiGatewayV2EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ApiGatewayV2AuthSchemeProvider = builder.authSchemeProvider ?: DefaultApiGatewayV2AuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ApiGatewayV2"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ApiGatewayV2EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ApiGatewayV2AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Api resource.
     */
    public suspend fun createApi(input: CreateApiRequest): CreateApiResponse

    /**
     * Creates an API mapping.
     */
    public suspend fun createApiMapping(input: CreateApiMappingRequest): CreateApiMappingResponse

    /**
     * Creates an Authorizer for an API.
     */
    public suspend fun createAuthorizer(input: CreateAuthorizerRequest): CreateAuthorizerResponse

    /**
     * Creates a Deployment for an API.
     */
    public suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a domain name.
     */
    public suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse

    /**
     * Creates an Integration.
     */
    public suspend fun createIntegration(input: CreateIntegrationRequest): CreateIntegrationResponse

    /**
     * Creates an IntegrationResponses.
     */
    public suspend fun createIntegrationResponse(input: CreateIntegrationResponseRequest): CreateIntegrationResponseResponse

    /**
     * Creates a Model for an API.
     */
    public suspend fun createModel(input: CreateModelRequest): CreateModelResponse

    /**
     * Creates a Route for an API.
     */
    public suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse

    /**
     * Creates a RouteResponse for a Route.
     */
    public suspend fun createRouteResponse(input: CreateRouteResponseRequest): CreateRouteResponseResponse

    /**
     * Creates a Stage for an API.
     */
    public suspend fun createStage(input: CreateStageRequest): CreateStageResponse

    /**
     * Creates a VPC link.
     */
    public suspend fun createVpcLink(input: CreateVpcLinkRequest): CreateVpcLinkResponse

    /**
     * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
     */
    public suspend fun deleteAccessLogSettings(input: DeleteAccessLogSettingsRequest): DeleteAccessLogSettingsResponse

    /**
     * Deletes an Api resource.
     */
    public suspend fun deleteApi(input: DeleteApiRequest): DeleteApiResponse

    /**
     * Deletes an API mapping.
     */
    public suspend fun deleteApiMapping(input: DeleteApiMappingRequest): DeleteApiMappingResponse

    /**
     * Deletes an Authorizer.
     */
    public suspend fun deleteAuthorizer(input: DeleteAuthorizerRequest): DeleteAuthorizerResponse

    /**
     * Deletes a CORS configuration.
     */
    public suspend fun deleteCorsConfiguration(input: DeleteCorsConfigurationRequest): DeleteCorsConfigurationResponse

    /**
     * Deletes a Deployment.
     */
    public suspend fun deleteDeployment(input: DeleteDeploymentRequest): DeleteDeploymentResponse

    /**
     * Deletes a domain name.
     */
    public suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse

    /**
     * Deletes an Integration.
     */
    public suspend fun deleteIntegration(input: DeleteIntegrationRequest): DeleteIntegrationResponse

    /**
     * Deletes an IntegrationResponses.
     */
    public suspend fun deleteIntegrationResponse(input: DeleteIntegrationResponseRequest): DeleteIntegrationResponseResponse

    /**
     * Deletes a Model.
     */
    public suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse

    /**
     * Deletes a Route.
     */
    public suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse

    /**
     * Deletes a route request parameter. Supported only for WebSocket APIs.
     */
    public suspend fun deleteRouteRequestParameter(input: DeleteRouteRequestParameterRequest): DeleteRouteRequestParameterResponse

    /**
     * Deletes a RouteResponse.
     */
    public suspend fun deleteRouteResponse(input: DeleteRouteResponseRequest): DeleteRouteResponseResponse

    /**
     * Deletes the RouteSettings for a stage.
     */
    public suspend fun deleteRouteSettings(input: DeleteRouteSettingsRequest): DeleteRouteSettingsResponse

    /**
     * Deletes a Stage.
     */
    public suspend fun deleteStage(input: DeleteStageRequest): DeleteStageResponse

    /**
     * Deletes a VPC link.
     */
    public suspend fun deleteVpcLink(input: DeleteVpcLinkRequest): DeleteVpcLinkResponse

    public suspend fun exportApi(input: ExportApiRequest): ExportApiResponse

    /**
     * Gets an Api resource.
     */
    public suspend fun getApi(input: GetApiRequest): GetApiResponse

    /**
     * Gets an API mapping.
     */
    public suspend fun getApiMapping(input: GetApiMappingRequest): GetApiMappingResponse

    /**
     * Gets API mappings.
     */
    public suspend fun getApiMappings(input: GetApiMappingsRequest): GetApiMappingsResponse

    /**
     * Gets a collection of Api resources.
     */
    public suspend fun getApis(input: GetApisRequest = GetApisRequest { }): GetApisResponse

    /**
     * Gets an Authorizer.
     */
    public suspend fun getAuthorizer(input: GetAuthorizerRequest): GetAuthorizerResponse

    /**
     * Gets the Authorizers for an API.
     */
    public suspend fun getAuthorizers(input: GetAuthorizersRequest): GetAuthorizersResponse

    /**
     * Gets a Deployment.
     */
    public suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Gets the Deployments for an API.
     */
    public suspend fun getDeployments(input: GetDeploymentsRequest): GetDeploymentsResponse

    /**
     * Gets a domain name.
     */
    public suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse

    /**
     * Gets the domain names for an AWS account.
     */
    public suspend fun getDomainNames(input: GetDomainNamesRequest = GetDomainNamesRequest { }): GetDomainNamesResponse

    /**
     * Gets an Integration.
     */
    public suspend fun getIntegration(input: GetIntegrationRequest): GetIntegrationResponse

    /**
     * Gets an IntegrationResponses.
     */
    public suspend fun getIntegrationResponse(input: GetIntegrationResponseRequest): GetIntegrationResponseResponse

    /**
     * Gets the IntegrationResponses for an Integration.
     */
    public suspend fun getIntegrationResponses(input: GetIntegrationResponsesRequest): GetIntegrationResponsesResponse

    /**
     * Gets the Integrations for an API.
     */
    public suspend fun getIntegrations(input: GetIntegrationsRequest): GetIntegrationsResponse

    /**
     * Gets a Model.
     */
    public suspend fun getModel(input: GetModelRequest): GetModelResponse

    /**
     * Gets a model template.
     */
    public suspend fun getModelTemplate(input: GetModelTemplateRequest): GetModelTemplateResponse

    /**
     * Gets the Models for an API.
     */
    public suspend fun getModels(input: GetModelsRequest): GetModelsResponse

    /**
     * Gets a Route.
     */
    public suspend fun getRoute(input: GetRouteRequest): GetRouteResponse

    /**
     * Gets a RouteResponse.
     */
    public suspend fun getRouteResponse(input: GetRouteResponseRequest): GetRouteResponseResponse

    /**
     * Gets the RouteResponses for a Route.
     */
    public suspend fun getRouteResponses(input: GetRouteResponsesRequest): GetRouteResponsesResponse

    /**
     * Gets the Routes for an API.
     */
    public suspend fun getRoutes(input: GetRoutesRequest): GetRoutesResponse

    /**
     * Gets a Stage.
     */
    public suspend fun getStage(input: GetStageRequest): GetStageResponse

    /**
     * Gets the Stages for an API.
     */
    public suspend fun getStages(input: GetStagesRequest): GetStagesResponse

    /**
     * Gets a collection of Tag resources.
     */
    public suspend fun getTags(input: GetTagsRequest): GetTagsResponse

    /**
     * Gets a VPC link.
     */
    public suspend fun getVpcLink(input: GetVpcLinkRequest): GetVpcLinkResponse

    /**
     * Gets a collection of VPC links.
     */
    public suspend fun getVpcLinks(input: GetVpcLinksRequest = GetVpcLinksRequest { }): GetVpcLinksResponse

    /**
     * Imports an API.
     */
    public suspend fun importApi(input: ImportApiRequest): ImportApiResponse

    /**
     * Puts an Api resource.
     */
    public suspend fun reimportApi(input: ReimportApiRequest): ReimportApiResponse

    /**
     * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
     */
    public suspend fun resetAuthorizersCache(input: ResetAuthorizersCacheRequest): ResetAuthorizersCacheResponse

    /**
     * Creates a new Tag resource to represent a tag.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes a Tag.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Api resource.
     */
    public suspend fun updateApi(input: UpdateApiRequest): UpdateApiResponse

    /**
     * The API mapping.
     */
    public suspend fun updateApiMapping(input: UpdateApiMappingRequest): UpdateApiMappingResponse

    /**
     * Updates an Authorizer.
     */
    public suspend fun updateAuthorizer(input: UpdateAuthorizerRequest): UpdateAuthorizerResponse

    /**
     * Updates a Deployment.
     */
    public suspend fun updateDeployment(input: UpdateDeploymentRequest): UpdateDeploymentResponse

    /**
     * Updates a domain name.
     */
    public suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse

    /**
     * Updates an Integration.
     */
    public suspend fun updateIntegration(input: UpdateIntegrationRequest): UpdateIntegrationResponse

    /**
     * Updates an IntegrationResponses.
     */
    public suspend fun updateIntegrationResponse(input: UpdateIntegrationResponseRequest): UpdateIntegrationResponseResponse

    /**
     * Updates a Model.
     */
    public suspend fun updateModel(input: UpdateModelRequest): UpdateModelResponse

    /**
     * Updates a Route.
     */
    public suspend fun updateRoute(input: UpdateRouteRequest): UpdateRouteResponse

    /**
     * Updates a RouteResponse.
     */
    public suspend fun updateRouteResponse(input: UpdateRouteResponseRequest): UpdateRouteResponseResponse

    /**
     * Updates a Stage.
     */
    public suspend fun updateStage(input: UpdateStageRequest): UpdateStageResponse

    /**
     * Updates a VPC link.
     */
    public suspend fun updateVpcLink(input: UpdateVpcLinkRequest): UpdateVpcLinkResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ApiGatewayV2Client.withConfig(block: ApiGatewayV2Client.Config.Builder.() -> Unit): ApiGatewayV2Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultApiGatewayV2Client(newConfig)
}

/**
 * Creates an Api resource.
 */
public suspend inline fun ApiGatewayV2Client.createApi(crossinline block: CreateApiRequest.Builder.() -> Unit): CreateApiResponse = createApi(CreateApiRequest.Builder().apply(block).build())

/**
 * Creates an API mapping.
 */
public suspend inline fun ApiGatewayV2Client.createApiMapping(crossinline block: CreateApiMappingRequest.Builder.() -> Unit): CreateApiMappingResponse = createApiMapping(CreateApiMappingRequest.Builder().apply(block).build())

/**
 * Creates an Authorizer for an API.
 */
public suspend inline fun ApiGatewayV2Client.createAuthorizer(crossinline block: CreateAuthorizerRequest.Builder.() -> Unit): CreateAuthorizerResponse = createAuthorizer(CreateAuthorizerRequest.Builder().apply(block).build())

/**
 * Creates a Deployment for an API.
 */
public suspend inline fun ApiGatewayV2Client.createDeployment(crossinline block: CreateDeploymentRequest.Builder.() -> Unit): CreateDeploymentResponse = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

/**
 * Creates a domain name.
 */
public suspend inline fun ApiGatewayV2Client.createDomainName(crossinline block: CreateDomainNameRequest.Builder.() -> Unit): CreateDomainNameResponse = createDomainName(CreateDomainNameRequest.Builder().apply(block).build())

/**
 * Creates an Integration.
 */
public suspend inline fun ApiGatewayV2Client.createIntegration(crossinline block: CreateIntegrationRequest.Builder.() -> Unit): CreateIntegrationResponse = createIntegration(CreateIntegrationRequest.Builder().apply(block).build())

/**
 * Creates an IntegrationResponses.
 */
public suspend inline fun ApiGatewayV2Client.createIntegrationResponse(crossinline block: CreateIntegrationResponseRequest.Builder.() -> Unit): CreateIntegrationResponseResponse = createIntegrationResponse(CreateIntegrationResponseRequest.Builder().apply(block).build())

/**
 * Creates a Model for an API.
 */
public suspend inline fun ApiGatewayV2Client.createModel(crossinline block: CreateModelRequest.Builder.() -> Unit): CreateModelResponse = createModel(CreateModelRequest.Builder().apply(block).build())

/**
 * Creates a Route for an API.
 */
public suspend inline fun ApiGatewayV2Client.createRoute(crossinline block: CreateRouteRequest.Builder.() -> Unit): CreateRouteResponse = createRoute(CreateRouteRequest.Builder().apply(block).build())

/**
 * Creates a RouteResponse for a Route.
 */
public suspend inline fun ApiGatewayV2Client.createRouteResponse(crossinline block: CreateRouteResponseRequest.Builder.() -> Unit): CreateRouteResponseResponse = createRouteResponse(CreateRouteResponseRequest.Builder().apply(block).build())

/**
 * Creates a Stage for an API.
 */
public suspend inline fun ApiGatewayV2Client.createStage(crossinline block: CreateStageRequest.Builder.() -> Unit): CreateStageResponse = createStage(CreateStageRequest.Builder().apply(block).build())

/**
 * Creates a VPC link.
 */
public suspend inline fun ApiGatewayV2Client.createVpcLink(crossinline block: CreateVpcLinkRequest.Builder.() -> Unit): CreateVpcLinkResponse = createVpcLink(CreateVpcLinkRequest.Builder().apply(block).build())

/**
 * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
 */
public suspend inline fun ApiGatewayV2Client.deleteAccessLogSettings(crossinline block: DeleteAccessLogSettingsRequest.Builder.() -> Unit): DeleteAccessLogSettingsResponse = deleteAccessLogSettings(DeleteAccessLogSettingsRequest.Builder().apply(block).build())

/**
 * Deletes an Api resource.
 */
public suspend inline fun ApiGatewayV2Client.deleteApi(crossinline block: DeleteApiRequest.Builder.() -> Unit): DeleteApiResponse = deleteApi(DeleteApiRequest.Builder().apply(block).build())

/**
 * Deletes an API mapping.
 */
public suspend inline fun ApiGatewayV2Client.deleteApiMapping(crossinline block: DeleteApiMappingRequest.Builder.() -> Unit): DeleteApiMappingResponse = deleteApiMapping(DeleteApiMappingRequest.Builder().apply(block).build())

/**
 * Deletes an Authorizer.
 */
public suspend inline fun ApiGatewayV2Client.deleteAuthorizer(crossinline block: DeleteAuthorizerRequest.Builder.() -> Unit): DeleteAuthorizerResponse = deleteAuthorizer(DeleteAuthorizerRequest.Builder().apply(block).build())

/**
 * Deletes a CORS configuration.
 */
public suspend inline fun ApiGatewayV2Client.deleteCorsConfiguration(crossinline block: DeleteCorsConfigurationRequest.Builder.() -> Unit): DeleteCorsConfigurationResponse = deleteCorsConfiguration(DeleteCorsConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a Deployment.
 */
public suspend inline fun ApiGatewayV2Client.deleteDeployment(crossinline block: DeleteDeploymentRequest.Builder.() -> Unit): DeleteDeploymentResponse = deleteDeployment(DeleteDeploymentRequest.Builder().apply(block).build())

/**
 * Deletes a domain name.
 */
public suspend inline fun ApiGatewayV2Client.deleteDomainName(crossinline block: DeleteDomainNameRequest.Builder.() -> Unit): DeleteDomainNameResponse = deleteDomainName(DeleteDomainNameRequest.Builder().apply(block).build())

/**
 * Deletes an Integration.
 */
public suspend inline fun ApiGatewayV2Client.deleteIntegration(crossinline block: DeleteIntegrationRequest.Builder.() -> Unit): DeleteIntegrationResponse = deleteIntegration(DeleteIntegrationRequest.Builder().apply(block).build())

/**
 * Deletes an IntegrationResponses.
 */
public suspend inline fun ApiGatewayV2Client.deleteIntegrationResponse(crossinline block: DeleteIntegrationResponseRequest.Builder.() -> Unit): DeleteIntegrationResponseResponse = deleteIntegrationResponse(DeleteIntegrationResponseRequest.Builder().apply(block).build())

/**
 * Deletes a Model.
 */
public suspend inline fun ApiGatewayV2Client.deleteModel(crossinline block: DeleteModelRequest.Builder.() -> Unit): DeleteModelResponse = deleteModel(DeleteModelRequest.Builder().apply(block).build())

/**
 * Deletes a Route.
 */
public suspend inline fun ApiGatewayV2Client.deleteRoute(crossinline block: DeleteRouteRequest.Builder.() -> Unit): DeleteRouteResponse = deleteRoute(DeleteRouteRequest.Builder().apply(block).build())

/**
 * Deletes a route request parameter. Supported only for WebSocket APIs.
 */
public suspend inline fun ApiGatewayV2Client.deleteRouteRequestParameter(crossinline block: DeleteRouteRequestParameterRequest.Builder.() -> Unit): DeleteRouteRequestParameterResponse = deleteRouteRequestParameter(DeleteRouteRequestParameterRequest.Builder().apply(block).build())

/**
 * Deletes a RouteResponse.
 */
public suspend inline fun ApiGatewayV2Client.deleteRouteResponse(crossinline block: DeleteRouteResponseRequest.Builder.() -> Unit): DeleteRouteResponseResponse = deleteRouteResponse(DeleteRouteResponseRequest.Builder().apply(block).build())

/**
 * Deletes the RouteSettings for a stage.
 */
public suspend inline fun ApiGatewayV2Client.deleteRouteSettings(crossinline block: DeleteRouteSettingsRequest.Builder.() -> Unit): DeleteRouteSettingsResponse = deleteRouteSettings(DeleteRouteSettingsRequest.Builder().apply(block).build())

/**
 * Deletes a Stage.
 */
public suspend inline fun ApiGatewayV2Client.deleteStage(crossinline block: DeleteStageRequest.Builder.() -> Unit): DeleteStageResponse = deleteStage(DeleteStageRequest.Builder().apply(block).build())

/**
 * Deletes a VPC link.
 */
public suspend inline fun ApiGatewayV2Client.deleteVpcLink(crossinline block: DeleteVpcLinkRequest.Builder.() -> Unit): DeleteVpcLinkResponse = deleteVpcLink(DeleteVpcLinkRequest.Builder().apply(block).build())

public suspend inline fun ApiGatewayV2Client.exportApi(crossinline block: ExportApiRequest.Builder.() -> Unit): ExportApiResponse = exportApi(ExportApiRequest.Builder().apply(block).build())

/**
 * Gets an Api resource.
 */
public suspend inline fun ApiGatewayV2Client.getApi(crossinline block: GetApiRequest.Builder.() -> Unit): GetApiResponse = getApi(GetApiRequest.Builder().apply(block).build())

/**
 * Gets an API mapping.
 */
public suspend inline fun ApiGatewayV2Client.getApiMapping(crossinline block: GetApiMappingRequest.Builder.() -> Unit): GetApiMappingResponse = getApiMapping(GetApiMappingRequest.Builder().apply(block).build())

/**
 * Gets API mappings.
 */
public suspend inline fun ApiGatewayV2Client.getApiMappings(crossinline block: GetApiMappingsRequest.Builder.() -> Unit): GetApiMappingsResponse = getApiMappings(GetApiMappingsRequest.Builder().apply(block).build())

/**
 * Gets a collection of Api resources.
 */
public suspend inline fun ApiGatewayV2Client.getApis(crossinline block: GetApisRequest.Builder.() -> Unit): GetApisResponse = getApis(GetApisRequest.Builder().apply(block).build())

/**
 * Gets an Authorizer.
 */
public suspend inline fun ApiGatewayV2Client.getAuthorizer(crossinline block: GetAuthorizerRequest.Builder.() -> Unit): GetAuthorizerResponse = getAuthorizer(GetAuthorizerRequest.Builder().apply(block).build())

/**
 * Gets the Authorizers for an API.
 */
public suspend inline fun ApiGatewayV2Client.getAuthorizers(crossinline block: GetAuthorizersRequest.Builder.() -> Unit): GetAuthorizersResponse = getAuthorizers(GetAuthorizersRequest.Builder().apply(block).build())

/**
 * Gets a Deployment.
 */
public suspend inline fun ApiGatewayV2Client.getDeployment(crossinline block: GetDeploymentRequest.Builder.() -> Unit): GetDeploymentResponse = getDeployment(GetDeploymentRequest.Builder().apply(block).build())

/**
 * Gets the Deployments for an API.
 */
public suspend inline fun ApiGatewayV2Client.getDeployments(crossinline block: GetDeploymentsRequest.Builder.() -> Unit): GetDeploymentsResponse = getDeployments(GetDeploymentsRequest.Builder().apply(block).build())

/**
 * Gets a domain name.
 */
public suspend inline fun ApiGatewayV2Client.getDomainName(crossinline block: GetDomainNameRequest.Builder.() -> Unit): GetDomainNameResponse = getDomainName(GetDomainNameRequest.Builder().apply(block).build())

/**
 * Gets the domain names for an AWS account.
 */
public suspend inline fun ApiGatewayV2Client.getDomainNames(crossinline block: GetDomainNamesRequest.Builder.() -> Unit): GetDomainNamesResponse = getDomainNames(GetDomainNamesRequest.Builder().apply(block).build())

/**
 * Gets an Integration.
 */
public suspend inline fun ApiGatewayV2Client.getIntegration(crossinline block: GetIntegrationRequest.Builder.() -> Unit): GetIntegrationResponse = getIntegration(GetIntegrationRequest.Builder().apply(block).build())

/**
 * Gets an IntegrationResponses.
 */
public suspend inline fun ApiGatewayV2Client.getIntegrationResponse(crossinline block: GetIntegrationResponseRequest.Builder.() -> Unit): GetIntegrationResponseResponse = getIntegrationResponse(GetIntegrationResponseRequest.Builder().apply(block).build())

/**
 * Gets the IntegrationResponses for an Integration.
 */
public suspend inline fun ApiGatewayV2Client.getIntegrationResponses(crossinline block: GetIntegrationResponsesRequest.Builder.() -> Unit): GetIntegrationResponsesResponse = getIntegrationResponses(GetIntegrationResponsesRequest.Builder().apply(block).build())

/**
 * Gets the Integrations for an API.
 */
public suspend inline fun ApiGatewayV2Client.getIntegrations(crossinline block: GetIntegrationsRequest.Builder.() -> Unit): GetIntegrationsResponse = getIntegrations(GetIntegrationsRequest.Builder().apply(block).build())

/**
 * Gets a Model.
 */
public suspend inline fun ApiGatewayV2Client.getModel(crossinline block: GetModelRequest.Builder.() -> Unit): GetModelResponse = getModel(GetModelRequest.Builder().apply(block).build())

/**
 * Gets a model template.
 */
public suspend inline fun ApiGatewayV2Client.getModelTemplate(crossinline block: GetModelTemplateRequest.Builder.() -> Unit): GetModelTemplateResponse = getModelTemplate(GetModelTemplateRequest.Builder().apply(block).build())

/**
 * Gets the Models for an API.
 */
public suspend inline fun ApiGatewayV2Client.getModels(crossinline block: GetModelsRequest.Builder.() -> Unit): GetModelsResponse = getModels(GetModelsRequest.Builder().apply(block).build())

/**
 * Gets a Route.
 */
public suspend inline fun ApiGatewayV2Client.getRoute(crossinline block: GetRouteRequest.Builder.() -> Unit): GetRouteResponse = getRoute(GetRouteRequest.Builder().apply(block).build())

/**
 * Gets a RouteResponse.
 */
public suspend inline fun ApiGatewayV2Client.getRouteResponse(crossinline block: GetRouteResponseRequest.Builder.() -> Unit): GetRouteResponseResponse = getRouteResponse(GetRouteResponseRequest.Builder().apply(block).build())

/**
 * Gets the RouteResponses for a Route.
 */
public suspend inline fun ApiGatewayV2Client.getRouteResponses(crossinline block: GetRouteResponsesRequest.Builder.() -> Unit): GetRouteResponsesResponse = getRouteResponses(GetRouteResponsesRequest.Builder().apply(block).build())

/**
 * Gets the Routes for an API.
 */
public suspend inline fun ApiGatewayV2Client.getRoutes(crossinline block: GetRoutesRequest.Builder.() -> Unit): GetRoutesResponse = getRoutes(GetRoutesRequest.Builder().apply(block).build())

/**
 * Gets a Stage.
 */
public suspend inline fun ApiGatewayV2Client.getStage(crossinline block: GetStageRequest.Builder.() -> Unit): GetStageResponse = getStage(GetStageRequest.Builder().apply(block).build())

/**
 * Gets the Stages for an API.
 */
public suspend inline fun ApiGatewayV2Client.getStages(crossinline block: GetStagesRequest.Builder.() -> Unit): GetStagesResponse = getStages(GetStagesRequest.Builder().apply(block).build())

/**
 * Gets a collection of Tag resources.
 */
public suspend inline fun ApiGatewayV2Client.getTags(crossinline block: GetTagsRequest.Builder.() -> Unit): GetTagsResponse = getTags(GetTagsRequest.Builder().apply(block).build())

/**
 * Gets a VPC link.
 */
public suspend inline fun ApiGatewayV2Client.getVpcLink(crossinline block: GetVpcLinkRequest.Builder.() -> Unit): GetVpcLinkResponse = getVpcLink(GetVpcLinkRequest.Builder().apply(block).build())

/**
 * Gets a collection of VPC links.
 */
public suspend inline fun ApiGatewayV2Client.getVpcLinks(crossinline block: GetVpcLinksRequest.Builder.() -> Unit): GetVpcLinksResponse = getVpcLinks(GetVpcLinksRequest.Builder().apply(block).build())

/**
 * Imports an API.
 */
public suspend inline fun ApiGatewayV2Client.importApi(crossinline block: ImportApiRequest.Builder.() -> Unit): ImportApiResponse = importApi(ImportApiRequest.Builder().apply(block).build())

/**
 * Puts an Api resource.
 */
public suspend inline fun ApiGatewayV2Client.reimportApi(crossinline block: ReimportApiRequest.Builder.() -> Unit): ReimportApiResponse = reimportApi(ReimportApiRequest.Builder().apply(block).build())

/**
 * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
 */
public suspend inline fun ApiGatewayV2Client.resetAuthorizersCache(crossinline block: ResetAuthorizersCacheRequest.Builder.() -> Unit): ResetAuthorizersCacheResponse = resetAuthorizersCache(ResetAuthorizersCacheRequest.Builder().apply(block).build())

/**
 * Creates a new Tag resource to represent a tag.
 */
public suspend inline fun ApiGatewayV2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes a Tag.
 */
public suspend inline fun ApiGatewayV2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Api resource.
 */
public suspend inline fun ApiGatewayV2Client.updateApi(crossinline block: UpdateApiRequest.Builder.() -> Unit): UpdateApiResponse = updateApi(UpdateApiRequest.Builder().apply(block).build())

/**
 * The API mapping.
 */
public suspend inline fun ApiGatewayV2Client.updateApiMapping(crossinline block: UpdateApiMappingRequest.Builder.() -> Unit): UpdateApiMappingResponse = updateApiMapping(UpdateApiMappingRequest.Builder().apply(block).build())

/**
 * Updates an Authorizer.
 */
public suspend inline fun ApiGatewayV2Client.updateAuthorizer(crossinline block: UpdateAuthorizerRequest.Builder.() -> Unit): UpdateAuthorizerResponse = updateAuthorizer(UpdateAuthorizerRequest.Builder().apply(block).build())

/**
 * Updates a Deployment.
 */
public suspend inline fun ApiGatewayV2Client.updateDeployment(crossinline block: UpdateDeploymentRequest.Builder.() -> Unit): UpdateDeploymentResponse = updateDeployment(UpdateDeploymentRequest.Builder().apply(block).build())

/**
 * Updates a domain name.
 */
public suspend inline fun ApiGatewayV2Client.updateDomainName(crossinline block: UpdateDomainNameRequest.Builder.() -> Unit): UpdateDomainNameResponse = updateDomainName(UpdateDomainNameRequest.Builder().apply(block).build())

/**
 * Updates an Integration.
 */
public suspend inline fun ApiGatewayV2Client.updateIntegration(crossinline block: UpdateIntegrationRequest.Builder.() -> Unit): UpdateIntegrationResponse = updateIntegration(UpdateIntegrationRequest.Builder().apply(block).build())

/**
 * Updates an IntegrationResponses.
 */
public suspend inline fun ApiGatewayV2Client.updateIntegrationResponse(crossinline block: UpdateIntegrationResponseRequest.Builder.() -> Unit): UpdateIntegrationResponseResponse = updateIntegrationResponse(UpdateIntegrationResponseRequest.Builder().apply(block).build())

/**
 * Updates a Model.
 */
public suspend inline fun ApiGatewayV2Client.updateModel(crossinline block: UpdateModelRequest.Builder.() -> Unit): UpdateModelResponse = updateModel(UpdateModelRequest.Builder().apply(block).build())

/**
 * Updates a Route.
 */
public suspend inline fun ApiGatewayV2Client.updateRoute(crossinline block: UpdateRouteRequest.Builder.() -> Unit): UpdateRouteResponse = updateRoute(UpdateRouteRequest.Builder().apply(block).build())

/**
 * Updates a RouteResponse.
 */
public suspend inline fun ApiGatewayV2Client.updateRouteResponse(crossinline block: UpdateRouteResponseRequest.Builder.() -> Unit): UpdateRouteResponseResponse = updateRouteResponse(UpdateRouteResponseRequest.Builder().apply(block).build())

/**
 * Updates a Stage.
 */
public suspend inline fun ApiGatewayV2Client.updateStage(crossinline block: UpdateStageRequest.Builder.() -> Unit): UpdateStageResponse = updateStage(UpdateStageRequest.Builder().apply(block).build())

/**
 * Updates a VPC link.
 */
public suspend inline fun ApiGatewayV2Client.updateVpcLink(crossinline block: UpdateVpcLinkRequest.Builder.() -> Unit): UpdateVpcLinkResponse = updateVpcLink(UpdateVpcLinkRequest.Builder().apply(block).build())
