// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.CreateVpcLinkResponse
import aws.sdk.kotlin.services.apigatewayv2.model.VpcLinkStatus
import aws.sdk.kotlin.services.apigatewayv2.model.VpcLinkVersion
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class CreateVpcLinkOperationDeserializer: HttpDeserializer.NonStreaming<CreateVpcLinkResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateVpcLinkResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateVpcLinkError(context, call, payload)
        }
        val builder = CreateVpcLinkResponse.Builder()

        if (payload != null) {
            deserializeCreateVpcLinkOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateVpcLinkError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateVpcLinkOperationBody(builder: CreateVpcLinkResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroupIds"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPCLINKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcLinkId"))
    val VPCLINKSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("vpcLinkStatus"))
    val VPCLINKSTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcLinkStatusMessage"))
    val VPCLINKVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("vpcLinkVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCLINKID_DESCRIPTOR)
        field(VPCLINKSTATUS_DESCRIPTOR)
        field(VPCLINKSTATUSMESSAGE_DESCRIPTOR)
        field(VPCLINKVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeInstant(TimestampFormat.ISO_8601)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SECURITYGROUPIDS_DESCRIPTOR.index -> builder.securityGroupIds =
                    deserializer.deserializeList(SECURITYGROUPIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUBNETIDS_DESCRIPTOR.index -> builder.subnetIds =
                    deserializer.deserializeList(SUBNETIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VPCLINKID_DESCRIPTOR.index -> builder.vpcLinkId = deserializeString()
                VPCLINKSTATUS_DESCRIPTOR.index -> builder.vpcLinkStatus = deserializeString().let { VpcLinkStatus.fromValue(it) }
                VPCLINKSTATUSMESSAGE_DESCRIPTOR.index -> builder.vpcLinkStatusMessage = deserializeString()
                VPCLINKVERSION_DESCRIPTOR.index -> builder.vpcLinkVersion = deserializeString().let { VpcLinkVersion.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
