// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Creates a new Integration resource to represent an integration.
 */
public class CreateIntegrationRequest private constructor(builder: Builder) {
    /**
     * The API identifier.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * The ID of the VPC link for a private integration. Supported only for HTTP APIs.
     */
    public val connectionId: kotlin.String? = builder.connectionId
    /**
     * The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.
     */
    public val connectionType: aws.sdk.kotlin.services.apigatewayv2.model.ConnectionType? = builder.connectionType
    /**
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     *
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     *
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     */
    public val contentHandlingStrategy: aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy? = builder.contentHandlingStrategy
    /**
     * Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user&#47;*. To use resource-based permissions on supported AWS services, specify null.
     */
    public val credentialsArn: kotlin.String? = builder.credentialsArn
    /**
     * The description of the integration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies the integration's HTTP method type.
     */
    public val integrationMethod: kotlin.String? = builder.integrationMethod
    /**
     * Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see [Integration subtype reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html).
     */
    public val integrationSubtype: kotlin.String? = builder.integrationSubtype
    /**
     * The integration type of an integration. One of the following:
     *
     * AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.
     *
     * AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.
     *
     * HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.
     *
     * HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.
     *
     * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.
     */
    public val integrationType: aws.sdk.kotlin.services.apigatewayv2.model.IntegrationType? = builder.integrationType
    /**
     * For a Lambda integration, specify the URI of a Lambda function.
     *
     * For an HTTP integration, specify a fully-qualified URL.
     *
     * For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see [DiscoverInstances](https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html). For private integrations, all resources must be owned by the same AWS account.
     */
    public val integrationUri: kotlin.String? = builder.integrationUri
    /**
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.
     *
     * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.
     *
     * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
     *
     * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.
     */
    public val passthroughBehavior: aws.sdk.kotlin.services.apigatewayv2.model.PassthroughBehavior? = builder.passthroughBehavior
    /**
     * Specifies the format of the payload sent to an integration. Required for HTTP APIs. Supported values for Lambda proxy integrations are 1.0 and 2.0. For all other integrations, 1.0 is the only supported value. To learn more, see [Working with AWS Lambda proxy integrations for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html).
     */
    public val payloadFormatVersion: kotlin.String? = builder.payloadFormatVersion
    /**
     * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}.<replaceable>{name} , where <replaceable>{location} is querystring, path, or header; and <replaceable>{name} must be a valid and unique method request parameter name.
     *
     * For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see [Working with AWS service integrations for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html).
     *
     * For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:<header|querystring|path>.<location> where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see [Transforming API requests and responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html).
     */
    public val requestParameters: Map<String, String>? = builder.requestParameters
    /**
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.
     */
    public val requestTemplates: Map<String, String>? = builder.requestTemplates
    /**
     * Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern <action>:<header>.<location> or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see [Transforming API requests and responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html).
     */
    public val responseParameters: Map<String, Map<String, String>>? = builder.responseParameters
    /**
     * The template selection expression for the integration.
     */
    public val templateSelectionExpression: kotlin.String? = builder.templateSelectionExpression
    /**
     * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     */
    public val timeoutInMillis: kotlin.Int? = builder.timeoutInMillis
    /**
     * The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
     */
    public val tlsConfig: aws.sdk.kotlin.services.apigatewayv2.model.TlsConfigInput? = builder.tlsConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIntegrationRequest(")
        append("apiId=$apiId,")
        append("connectionId=$connectionId,")
        append("connectionType=$connectionType,")
        append("contentHandlingStrategy=$contentHandlingStrategy,")
        append("credentialsArn=$credentialsArn,")
        append("description=$description,")
        append("integrationMethod=$integrationMethod,")
        append("integrationSubtype=$integrationSubtype,")
        append("integrationType=$integrationType,")
        append("integrationUri=$integrationUri,")
        append("passthroughBehavior=$passthroughBehavior,")
        append("payloadFormatVersion=$payloadFormatVersion,")
        append("requestParameters=$requestParameters,")
        append("requestTemplates=$requestTemplates,")
        append("responseParameters=$responseParameters,")
        append("templateSelectionExpression=$templateSelectionExpression,")
        append("timeoutInMillis=$timeoutInMillis,")
        append("tlsConfig=$tlsConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (connectionType?.hashCode() ?: 0)
        result = 31 * result + (contentHandlingStrategy?.hashCode() ?: 0)
        result = 31 * result + (credentialsArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (integrationMethod?.hashCode() ?: 0)
        result = 31 * result + (integrationSubtype?.hashCode() ?: 0)
        result = 31 * result + (integrationType?.hashCode() ?: 0)
        result = 31 * result + (integrationUri?.hashCode() ?: 0)
        result = 31 * result + (passthroughBehavior?.hashCode() ?: 0)
        result = 31 * result + (payloadFormatVersion?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestTemplates?.hashCode() ?: 0)
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (templateSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMillis ?: 0)
        result = 31 * result + (tlsConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIntegrationRequest

        if (apiId != other.apiId) return false
        if (connectionId != other.connectionId) return false
        if (connectionType != other.connectionType) return false
        if (contentHandlingStrategy != other.contentHandlingStrategy) return false
        if (credentialsArn != other.credentialsArn) return false
        if (description != other.description) return false
        if (integrationMethod != other.integrationMethod) return false
        if (integrationSubtype != other.integrationSubtype) return false
        if (integrationType != other.integrationType) return false
        if (integrationUri != other.integrationUri) return false
        if (passthroughBehavior != other.passthroughBehavior) return false
        if (payloadFormatVersion != other.payloadFormatVersion) return false
        if (requestParameters != other.requestParameters) return false
        if (requestTemplates != other.requestTemplates) return false
        if (responseParameters != other.responseParameters) return false
        if (templateSelectionExpression != other.templateSelectionExpression) return false
        if (timeoutInMillis != other.timeoutInMillis) return false
        if (tlsConfig != other.tlsConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The API identifier.
         */
        public var apiId: kotlin.String? = null
        /**
         * The ID of the VPC link for a private integration. Supported only for HTTP APIs.
         */
        public var connectionId: kotlin.String? = null
        /**
         * The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET.
         */
        public var connectionType: aws.sdk.kotlin.services.apigatewayv2.model.ConnectionType? = null
        /**
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         *
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         *
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *
         * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
         */
        public var contentHandlingStrategy: aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy? = null
        /**
         * Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user&#47;*. To use resource-based permissions on supported AWS services, specify null.
         */
        public var credentialsArn: kotlin.String? = null
        /**
         * The description of the integration.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies the integration's HTTP method type.
         */
        public var integrationMethod: kotlin.String? = null
        /**
         * Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see [Integration subtype reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html).
         */
        public var integrationSubtype: kotlin.String? = null
        /**
         * The integration type of an integration. One of the following:
         *
         * AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.
         *
         * AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.
         *
         * HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.
         *
         * HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration.
         *
         * MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.
         */
        public var integrationType: aws.sdk.kotlin.services.apigatewayv2.model.IntegrationType? = null
        /**
         * For a Lambda integration, specify the URI of a Lambda function.
         *
         * For an HTTP integration, specify a fully-qualified URL.
         *
         * For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see [DiscoverInstances](https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html). For private integrations, all resources must be owned by the same AWS account.
         */
        public var integrationUri: kotlin.String? = null
        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs.
         *
         * WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation.
         *
         * NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response.
         *
         * WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response.
         */
        public var passthroughBehavior: aws.sdk.kotlin.services.apigatewayv2.model.PassthroughBehavior? = null
        /**
         * Specifies the format of the payload sent to an integration. Required for HTTP APIs. Supported values for Lambda proxy integrations are 1.0 and 2.0. For all other integrations, 1.0 is the only supported value. To learn more, see [Working with AWS Lambda proxy integrations for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html).
         */
        public var payloadFormatVersion: kotlin.String? = null
        /**
         * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.<replaceable>{location}.<replaceable>{name} , where <replaceable>{location} is querystring, path, or header; and <replaceable>{name} must be a valid and unique method request parameter name.
         *
         * For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see [Working with AWS service integrations for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html).
         *
         * For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:<header|querystring|path>.<location> where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see [Transforming API requests and responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html).
         */
        public var requestParameters: Map<String, String>? = null
        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.
         */
        public var requestTemplates: Map<String, String>? = null
        /**
         * Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern <action>:<header>.<location> or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see [Transforming API requests and responses](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html).
         */
        public var responseParameters: Map<String, Map<String, String>>? = null
        /**
         * The template selection expression for the integration.
         */
        public var templateSelectionExpression: kotlin.String? = null
        /**
         * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
         */
        public var timeoutInMillis: kotlin.Int? = null
        /**
         * The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
         */
        public var tlsConfig: aws.sdk.kotlin.services.apigatewayv2.model.TlsConfigInput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationRequest) : this() {
            this.apiId = x.apiId
            this.connectionId = x.connectionId
            this.connectionType = x.connectionType
            this.contentHandlingStrategy = x.contentHandlingStrategy
            this.credentialsArn = x.credentialsArn
            this.description = x.description
            this.integrationMethod = x.integrationMethod
            this.integrationSubtype = x.integrationSubtype
            this.integrationType = x.integrationType
            this.integrationUri = x.integrationUri
            this.passthroughBehavior = x.passthroughBehavior
            this.payloadFormatVersion = x.payloadFormatVersion
            this.requestParameters = x.requestParameters
            this.requestTemplates = x.requestTemplates
            this.responseParameters = x.responseParameters
            this.templateSelectionExpression = x.templateSelectionExpression
            this.timeoutInMillis = x.timeoutInMillis
            this.tlsConfig = x.tlsConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationRequest = CreateIntegrationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.TlsConfigInput] inside the given [block]
         */
        public fun tlsConfig(block: aws.sdk.kotlin.services.apigatewayv2.model.TlsConfigInput.Builder.() -> kotlin.Unit) {
            this.tlsConfig = aws.sdk.kotlin.services.apigatewayv2.model.TlsConfigInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
