// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDeploymentStrategyRequest private constructor(builder: Builder) {
    /**
     * Total amount of time for a deployment to last.
     */
    public val deploymentDurationInMinutes: kotlin.Int? = builder.deploymentDurationInMinutes
    /**
     * A description of the deployment strategy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies the amount of time AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete. If an alarm is triggered during this time, AppConfig rolls back the deployment. You must configure permissions for AppConfig to roll back based on CloudWatch alarms. For more information, see [Configuring permissions for rollback based on Amazon CloudWatch alarms](https://docs.aws.amazon.com/appconfig/latest/userguide/getting-started-with-appconfig-cloudwatch-alarms-permissions.html) in the *AppConfig User Guide*.
     */
    public val finalBakeTimeInMinutes: kotlin.Int? = builder.finalBakeTimeInMinutes
    /**
     * The percentage of targets to receive a deployed configuration during each interval.
     */
    public val growthFactor: kotlin.Float? = builder.growthFactor
    /**
     * The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:
     *
     * **Linear**: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for `Step percentage`. For example, a linear deployment that uses a `Step percentage` of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.
     *
     * **Exponential**: For this type, AppConfig processes the deployment exponentially using the following formula: `G*(2^N)`. In this formula, `G` is the growth factor specified by the user and `N` is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
     *
     * `2*(2^0)`
     *
     * `2*(2^1)`
     *
     * `2*(2^2)`
     *
     * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
     */
    public val growthType: aws.sdk.kotlin.services.appconfig.model.GrowthType? = builder.growthType
    /**
     * A name for the deployment strategy.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Save the deployment strategy to a Systems Manager (SSM) document.
     */
    public val replicateTo: aws.sdk.kotlin.services.appconfig.model.ReplicateTo? = builder.replicateTo
    /**
     * Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.CreateDeploymentStrategyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentStrategyRequest(")
        append("deploymentDurationInMinutes=$deploymentDurationInMinutes,")
        append("description=$description,")
        append("finalBakeTimeInMinutes=$finalBakeTimeInMinutes,")
        append("growthFactor=$growthFactor,")
        append("growthType=$growthType,")
        append("name=$name,")
        append("replicateTo=$replicateTo,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentDurationInMinutes ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (finalBakeTimeInMinutes ?: 0)
        result = 31 * result + (growthFactor?.hashCode() ?: 0)
        result = 31 * result + (growthType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (replicateTo?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentStrategyRequest

        if (deploymentDurationInMinutes != other.deploymentDurationInMinutes) return false
        if (description != other.description) return false
        if (finalBakeTimeInMinutes != other.finalBakeTimeInMinutes) return false
        if (growthFactor != other.growthFactor) return false
        if (growthType != other.growthType) return false
        if (name != other.name) return false
        if (replicateTo != other.replicateTo) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.CreateDeploymentStrategyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Total amount of time for a deployment to last.
         */
        public var deploymentDurationInMinutes: kotlin.Int? = null
        /**
         * A description of the deployment strategy.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies the amount of time AppConfig monitors for Amazon CloudWatch alarms after the configuration has been deployed to 100% of its targets, before considering the deployment to be complete. If an alarm is triggered during this time, AppConfig rolls back the deployment. You must configure permissions for AppConfig to roll back based on CloudWatch alarms. For more information, see [Configuring permissions for rollback based on Amazon CloudWatch alarms](https://docs.aws.amazon.com/appconfig/latest/userguide/getting-started-with-appconfig-cloudwatch-alarms-permissions.html) in the *AppConfig User Guide*.
         */
        public var finalBakeTimeInMinutes: kotlin.Int? = null
        /**
         * The percentage of targets to receive a deployed configuration during each interval.
         */
        public var growthFactor: kotlin.Float? = null
        /**
         * The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:
         *
         * **Linear**: For this type, AppConfig processes the deployment by dividing the total number of targets by the value specified for `Step percentage`. For example, a linear deployment that uses a `Step percentage` of 10 deploys the configuration to 10 percent of the hosts. After those deployments are complete, the system deploys the configuration to the next 10 percent. This continues until 100% of the targets have successfully received the configuration.
         *
         * **Exponential**: For this type, AppConfig processes the deployment exponentially using the following formula: `G*(2^N)`. In this formula, `G` is the growth factor specified by the user and `N` is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
         *
         * `2*(2^0)`
         *
         * `2*(2^1)`
         *
         * `2*(2^2)`
         *
         * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
         */
        public var growthType: aws.sdk.kotlin.services.appconfig.model.GrowthType? = null
        /**
         * A name for the deployment strategy.
         */
        public var name: kotlin.String? = null
        /**
         * Save the deployment strategy to a Systems Manager (SSM) document.
         */
        public var replicateTo: aws.sdk.kotlin.services.appconfig.model.ReplicateTo? = null
        /**
         * Metadata to assign to the deployment strategy. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.CreateDeploymentStrategyRequest) : this() {
            this.deploymentDurationInMinutes = x.deploymentDurationInMinutes
            this.description = x.description
            this.finalBakeTimeInMinutes = x.finalBakeTimeInMinutes
            this.growthFactor = x.growthFactor
            this.growthType = x.growthType
            this.name = x.name
            this.replicateTo = x.replicateTo
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.CreateDeploymentStrategyRequest = CreateDeploymentStrategyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
