// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.serde

import aws.sdk.kotlin.services.appconfig.model.CreateHostedConfigurationVersionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateHostedConfigurationVersionOperationSerializer: HttpSerializer.NonStreaming<CreateHostedConfigurationVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateHostedConfigurationVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.configurationProfileId) { "configurationProfileId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode(input.applicationId))
                add(PercentEncoding.Path.encode("configurationprofiles"))
                add(PercentEncoding.SmithyLabel.encode(input.configurationProfileId))
                add(PercentEncoding.Path.encode("hostedconfigurationversions"))
            }
        }

        builder.headers {
            if (input.contentType?.isNotEmpty() == true) append("Content-Type", input.contentType)
            if (input.description?.isNotEmpty() == true) append("Description", input.description)
            if (input.latestVersionNumber != null) append("Latest-Version-Number", input.latestVersionNumber.toString())
            if (input.versionLabel?.isNotEmpty() == true) append("VersionLabel", input.versionLabel)
        }

        if (input.content != null) {
            builder.body = HttpBody.fromBytes(input.content)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.content == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
