// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.serde

import aws.sdk.kotlin.services.appconfig.model.AppConfigException
import aws.sdk.kotlin.services.appconfig.model.AppliedExtension
import aws.sdk.kotlin.services.appconfig.model.DeploymentEvent
import aws.sdk.kotlin.services.appconfig.model.DeploymentState
import aws.sdk.kotlin.services.appconfig.model.GrowthType
import aws.sdk.kotlin.services.appconfig.model.StopDeploymentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class StopDeploymentOperationDeserializer: HttpDeserializer.NonStreaming<StopDeploymentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StopDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStopDeploymentError(context, call, payload)
        }
        val builder = StopDeploymentResponse.Builder()

        if (payload != null) {
            deserializeStopDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStopDeploymentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppConfigException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppConfigException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStopDeploymentOperationBody(builder: StopDeploymentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationId"))
    val APPLIEDEXTENSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AppliedExtensions"))
    val COMPLETEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletedAt"))
    val CONFIGURATIONLOCATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationLocationUri"))
    val CONFIGURATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationName"))
    val CONFIGURATIONPROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationProfileId"))
    val CONFIGURATIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationVersion"))
    val DEPLOYMENTDURATIONINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DeploymentDurationInMinutes"))
    val DEPLOYMENTNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DeploymentNumber"))
    val DEPLOYMENTSTRATEGYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeploymentStrategyId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EnvironmentId"))
    val EVENTLOG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EventLog"))
    val FINALBAKETIMEINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FinalBakeTimeInMinutes"))
    val GROWTHFACTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Float, JsonSerialName("GrowthFactor"))
    val GROWTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("GrowthType"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val KMSKEYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyIdentifier"))
    val PERCENTAGECOMPLETE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Float, JsonSerialName("PercentageComplete"))
    val STARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartedAt"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val VERSIONLABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionLabel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(APPLIEDEXTENSIONS_DESCRIPTOR)
        field(COMPLETEDAT_DESCRIPTOR)
        field(CONFIGURATIONLOCATIONURI_DESCRIPTOR)
        field(CONFIGURATIONNAME_DESCRIPTOR)
        field(CONFIGURATIONPROFILEID_DESCRIPTOR)
        field(CONFIGURATIONVERSION_DESCRIPTOR)
        field(DEPLOYMENTDURATIONINMINUTES_DESCRIPTOR)
        field(DEPLOYMENTNUMBER_DESCRIPTOR)
        field(DEPLOYMENTSTRATEGYID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(EVENTLOG_DESCRIPTOR)
        field(FINALBAKETIMEINMINUTES_DESCRIPTOR)
        field(GROWTHFACTOR_DESCRIPTOR)
        field(GROWTHTYPE_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(KMSKEYIDENTIFIER_DESCRIPTOR)
        field(PERCENTAGECOMPLETE_DESCRIPTOR)
        field(STARTEDAT_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(VERSIONLABEL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                APPLIEDEXTENSIONS_DESCRIPTOR.index -> builder.appliedExtensions =
                    deserializer.deserializeList(APPLIEDEXTENSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<AppliedExtension>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAppliedExtensionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                COMPLETEDAT_DESCRIPTOR.index -> builder.completedAt = deserializeString().let { Instant.fromIso8601(it) }
                CONFIGURATIONLOCATIONURI_DESCRIPTOR.index -> builder.configurationLocationUri = deserializeString()
                CONFIGURATIONNAME_DESCRIPTOR.index -> builder.configurationName = deserializeString()
                CONFIGURATIONPROFILEID_DESCRIPTOR.index -> builder.configurationProfileId = deserializeString()
                CONFIGURATIONVERSION_DESCRIPTOR.index -> builder.configurationVersion = deserializeString()
                DEPLOYMENTDURATIONINMINUTES_DESCRIPTOR.index -> builder.deploymentDurationInMinutes = deserializeInt()
                DEPLOYMENTNUMBER_DESCRIPTOR.index -> builder.deploymentNumber = deserializeInt()
                DEPLOYMENTSTRATEGYID_DESCRIPTOR.index -> builder.deploymentStrategyId = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                EVENTLOG_DESCRIPTOR.index -> builder.eventLog =
                    deserializer.deserializeList(EVENTLOG_DESCRIPTOR) {
                        val col0 = mutableListOf<DeploymentEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeploymentEventDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FINALBAKETIMEINMINUTES_DESCRIPTOR.index -> builder.finalBakeTimeInMinutes = deserializeInt()
                GROWTHFACTOR_DESCRIPTOR.index -> builder.growthFactor = deserializeFloat()
                GROWTHTYPE_DESCRIPTOR.index -> builder.growthType = deserializeString().let { GrowthType.fromValue(it) }
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                KMSKEYIDENTIFIER_DESCRIPTOR.index -> builder.kmsKeyIdentifier = deserializeString()
                PERCENTAGECOMPLETE_DESCRIPTOR.index -> builder.percentageComplete = deserializeFloat()
                STARTEDAT_DESCRIPTOR.index -> builder.startedAt = deserializeString().let { Instant.fromIso8601(it) }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { DeploymentState.fromValue(it) }
                VERSIONLABEL_DESCRIPTOR.index -> builder.versionLabel = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
