// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A validator provides a syntactic or semantic check to ensure the configuration that you want to deploy functions as intended. To validate your application configuration data, you provide a schema or an Amazon Web Services Lambda function that runs against the configuration. The configuration deployment or update can only proceed when the configuration data is valid. For more information, see [About validators](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-profile.html#appconfig-creating-configuration-and-profile-validators) in the *AppConfig User Guide*.
 */
public class Validator private constructor(builder: Builder) {
    /**
     * Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda function.
     */
    public val content: kotlin.String = requireNotNull(builder.content) { "A non-null value must be provided for content" }
    /**
     * AppConfig supports validators of type `JSON_SCHEMA` and `LAMBDA`
     */
    public val type: aws.sdk.kotlin.services.appconfig.model.ValidatorType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.Validator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Validator(")
        append("content=*** Sensitive Data Redacted ***,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content.hashCode()
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Validator

        if (content != other.content) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.Validator = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Either the JSON Schema content or the Amazon Resource Name (ARN) of an Lambda function.
         */
        public var content: kotlin.String? = null
        /**
         * AppConfig supports validators of type `JSON_SCHEMA` and `LAMBDA`
         */
        public var type: aws.sdk.kotlin.services.appconfig.model.ValidatorType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.Validator) : this() {
            this.content = x.content
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.Validator = Validator(this)

        internal fun correctErrors(): Builder {
            if (content == null) content = ""
            if (type == null) type = ValidatorType.SdkUnknown("no value provided")
            return this
        }
    }
}
