// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that describes a deployment event.
 */
public class DeploymentEvent private constructor(builder: Builder) {
    /**
     * The list of extensions that were invoked as part of the deployment.
     */
    public val actionInvocations: List<ActionInvocation>? = builder.actionInvocations
    /**
     * A description of the deployment event. Descriptions include, but are not limited to, the following:
     * + The Amazon Web Services account or the Amazon CloudWatch alarm ARN that initiated a rollback.
     * + The percentage of hosts that received the deployment.
     * + A recommendation to attempt a new deployment (in the case of an internal error).
     */
    public val description: kotlin.String? = builder.description
    /**
     * The type of deployment event. Deployment event types include the start, stop, or completion of a deployment; a percentage update; the start or stop of a bake period; and the start or completion of a rollback.
     */
    public val eventType: aws.sdk.kotlin.services.appconfig.model.DeploymentEventType? = builder.eventType
    /**
     * The date and time the event occurred.
     */
    public val occurredAt: aws.smithy.kotlin.runtime.time.Instant? = builder.occurredAt
    /**
     * The entity that triggered the deployment event. Events can be triggered by a user, AppConfig, an Amazon CloudWatch alarm, or an internal error.
     */
    public val triggeredBy: aws.sdk.kotlin.services.appconfig.model.TriggeredBy? = builder.triggeredBy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.DeploymentEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentEvent(")
        append("actionInvocations=$actionInvocations,")
        append("description=$description,")
        append("eventType=$eventType,")
        append("occurredAt=$occurredAt,")
        append("triggeredBy=$triggeredBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionInvocations?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (occurredAt?.hashCode() ?: 0)
        result = 31 * result + (triggeredBy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentEvent

        if (actionInvocations != other.actionInvocations) return false
        if (description != other.description) return false
        if (eventType != other.eventType) return false
        if (occurredAt != other.occurredAt) return false
        if (triggeredBy != other.triggeredBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.DeploymentEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of extensions that were invoked as part of the deployment.
         */
        public var actionInvocations: List<ActionInvocation>? = null
        /**
         * A description of the deployment event. Descriptions include, but are not limited to, the following:
         * + The Amazon Web Services account or the Amazon CloudWatch alarm ARN that initiated a rollback.
         * + The percentage of hosts that received the deployment.
         * + A recommendation to attempt a new deployment (in the case of an internal error).
         */
        public var description: kotlin.String? = null
        /**
         * The type of deployment event. Deployment event types include the start, stop, or completion of a deployment; a percentage update; the start or stop of a bake period; and the start or completion of a rollback.
         */
        public var eventType: aws.sdk.kotlin.services.appconfig.model.DeploymentEventType? = null
        /**
         * The date and time the event occurred.
         */
        public var occurredAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The entity that triggered the deployment event. Events can be triggered by a user, AppConfig, an Amazon CloudWatch alarm, or an internal error.
         */
        public var triggeredBy: aws.sdk.kotlin.services.appconfig.model.TriggeredBy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.DeploymentEvent) : this() {
            this.actionInvocations = x.actionInvocations
            this.description = x.description
            this.eventType = x.eventType
            this.occurredAt = x.occurredAt
            this.triggeredBy = x.triggeredBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.DeploymentEvent = DeploymentEvent(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
