// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateConfigurationProfileRequest private constructor(builder: Builder) {
    /**
     * The application ID.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * A description of the configuration profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier for an Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for `hosted` configuration types. The identifier can be an KMS key ID, alias, or the Amazon Resource Name (ARN) of the key ID or alias. To encrypt data managed in other configuration stores, see the documentation for how to specify an KMS key for that particular service.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * A URI to locate the configuration. You can specify the following:
     * + For the AppConfig hosted configuration store and for feature flags, specify `hosted`.
     * + For an Amazon Web Services Systems Manager Parameter Store parameter, specify either the parameter name in the format `ssm-parameter://<parameter name>` or the ARN.
     * + For an Amazon Web Services CodePipeline pipeline, specify the URI in the following format: `codepipeline`://<pipeline>.
     * + For an Secrets Manager secret, specify the URI in the following format: `secretsmanager`://<secret>.
     * + For an Amazon S3 object, specify the URI in the following format: `s3://<bucket>/<objectKey> `. Here is an example: `s3://my-bucket/my-app/us-east-1/my-config.json`
     * + For an SSM document, specify either the document name in the format `ssm-document://<document name>` or the Amazon Resource Name (ARN).
     */
    public val locationUri: kotlin.String? = builder.locationUri
    /**
     * A name for the configuration profile.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of an IAM role with permission to access the configuration at the specified `LocationUri`.
     *
     * A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration.
     */
    public val retrievalRoleArn: kotlin.String? = builder.retrievalRoleArn
    /**
     * Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The type of configurations contained in the profile. AppConfig supports `feature flags` and `freeform` configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for `Type`:
     *
     * `AWS.AppConfig.FeatureFlags`
     *
     * `AWS.Freeform`
     */
    public val type: kotlin.String? = builder.type
    /**
     * A list of methods for validating the configuration.
     */
    public val validators: List<Validator>? = builder.validators

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.CreateConfigurationProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfigurationProfileRequest(")
        append("applicationId=$applicationId,")
        append("description=$description,")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("locationUri=$locationUri,")
        append("name=$name,")
        append("retrievalRoleArn=$retrievalRoleArn,")
        append("tags=$tags,")
        append("type=$type,")
        append("validators=$validators")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyIdentifier?.hashCode() ?: 0)
        result = 31 * result + (locationUri?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retrievalRoleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (validators?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConfigurationProfileRequest

        if (applicationId != other.applicationId) return false
        if (description != other.description) return false
        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (locationUri != other.locationUri) return false
        if (name != other.name) return false
        if (retrievalRoleArn != other.retrievalRoleArn) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (validators != other.validators) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.CreateConfigurationProfileRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The application ID.
         */
        public var applicationId: kotlin.String? = null
        /**
         * A description of the configuration profile.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier for an Key Management Service key to encrypt new configuration data versions in the AppConfig hosted configuration store. This attribute is only used for `hosted` configuration types. The identifier can be an KMS key ID, alias, or the Amazon Resource Name (ARN) of the key ID or alias. To encrypt data managed in other configuration stores, see the documentation for how to specify an KMS key for that particular service.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * A URI to locate the configuration. You can specify the following:
         * + For the AppConfig hosted configuration store and for feature flags, specify `hosted`.
         * + For an Amazon Web Services Systems Manager Parameter Store parameter, specify either the parameter name in the format `ssm-parameter://<parameter name>` or the ARN.
         * + For an Amazon Web Services CodePipeline pipeline, specify the URI in the following format: `codepipeline`://<pipeline>.
         * + For an Secrets Manager secret, specify the URI in the following format: `secretsmanager`://<secret>.
         * + For an Amazon S3 object, specify the URI in the following format: `s3://<bucket>/<objectKey> `. Here is an example: `s3://my-bucket/my-app/us-east-1/my-config.json`
         * + For an SSM document, specify either the document name in the format `ssm-document://<document name>` or the Amazon Resource Name (ARN).
         */
        public var locationUri: kotlin.String? = null
        /**
         * A name for the configuration profile.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of an IAM role with permission to access the configuration at the specified `LocationUri`.
         *
         * A retrieval role ARN is not required for configurations stored in the AppConfig hosted configuration store. It is required for all other sources that store your configuration.
         */
        public var retrievalRoleArn: kotlin.String? = null
        /**
         * Metadata to assign to the configuration profile. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define.
         */
        public var tags: Map<String, String>? = null
        /**
         * The type of configurations contained in the profile. AppConfig supports `feature flags` and `freeform` configurations. We recommend you create feature flag configurations to enable or disable new features and freeform configurations to distribute configurations to an application. When calling this API, enter one of the following values for `Type`:
         *
         * `AWS.AppConfig.FeatureFlags`
         *
         * `AWS.Freeform`
         */
        public var type: kotlin.String? = null
        /**
         * A list of methods for validating the configuration.
         */
        public var validators: List<Validator>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.CreateConfigurationProfileRequest) : this() {
            this.applicationId = x.applicationId
            this.description = x.description
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.locationUri = x.locationUri
            this.name = x.name
            this.retrievalRoleArn = x.retrievalRoleArn
            this.tags = x.tags
            this.type = x.type
            this.validators = x.validators
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.CreateConfigurationProfileRequest = CreateConfigurationProfileRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
