// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.serde

import aws.sdk.kotlin.services.appconfig.model.Action
import aws.sdk.kotlin.services.appconfig.model.ActionPoint
import aws.sdk.kotlin.services.appconfig.model.Parameter
import aws.sdk.kotlin.services.appconfig.model.UpdateExtensionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateExtensionOperationSerializer: HttpSerializer.NonStreaming<UpdateExtensionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateExtensionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.extensionIdentifier) { "extensionIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("extensions"))
                add(PercentEncoding.SmithyLabel.encode(input.extensionIdentifier))
            }
        }

        val payload = serializeUpdateExtensionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateExtensionOperationBody(context: ExecutionContext, input: UpdateExtensionRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Actions"))
    val ACTIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Parameters"))
    val VERSIONNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("VersionNumber"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(VERSIONNUMBER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.actions != null) {
            mapField(ACTIONS_DESCRIPTOR) {
                input.actions.forEach { (key, value) ->
                    listEntry(key.value, ACTIONS_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeSdkSerializable(asSdkSerializable(el1, ::serializeActionDocument))
                        }
                    }
                }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.parameters != null) {
            mapField(PARAMETERS_DESCRIPTOR) {
                input.parameters.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeParameterDocument)) }
            }
        }
        input.versionNumber?.let { field(VERSIONNUMBER_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
