// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An action defines the tasks that the extension performs during the AppConfig workflow. Each action includes an action point such as `ON_CREATE_HOSTED_CONFIGURATION`, `PRE_DEPLOYMENT`, or `ON_DEPLOYMENT`. Each action also includes a name, a URI to an Lambda function, and an Amazon Resource Name (ARN) for an Identity and Access Management assume role. You specify the name, URI, and ARN for each *action point* defined in the extension. You can specify the following actions for an extension:
 * + `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`
 * + `PRE_START_DEPLOYMENT`
 * + `ON_DEPLOYMENT_START`
 * + `ON_DEPLOYMENT_STEP`
 * + `ON_DEPLOYMENT_BAKING`
 * + `ON_DEPLOYMENT_COMPLETE`
 * + `ON_DEPLOYMENT_ROLLED_BACK`
 */
public class Action private constructor(builder: Builder) {
    /**
     * Information about the action.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The action name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
     */
    public val uri: kotlin.String? = builder.uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Action(")
        append("description=$description,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Action

        if (description != other.description) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.Action = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the action.
         */
        public var description: kotlin.String? = null
        /**
         * The action name.
         */
        public var name: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.Action) : this() {
            this.description = x.description
            this.name = x.name
            this.roleArn = x.roleArn
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.Action = Action(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
