// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateHostedConfigurationVersionRequest private constructor(builder: Builder) {
    /**
     * The application ID.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The configuration profile ID.
     */
    public val configurationProfileId: kotlin.String? = builder.configurationProfileId
    /**
     * The configuration data, as bytes.
     *
     * AppConfig accepts any type of data, including text formats like JSON or TOML, or binary formats like protocol buffers or compressed data.
     */
    public val content: kotlin.ByteArray? = builder.content
    /**
     * A standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * A description of the configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.
     */
    public val latestVersionNumber: kotlin.Int? = builder.latestVersionNumber
    /**
     * An optional, user-defined label for the AppConfig hosted configuration version. This value must contain at least one non-numeric character. For example, "v2.2.0".
     */
    public val versionLabel: kotlin.String? = builder.versionLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.CreateHostedConfigurationVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHostedConfigurationVersionRequest(")
        append("applicationId=$applicationId,")
        append("configurationProfileId=$configurationProfileId,")
        append("content=*** Sensitive Data Redacted ***,")
        append("contentType=$contentType,")
        append("description=$description,")
        append("latestVersionNumber=$latestVersionNumber,")
        append("versionLabel=$versionLabel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (configurationProfileId?.hashCode() ?: 0)
        result = 31 * result + (content?.contentHashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (latestVersionNumber ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHostedConfigurationVersionRequest

        if (applicationId != other.applicationId) return false
        if (configurationProfileId != other.configurationProfileId) return false
        if (content != null) {
            if (other.content == null) return false
            if (!content.contentEquals(other.content)) return false
        } else if (other.content != null) return false
        if (contentType != other.contentType) return false
        if (description != other.description) return false
        if (latestVersionNumber != other.latestVersionNumber) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.CreateHostedConfigurationVersionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The application ID.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The configuration profile ID.
         */
        public var configurationProfileId: kotlin.String? = null
        /**
         * The configuration data, as bytes.
         *
         * AppConfig accepts any type of data, including text formats like JSON or TOML, or binary formats like protocol buffers or compressed data.
         */
        public var content: kotlin.ByteArray? = null
        /**
         * A standard MIME type describing the format of the configuration content. For more information, see [Content-Type](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
         */
        public var contentType: kotlin.String? = null
        /**
         * A description of the configuration.
         */
        public var description: kotlin.String? = null
        /**
         * An optional locking token used to prevent race conditions from overwriting configuration updates when creating a new version. To ensure your data is not overwritten when creating multiple hosted configuration versions in rapid succession, specify the version number of the latest hosted configuration version.
         */
        public var latestVersionNumber: kotlin.Int? = null
        /**
         * An optional, user-defined label for the AppConfig hosted configuration version. This value must contain at least one non-numeric character. For example, "v2.2.0".
         */
        public var versionLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.CreateHostedConfigurationVersionRequest) : this() {
            this.applicationId = x.applicationId
            this.configurationProfileId = x.configurationProfileId
            this.content = x.content
            this.contentType = x.contentType
            this.description = x.description
            this.latestVersionNumber = x.latestVersionNumber
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.CreateHostedConfigurationVersionRequest = CreateHostedConfigurationVersionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
