// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.paginators

import aws.sdk.kotlin.services.appconfig.AppConfigClient
import aws.sdk.kotlin.services.appconfig.model.Application
import aws.sdk.kotlin.services.appconfig.model.ConfigurationProfileSummary
import aws.sdk.kotlin.services.appconfig.model.DeploymentStrategy
import aws.sdk.kotlin.services.appconfig.model.DeploymentSummary
import aws.sdk.kotlin.services.appconfig.model.Environment
import aws.sdk.kotlin.services.appconfig.model.ExtensionAssociationSummary
import aws.sdk.kotlin.services.appconfig.model.ExtensionSummary
import aws.sdk.kotlin.services.appconfig.model.HostedConfigurationVersionSummary
import aws.sdk.kotlin.services.appconfig.model.ListApplicationsRequest
import aws.sdk.kotlin.services.appconfig.model.ListApplicationsResponse
import aws.sdk.kotlin.services.appconfig.model.ListConfigurationProfilesRequest
import aws.sdk.kotlin.services.appconfig.model.ListConfigurationProfilesResponse
import aws.sdk.kotlin.services.appconfig.model.ListDeploymentStrategiesRequest
import aws.sdk.kotlin.services.appconfig.model.ListDeploymentStrategiesResponse
import aws.sdk.kotlin.services.appconfig.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.appconfig.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.appconfig.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.appconfig.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.appconfig.model.ListExtensionAssociationsRequest
import aws.sdk.kotlin.services.appconfig.model.ListExtensionAssociationsResponse
import aws.sdk.kotlin.services.appconfig.model.ListExtensionsRequest
import aws.sdk.kotlin.services.appconfig.model.ListExtensionsResponse
import aws.sdk.kotlin.services.appconfig.model.ListHostedConfigurationVersionsRequest
import aws.sdk.kotlin.services.appconfig.model.ListHostedConfigurationVersionsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun AppConfigClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest = ListApplicationsRequest { }): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun AppConfigClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [Application]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Application]
 */
@JvmName("listApplicationsResponseApplication")
public fun Flow<ListApplicationsResponse>.items(): Flow<Application> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConfigurationProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationProfilesResponse]
 */
public fun AppConfigClient.listConfigurationProfilesPaginated(initialRequest: ListConfigurationProfilesRequest): Flow<ListConfigurationProfilesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationProfilesPaginated.listConfigurationProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationProfilesResponse]
 */
public fun AppConfigClient.listConfigurationProfilesPaginated(block: ListConfigurationProfilesRequest.Builder.() -> Unit): Flow<ListConfigurationProfilesResponse> =
    listConfigurationProfilesPaginated(ListConfigurationProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConfigurationProfilesPaginated]
 * to access the nested member [ConfigurationProfileSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConfigurationProfileSummary]
 */
@JvmName("listConfigurationProfilesResponseConfigurationProfileSummary")
public fun Flow<ListConfigurationProfilesResponse>.items(): Flow<ConfigurationProfileSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentsResponse]
 */
public fun AppConfigClient.listDeploymentsPaginated(initialRequest: ListDeploymentsRequest): Flow<ListDeploymentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentsPaginated.listDeployments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentsResponse]
 */
public fun AppConfigClient.listDeploymentsPaginated(block: ListDeploymentsRequest.Builder.() -> Unit): Flow<ListDeploymentsResponse> =
    listDeploymentsPaginated(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentsPaginated]
 * to access the nested member [DeploymentSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeploymentSummary]
 */
@JvmName("listDeploymentsResponseDeploymentSummary")
public fun Flow<ListDeploymentsResponse>.items(): Flow<DeploymentSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDeploymentStrategiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentStrategiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentStrategiesResponse]
 */
public fun AppConfigClient.listDeploymentStrategiesPaginated(initialRequest: ListDeploymentStrategiesRequest = ListDeploymentStrategiesRequest { }): Flow<ListDeploymentStrategiesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentStrategiesPaginated.listDeploymentStrategies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentStrategiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentStrategiesResponse]
 */
public fun AppConfigClient.listDeploymentStrategiesPaginated(block: ListDeploymentStrategiesRequest.Builder.() -> Unit): Flow<ListDeploymentStrategiesResponse> =
    listDeploymentStrategiesPaginated(ListDeploymentStrategiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeploymentStrategiesPaginated]
 * to access the nested member [DeploymentStrategy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DeploymentStrategy]
 */
@JvmName("listDeploymentStrategiesResponseDeploymentStrategy")
public fun Flow<ListDeploymentStrategiesResponse>.items(): Flow<DeploymentStrategy> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun AppConfigClient.listEnvironmentsPaginated(initialRequest: ListEnvironmentsRequest): Flow<ListEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentsPaginated.listEnvironments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun AppConfigClient.listEnvironmentsPaginated(block: ListEnvironmentsRequest.Builder.() -> Unit): Flow<ListEnvironmentsResponse> =
    listEnvironmentsPaginated(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnvironmentsPaginated]
 * to access the nested member [Environment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Environment]
 */
@JvmName("listEnvironmentsResponseEnvironment")
public fun Flow<ListEnvironmentsResponse>.items(): Flow<Environment> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExtensionAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExtensionAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExtensionAssociationsResponse]
 */
public fun AppConfigClient.listExtensionAssociationsPaginated(initialRequest: ListExtensionAssociationsRequest = ListExtensionAssociationsRequest { }): Flow<ListExtensionAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExtensionAssociationsPaginated.listExtensionAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListExtensionAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExtensionAssociationsResponse]
 */
public fun AppConfigClient.listExtensionAssociationsPaginated(block: ListExtensionAssociationsRequest.Builder.() -> Unit): Flow<ListExtensionAssociationsResponse> =
    listExtensionAssociationsPaginated(ListExtensionAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExtensionAssociationsPaginated]
 * to access the nested member [ExtensionAssociationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExtensionAssociationSummary]
 */
@JvmName("listExtensionAssociationsResponseExtensionAssociationSummary")
public fun Flow<ListExtensionAssociationsResponse>.items(): Flow<ExtensionAssociationSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExtensionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExtensionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExtensionsResponse]
 */
public fun AppConfigClient.listExtensionsPaginated(initialRequest: ListExtensionsRequest = ListExtensionsRequest { }): Flow<ListExtensionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExtensionsPaginated.listExtensions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListExtensionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExtensionsResponse]
 */
public fun AppConfigClient.listExtensionsPaginated(block: ListExtensionsRequest.Builder.() -> Unit): Flow<ListExtensionsResponse> =
    listExtensionsPaginated(ListExtensionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExtensionsPaginated]
 * to access the nested member [ExtensionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ExtensionSummary]
 */
@JvmName("listExtensionsResponseExtensionSummary")
public fun Flow<ListExtensionsResponse>.items(): Flow<ExtensionSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListHostedConfigurationVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListHostedConfigurationVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHostedConfigurationVersionsResponse]
 */
public fun AppConfigClient.listHostedConfigurationVersionsPaginated(initialRequest: ListHostedConfigurationVersionsRequest): Flow<ListHostedConfigurationVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listHostedConfigurationVersionsPaginated.listHostedConfigurationVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListHostedConfigurationVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListHostedConfigurationVersionsResponse]
 */
public fun AppConfigClient.listHostedConfigurationVersionsPaginated(block: ListHostedConfigurationVersionsRequest.Builder.() -> Unit): Flow<ListHostedConfigurationVersionsResponse> =
    listHostedConfigurationVersionsPaginated(ListHostedConfigurationVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listHostedConfigurationVersionsPaginated]
 * to access the nested member [HostedConfigurationVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [HostedConfigurationVersionSummary]
 */
@JvmName("listHostedConfigurationVersionsResponseHostedConfigurationVersionSummary")
public fun Flow<ListHostedConfigurationVersionsResponse>.items(): Flow<HostedConfigurationVersionSummary> =
    transform() { response ->
        response.items?.forEach {
            emit(it)
        }
    }
