// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.serde

import aws.sdk.kotlin.services.appconfig.model.StartDeploymentRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartDeploymentOperationSerializer: HttpSerializer.NonStreaming<StartDeploymentRequest> {
    override fun serialize(context: ExecutionContext, input: StartDeploymentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.applicationId) { "applicationId is bound to the URI and must not be null" }
            requireNotNull(input.environmentId) { "environmentId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("applications"))
                add(PercentEncoding.SmithyLabel.encode(input.applicationId))
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode(input.environmentId))
                add(PercentEncoding.Path.encode("deployments"))
            }
        }

        val payload = serializeStartDeploymentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartDeploymentOperationBody(context: ExecutionContext, input: StartDeploymentRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONFIGURATIONPROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationProfileId"))
    val CONFIGURATIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConfigurationVersion"))
    val DEPLOYMENTSTRATEGYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeploymentStrategyId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DYNAMICEXTENSIONPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("DynamicExtensionParameters"))
    val KMSKEYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyIdentifier"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONPROFILEID_DESCRIPTOR)
        field(CONFIGURATIONVERSION_DESCRIPTOR)
        field(DEPLOYMENTSTRATEGYID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DYNAMICEXTENSIONPARAMETERS_DESCRIPTOR)
        field(KMSKEYIDENTIFIER_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.configurationProfileId?.let { field(CONFIGURATIONPROFILEID_DESCRIPTOR, it) }
        input.configurationVersion?.let { field(CONFIGURATIONVERSION_DESCRIPTOR, it) }
        input.deploymentStrategyId?.let { field(DEPLOYMENTSTRATEGYID_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.dynamicExtensionParameters != null) {
            mapField(DYNAMICEXTENSIONPARAMETERS_DESCRIPTOR) {
                input.dynamicExtensionParameters.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.kmsKeyIdentifier?.let { field(KMSKEYIDENTIFIER_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
