// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.serde

import aws.sdk.kotlin.services.appconfig.model.Action
import aws.sdk.kotlin.services.appconfig.model.ActionPoint
import aws.sdk.kotlin.services.appconfig.model.AppConfigException
import aws.sdk.kotlin.services.appconfig.model.Parameter
import aws.sdk.kotlin.services.appconfig.model.UpdateExtensionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateExtensionOperationDeserializer: HttpDeserializer.NonStreaming<UpdateExtensionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateExtensionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateExtensionError(context, call, payload)
        }
        val builder = UpdateExtensionResponse.Builder()

        if (payload != null) {
            deserializeUpdateExtensionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateExtensionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppConfigException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppConfigException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateExtensionOperationBody(builder: UpdateExtensionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Actions"))
    val ACTIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Parameters"))
    val VERSIONNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("VersionNumber"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONS_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(VERSIONNUMBER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONS_DESCRIPTOR.index -> builder.actions =
                    deserializer.deserializeMap(ACTIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<ActionPoint, List<Action>>()
                        while (hasNextEntry()) {
                            val k0 = ActionPoint.fromValue(key())
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(ACTIONS_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<Action>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeActionDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PARAMETERS_DESCRIPTOR.index -> builder.parameters =
                    deserializer.deserializeMap(PARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Parameter>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeParameterDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VERSIONNUMBER_DESCRIPTOR.index -> builder.versionNumber = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
