// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetConfigurationRequest private constructor(builder: Builder) {
    /**
     * The application to get. Specify either the application name or the application ID.
     */
    public val application: kotlin.String? = builder.application
    /**
     * The configuration version returned in the most recent GetConfiguration response.
     *
     * AppConfig uses the value of the `ClientConfigurationVersion` parameter to identify the configuration version on your clients. If you don’t send `ClientConfigurationVersion` with each call to GetConfiguration, your clients receive the current configuration. You are charged each time your clients receive a configuration.
     *
     * To avoid excess charges, we recommend you use the [StartConfigurationSession](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/StartConfigurationSession.html) and [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/GetLatestConfiguration.html) APIs, which track the client configuration version on your behalf. If you choose to continue using GetConfiguration, we recommend that you include the `ClientConfigurationVersion` value with every call to GetConfiguration. The value to use for `ClientConfigurationVersion` comes from the `ConfigurationVersion` attribute returned by GetConfiguration when there is new or updated data, and should be saved for subsequent calls to GetConfiguration.
     *
     * For more information about working with configurations, see [Retrieving the Configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html) in the *AppConfig User Guide*.
     */
    public val clientConfigurationVersion: kotlin.String? = builder.clientConfigurationVersion
    /**
     * The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The configuration to get. Specify either the configuration name or the configuration ID.
     */
    public val configuration: kotlin.String? = builder.configuration
    /**
     * The environment to get. Specify either the environment name or the environment ID.
     */
    public val environment: kotlin.String? = builder.environment

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.GetConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetConfigurationRequest(")
        append("application=$application,")
        append("clientConfigurationVersion=$clientConfigurationVersion,")
        append("clientId=$clientId,")
        append("configuration=$configuration,")
        append("environment=$environment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = application?.hashCode() ?: 0
        result = 31 * result + (clientConfigurationVersion?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetConfigurationRequest

        if (application != other.application) return false
        if (clientConfigurationVersion != other.clientConfigurationVersion) return false
        if (clientId != other.clientId) return false
        if (configuration != other.configuration) return false
        if (environment != other.environment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.GetConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The application to get. Specify either the application name or the application ID.
         */
        public var application: kotlin.String? = null
        /**
         * The configuration version returned in the most recent GetConfiguration response.
         *
         * AppConfig uses the value of the `ClientConfigurationVersion` parameter to identify the configuration version on your clients. If you don’t send `ClientConfigurationVersion` with each call to GetConfiguration, your clients receive the current configuration. You are charged each time your clients receive a configuration.
         *
         * To avoid excess charges, we recommend you use the [StartConfigurationSession](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/StartConfigurationSession.html) and [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/GetLatestConfiguration.html) APIs, which track the client configuration version on your behalf. If you choose to continue using GetConfiguration, we recommend that you include the `ClientConfigurationVersion` value with every call to GetConfiguration. The value to use for `ClientConfigurationVersion` comes from the `ConfigurationVersion` attribute returned by GetConfiguration when there is new or updated data, and should be saved for subsequent calls to GetConfiguration.
         *
         * For more information about working with configurations, see [Retrieving the Configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration.html) in the *AppConfig User Guide*.
         */
        public var clientConfigurationVersion: kotlin.String? = null
        /**
         * The clientId parameter in the following command is a unique, user-specified ID to identify the client for the configuration. This ID enables AppConfig to deploy the configuration in intervals, as defined in the deployment strategy.
         */
        public var clientId: kotlin.String? = null
        /**
         * The configuration to get. Specify either the configuration name or the configuration ID.
         */
        public var configuration: kotlin.String? = null
        /**
         * The environment to get. Specify either the environment name or the environment ID.
         */
        public var environment: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.GetConfigurationRequest) : this() {
            this.application = x.application
            this.clientConfigurationVersion = x.clientConfigurationVersion
            this.clientId = x.clientId
            this.configuration = x.configuration
            this.environment = x.environment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.GetConfigurationRequest = GetConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
