// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeleteConfigurationProfileRequest private constructor(builder: Builder) {
    /**
     * The application ID that includes the configuration profile you want to delete.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The ID of the configuration profile you want to delete.
     */
    public val configurationProfileId: kotlin.String? = builder.configurationProfileId
    /**
     * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a configuration profile if your application has called either [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) or for the configuration profile during the specified interval.
     *
     * This parameter supports the following values:
     * + `BYPASS`: Instructs AppConfig to bypass the deletion protection check and delete a configuration profile even if deletion protection would have otherwise prevented it.
     * + `APPLY`: Instructs the deletion protection check to run, even if deletion protection is disabled at the account level. `APPLY` also forces the deletion protection check to run against resources created in the past hour, which are normally excluded from deletion protection checks.
     * + `ACCOUNT_DEFAULT`: The default setting, which instructs AppConfig to implement the deletion protection value specified in the `UpdateAccountSettings` API.
     */
    public val deletionProtectionCheck: aws.sdk.kotlin.services.appconfig.model.DeletionProtectionCheck? = builder.deletionProtectionCheck

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.DeleteConfigurationProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteConfigurationProfileRequest(")
        append("applicationId=$applicationId,")
        append("configurationProfileId=$configurationProfileId,")
        append("deletionProtectionCheck=$deletionProtectionCheck")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (configurationProfileId?.hashCode() ?: 0)
        result = 31 * result + (deletionProtectionCheck?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteConfigurationProfileRequest

        if (applicationId != other.applicationId) return false
        if (configurationProfileId != other.configurationProfileId) return false
        if (deletionProtectionCheck != other.deletionProtectionCheck) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.DeleteConfigurationProfileRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The application ID that includes the configuration profile you want to delete.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The ID of the configuration profile you want to delete.
         */
        public var configurationProfileId: kotlin.String? = null
        /**
         * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a configuration profile if your application has called either [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) or for the configuration profile during the specified interval.
         *
         * This parameter supports the following values:
         * + `BYPASS`: Instructs AppConfig to bypass the deletion protection check and delete a configuration profile even if deletion protection would have otherwise prevented it.
         * + `APPLY`: Instructs the deletion protection check to run, even if deletion protection is disabled at the account level. `APPLY` also forces the deletion protection check to run against resources created in the past hour, which are normally excluded from deletion protection checks.
         * + `ACCOUNT_DEFAULT`: The default setting, which instructs AppConfig to implement the deletion protection value specified in the `UpdateAccountSettings` API.
         */
        public var deletionProtectionCheck: aws.sdk.kotlin.services.appconfig.model.DeletionProtectionCheck? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.DeleteConfigurationProfileRequest) : this() {
            this.applicationId = x.applicationId
            this.configurationProfileId = x.configurationProfileId
            this.deletionProtectionCheck = x.deletionProtectionCheck
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.DeleteConfigurationProfileRequest = DeleteConfigurationProfileRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
