// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetConfigurationResponse private constructor(builder: Builder) {
    /**
     * The configuration version.
     */
    public val configurationVersion: kotlin.String? = builder.configurationVersion
    /**
     * The content of the configuration or the configuration data.
     *
     * The `Content` attribute only contains data if the system finds new or updated configuration data. If there is no new or updated data and `ClientConfigurationVersion` matches the version of the current configuration, AppConfig returns a `204 No Content` HTTP response code and the `Content` value will be empty.
     */
    public val content: kotlin.ByteArray? = builder.content
    /**
     * A standard MIME type describing the format of the configuration content. For more information, see [Content-Type](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
     */
    public val contentType: kotlin.String? = builder.contentType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.GetConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetConfigurationResponse(")
        append("configurationVersion=$configurationVersion,")
        append("content=*** Sensitive Data Redacted ***,")
        append("contentType=$contentType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configurationVersion?.hashCode() ?: 0
        result = 31 * result + (content?.contentHashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetConfigurationResponse

        if (configurationVersion != other.configurationVersion) return false
        if (content != null) {
            if (other.content == null) return false
            if (!content.contentEquals(other.content)) return false
        } else if (other.content != null) return false
        if (contentType != other.contentType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.GetConfigurationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration version.
         */
        public var configurationVersion: kotlin.String? = null
        /**
         * The content of the configuration or the configuration data.
         *
         * The `Content` attribute only contains data if the system finds new or updated configuration data. If there is no new or updated data and `ClientConfigurationVersion` matches the version of the current configuration, AppConfig returns a `204 No Content` HTTP response code and the `Content` value will be empty.
         */
        public var content: kotlin.ByteArray? = null
        /**
         * A standard MIME type describing the format of the configuration content. For more information, see [Content-Type](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
         */
        public var contentType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.GetConfigurationResponse) : this() {
            this.configurationVersion = x.configurationVersion
            this.content = x.content
            this.contentType = x.contentType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.GetConfigurationResponse = GetConfigurationResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
