// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateDeploymentStrategyRequest private constructor(builder: Builder) {
    /**
     * Total amount of time for a deployment to last.
     */
    public val deploymentDurationInMinutes: kotlin.Int? = builder.deploymentDurationInMinutes
    /**
     * The deployment strategy ID.
     */
    public val deploymentStrategyId: kotlin.String? = builder.deploymentStrategyId
    /**
     * A description of the deployment strategy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.
     */
    public val finalBakeTimeInMinutes: kotlin.Int? = builder.finalBakeTimeInMinutes
    /**
     * The percentage of targets to receive a deployed configuration during each interval.
     */
    public val growthFactor: kotlin.Float? = builder.growthFactor
    /**
     * The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:
     *
     * **Linear**: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.
     *
     * **Exponential**: For this type, AppConfig processes the deployment exponentially using the following formula: `G*(2^N)`. In this formula, `G` is the growth factor specified by the user and `N` is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
     *
     * `2*(2^0)`
     *
     * `2*(2^1)`
     *
     * `2*(2^2)`
     *
     * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
     */
    public val growthType: aws.sdk.kotlin.services.appconfig.model.GrowthType? = builder.growthType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.UpdateDeploymentStrategyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDeploymentStrategyRequest(")
        append("deploymentDurationInMinutes=$deploymentDurationInMinutes,")
        append("deploymentStrategyId=$deploymentStrategyId,")
        append("description=$description,")
        append("finalBakeTimeInMinutes=$finalBakeTimeInMinutes,")
        append("growthFactor=$growthFactor,")
        append("growthType=$growthType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentDurationInMinutes ?: 0
        result = 31 * result + (deploymentStrategyId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (finalBakeTimeInMinutes ?: 0)
        result = 31 * result + (growthFactor?.hashCode() ?: 0)
        result = 31 * result + (growthType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDeploymentStrategyRequest

        if (deploymentDurationInMinutes != other.deploymentDurationInMinutes) return false
        if (deploymentStrategyId != other.deploymentStrategyId) return false
        if (description != other.description) return false
        if (finalBakeTimeInMinutes != other.finalBakeTimeInMinutes) return false
        if (!(growthFactor?.equals(other.growthFactor) ?: (other.growthFactor == null))) return false
        if (growthType != other.growthType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.UpdateDeploymentStrategyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Total amount of time for a deployment to last.
         */
        public var deploymentDurationInMinutes: kotlin.Int? = null
        /**
         * The deployment strategy ID.
         */
        public var deploymentStrategyId: kotlin.String? = null
        /**
         * A description of the deployment strategy.
         */
        public var description: kotlin.String? = null
        /**
         * The amount of time that AppConfig monitors for alarms before considering the deployment to be complete and no longer eligible for automatic rollback.
         */
        public var finalBakeTimeInMinutes: kotlin.Int? = null
        /**
         * The percentage of targets to receive a deployed configuration during each interval.
         */
        public var growthFactor: kotlin.Float? = null
        /**
         * The algorithm used to define how percentage grows over time. AppConfig supports the following growth types:
         *
         * **Linear**: For this type, AppConfig processes the deployment by increments of the growth factor evenly distributed over the deployment time. For example, a linear deployment that uses a growth factor of 20 initially makes the configuration available to 20 percent of the targets. After 1/5th of the deployment time has passed, the system updates the percentage to 40 percent. This continues until 100% of the targets are set to receive the deployed configuration.
         *
         * **Exponential**: For this type, AppConfig processes the deployment exponentially using the following formula: `G*(2^N)`. In this formula, `G` is the growth factor specified by the user and `N` is the number of steps until the configuration is deployed to all targets. For example, if you specify a growth factor of 2, then the system rolls out the configuration as follows:
         *
         * `2*(2^0)`
         *
         * `2*(2^1)`
         *
         * `2*(2^2)`
         *
         * Expressed numerically, the deployment rolls out as follows: 2% of the targets, 4% of the targets, 8% of the targets, and continues until the configuration has been deployed to all targets.
         */
        public var growthType: aws.sdk.kotlin.services.appconfig.model.GrowthType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.UpdateDeploymentStrategyRequest) : this() {
            this.deploymentDurationInMinutes = x.deploymentDurationInMinutes
            this.deploymentStrategyId = x.deploymentStrategyId
            this.description = x.description
            this.finalBakeTimeInMinutes = x.finalBakeTimeInMinutes
            this.growthFactor = x.growthFactor
            this.growthType = x.growthType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.UpdateDeploymentStrategyRequest = UpdateDeploymentStrategyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
