// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.appconfig.auth.AppConfigAuthSchemeProvider
import aws.sdk.kotlin.services.appconfig.auth.DefaultAppConfigAuthSchemeProvider
import aws.sdk.kotlin.services.appconfig.endpoints.AppConfigEndpointParameters
import aws.sdk.kotlin.services.appconfig.endpoints.AppConfigEndpointProvider
import aws.sdk.kotlin.services.appconfig.endpoints.DefaultAppConfigEndpointProvider
import aws.sdk.kotlin.services.appconfig.model.CreateApplicationRequest
import aws.sdk.kotlin.services.appconfig.model.CreateApplicationResponse
import aws.sdk.kotlin.services.appconfig.model.CreateConfigurationProfileRequest
import aws.sdk.kotlin.services.appconfig.model.CreateConfigurationProfileResponse
import aws.sdk.kotlin.services.appconfig.model.CreateDeploymentStrategyRequest
import aws.sdk.kotlin.services.appconfig.model.CreateDeploymentStrategyResponse
import aws.sdk.kotlin.services.appconfig.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.appconfig.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.appconfig.model.CreateExtensionAssociationRequest
import aws.sdk.kotlin.services.appconfig.model.CreateExtensionAssociationResponse
import aws.sdk.kotlin.services.appconfig.model.CreateExtensionRequest
import aws.sdk.kotlin.services.appconfig.model.CreateExtensionResponse
import aws.sdk.kotlin.services.appconfig.model.CreateHostedConfigurationVersionRequest
import aws.sdk.kotlin.services.appconfig.model.CreateHostedConfigurationVersionResponse
import aws.sdk.kotlin.services.appconfig.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.appconfig.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.appconfig.model.DeleteConfigurationProfileRequest
import aws.sdk.kotlin.services.appconfig.model.DeleteConfigurationProfileResponse
import aws.sdk.kotlin.services.appconfig.model.DeleteDeploymentStrategyRequest
import aws.sdk.kotlin.services.appconfig.model.DeleteDeploymentStrategyResponse
import aws.sdk.kotlin.services.appconfig.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.appconfig.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.appconfig.model.DeleteExtensionAssociationRequest
import aws.sdk.kotlin.services.appconfig.model.DeleteExtensionAssociationResponse
import aws.sdk.kotlin.services.appconfig.model.DeleteExtensionRequest
import aws.sdk.kotlin.services.appconfig.model.DeleteExtensionResponse
import aws.sdk.kotlin.services.appconfig.model.DeleteHostedConfigurationVersionRequest
import aws.sdk.kotlin.services.appconfig.model.DeleteHostedConfigurationVersionResponse
import aws.sdk.kotlin.services.appconfig.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.appconfig.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.appconfig.model.GetApplicationRequest
import aws.sdk.kotlin.services.appconfig.model.GetApplicationResponse
import aws.sdk.kotlin.services.appconfig.model.GetConfigurationProfileRequest
import aws.sdk.kotlin.services.appconfig.model.GetConfigurationProfileResponse
import aws.sdk.kotlin.services.appconfig.model.GetConfigurationRequest
import aws.sdk.kotlin.services.appconfig.model.GetConfigurationResponse
import aws.sdk.kotlin.services.appconfig.model.GetDeploymentRequest
import aws.sdk.kotlin.services.appconfig.model.GetDeploymentResponse
import aws.sdk.kotlin.services.appconfig.model.GetDeploymentStrategyRequest
import aws.sdk.kotlin.services.appconfig.model.GetDeploymentStrategyResponse
import aws.sdk.kotlin.services.appconfig.model.GetEnvironmentRequest
import aws.sdk.kotlin.services.appconfig.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.appconfig.model.GetExtensionAssociationRequest
import aws.sdk.kotlin.services.appconfig.model.GetExtensionAssociationResponse
import aws.sdk.kotlin.services.appconfig.model.GetExtensionRequest
import aws.sdk.kotlin.services.appconfig.model.GetExtensionResponse
import aws.sdk.kotlin.services.appconfig.model.GetHostedConfigurationVersionRequest
import aws.sdk.kotlin.services.appconfig.model.GetHostedConfigurationVersionResponse
import aws.sdk.kotlin.services.appconfig.model.ListApplicationsRequest
import aws.sdk.kotlin.services.appconfig.model.ListApplicationsResponse
import aws.sdk.kotlin.services.appconfig.model.ListConfigurationProfilesRequest
import aws.sdk.kotlin.services.appconfig.model.ListConfigurationProfilesResponse
import aws.sdk.kotlin.services.appconfig.model.ListDeploymentStrategiesRequest
import aws.sdk.kotlin.services.appconfig.model.ListDeploymentStrategiesResponse
import aws.sdk.kotlin.services.appconfig.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.appconfig.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.appconfig.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.appconfig.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.appconfig.model.ListExtensionAssociationsRequest
import aws.sdk.kotlin.services.appconfig.model.ListExtensionAssociationsResponse
import aws.sdk.kotlin.services.appconfig.model.ListExtensionsRequest
import aws.sdk.kotlin.services.appconfig.model.ListExtensionsResponse
import aws.sdk.kotlin.services.appconfig.model.ListHostedConfigurationVersionsRequest
import aws.sdk.kotlin.services.appconfig.model.ListHostedConfigurationVersionsResponse
import aws.sdk.kotlin.services.appconfig.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appconfig.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appconfig.model.StartDeploymentRequest
import aws.sdk.kotlin.services.appconfig.model.StartDeploymentResponse
import aws.sdk.kotlin.services.appconfig.model.StopDeploymentRequest
import aws.sdk.kotlin.services.appconfig.model.StopDeploymentResponse
import aws.sdk.kotlin.services.appconfig.model.TagResourceRequest
import aws.sdk.kotlin.services.appconfig.model.TagResourceResponse
import aws.sdk.kotlin.services.appconfig.model.UntagResourceRequest
import aws.sdk.kotlin.services.appconfig.model.UntagResourceResponse
import aws.sdk.kotlin.services.appconfig.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.appconfig.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.appconfig.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.appconfig.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.appconfig.model.UpdateConfigurationProfileRequest
import aws.sdk.kotlin.services.appconfig.model.UpdateConfigurationProfileResponse
import aws.sdk.kotlin.services.appconfig.model.UpdateDeploymentStrategyRequest
import aws.sdk.kotlin.services.appconfig.model.UpdateDeploymentStrategyResponse
import aws.sdk.kotlin.services.appconfig.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.appconfig.model.UpdateEnvironmentResponse
import aws.sdk.kotlin.services.appconfig.model.UpdateExtensionAssociationRequest
import aws.sdk.kotlin.services.appconfig.model.UpdateExtensionAssociationResponse
import aws.sdk.kotlin.services.appconfig.model.UpdateExtensionRequest
import aws.sdk.kotlin.services.appconfig.model.UpdateExtensionResponse
import aws.sdk.kotlin.services.appconfig.model.ValidateConfigurationRequest
import aws.sdk.kotlin.services.appconfig.model.ValidateConfigurationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "AppConfig"
public const val SdkVersion: String = "1.3.97"
public const val ServiceApiVersion: String = "2019-10-09"

/**
 * AppConfig feature flags and dynamic configurations help software builders quickly and securely adjust application behavior in production environments without full code deployments. AppConfig speeds up software release frequency, improves application resiliency, and helps you address emergent issues more quickly. With feature flags, you can gradually release new capabilities to users and measure the impact of those changes before fully deploying the new capabilities to all users. With operational flags and dynamic configurations, you can update block lists, allow lists, throttling limits, logging verbosity, and perform other operational tuning to quickly respond to issues in production environments.
 *
 * AppConfig is a capability of Amazon Web Services Systems Manager.
 *
 * Despite the fact that application configuration content can vary greatly from application to application, AppConfig supports the following use cases, which cover a broad spectrum of customer needs:
 * + **Feature flags and toggles** - Safely release new capabilities to your customers in a controlled environment. Instantly roll back changes if you experience a problem.
 * + **Application tuning** - Carefully introduce application changes while testing the impact of those changes with users in production environments.
 * + **Allow list or block list** - Control access to premium features or instantly block specific users without deploying new code.
 * + **Centralized configuration storage** - Keep your configuration data organized and consistent across all of your workloads. You can use AppConfig to deploy configuration data stored in the AppConfig hosted configuration store, Secrets Manager, Systems Manager, Parameter Store, or Amazon S3.
 *
 * **How AppConfig works**
 *
 * This section provides a high-level description of how AppConfig works and how you get started.
 *
 * ## 1. Identify configuration values in code you want to manage in the cloud
 * Before you start creating AppConfig artifacts, we recommend you identify configuration data in your code that you want to dynamically manage using AppConfig. Good examples include feature flags or toggles, allow and block lists, logging verbosity, service limits, and throttling rules, to name a few.
 *
 * If your configuration data already exists in the cloud, you can take advantage of AppConfig validation, deployment, and extension features to further streamline configuration data management.
 *
 * ## 2. Create an application namespace
 * To create a namespace, you create an AppConfig artifact called an application. An application is simply an organizational construct like a folder.
 *
 * ## 3. Create environments
 * For each AppConfig application, you define one or more environments. An environment is a logical grouping of targets, such as applications in a `Beta` or `Production` environment, Lambda functions, or containers. You can also define environments for application subcomponents, such as the `Web`, `Mobile`, and `Back-end`.
 *
 * You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system rolls back the configuration.
 *
 * ## 4. Create a configuration profile
 * A configuration profile includes, among other things, a URI that enables AppConfig to locate your configuration data in its stored location and a profile type. AppConfig supports two configuration profile types: feature flags and freeform configurations. Feature flag configuration profiles store their data in the AppConfig hosted configuration store and the URI is simply `hosted`. For freeform configuration profiles, you can store your data in the AppConfig hosted configuration store or any Amazon Web Services service that integrates with AppConfig, as described in [Creating a free form configuration profile](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-free-form-configurations-creating.html) in the the *AppConfig User Guide*.
 *
 * A configuration profile can also include optional validators to ensure your configuration data is syntactically and semantically correct. AppConfig performs a check using the validators when you start a deployment. If any errors are detected, the deployment rolls back to the previous configuration data.
 *
 * ## 5. Deploy configuration data
 * When you create a new deployment, you specify the following:
 * + An application ID
 * + A configuration profile ID
 * + A configuration version
 * + An environment ID where you want to deploy the configuration data
 * + A deployment strategy ID that defines how fast you want the changes to take effect
 * When you call the [StartDeployment](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_StartDeployment.html) API action, AppConfig performs the following tasks:
 * + Retrieves the configuration data from the underlying data store by using the location URI in the configuration profile.
 * + Verifies the configuration data is syntactically and semantically correct by using the validators you specified when you created your configuration profile.
 * + Caches a copy of the data so it is ready to be retrieved by your application. This cached copy is called the *deployed data*.
 *
 * ## 6. Retrieve the configuration
 * You can configure AppConfig Agent as a local host and have the agent poll AppConfig for configuration updates. The agent calls the [StartConfigurationSession](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html) and [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) API actions and caches your configuration data locally. To retrieve the data, your application makes an HTTP call to the localhost server. AppConfig Agent supports several use cases, as described in [Simplified retrieval methods](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-simplified-methods.html) in the the *AppConfig User Guide*.
 *
 * If AppConfig Agent isn't supported for your use case, you can configure your application to poll AppConfig for configuration updates by directly calling the [StartConfigurationSession](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html) and [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) API actions.
 *
 * This reference is intended to be used with the [AppConfig User Guide](http://docs.aws.amazon.com/appconfig/latest/userguide/what-is-appconfig.html).
 */
public interface AppConfigClient : SdkClient {
    /**
     * AppConfigClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppConfigClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AppConfig",
                "APPCONFIG",
                "appconfig",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppConfigClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppConfigClient = DefaultAppConfigClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppConfigEndpointProvider = builder.endpointProvider ?: DefaultAppConfigEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppConfigAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppConfigAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AppConfig"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppConfigEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppConfigAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an application. In AppConfig, an application is simply an organizational construct like a folder. This organizational construct has a relationship with some unit of executable code. For example, you could create an application called MyMobileApp to organize and manage configuration data for a mobile application installed by your users.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.CreateApplication.sample
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates a configuration profile, which is information that enables AppConfig to access the configuration source. Valid configuration sources include the following:
     * + Configuration data in YAML, JSON, and other formats stored in the AppConfig hosted configuration store
     * + Configuration data stored as objects in an Amazon Simple Storage Service (Amazon S3) bucket
     * + Pipelines stored in CodePipeline
     * + Secrets stored in Secrets Manager
     * + Standard and secure string parameters stored in Amazon Web Services Systems Manager Parameter Store
     * + Configuration data in SSM documents stored in the Systems Manager document store
     *
     * A configuration profile includes the following information:
     * + The URI location of the configuration data.
     * + The Identity and Access Management (IAM) role that provides access to the configuration data.
     * + A validator for the configuration data. Available validators include either a JSON Schema or an Amazon Web Services Lambda function.
     *
     * For more information, see [Create a Configuration and a Configuration Profile](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile.html) in the *AppConfig User Guide*.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.CreateConfigurationProfile.sample
     */
    public suspend fun createConfigurationProfile(input: CreateConfigurationProfileRequest): CreateConfigurationProfileResponse

    /**
     * Creates a deployment strategy that defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.CreateDeploymentStrategy.sample
     */
    public suspend fun createDeploymentStrategy(input: CreateDeploymentStrategyRequest): CreateDeploymentStrategyResponse

    /**
     * Creates an environment. For each application, you define one or more environments. An environment is a deployment group of AppConfig targets, such as applications in a `Beta` or `Production` environment. You can also define environments for application subcomponents such as the `Web`, `Mobile` and `Back-end` components for your application. You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system rolls back the configuration.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.CreateEnvironment.sample
     */
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Creates an AppConfig extension. An extension augments your ability to inject logic or behavior at different points during the AppConfig workflow of creating or deploying a configuration.
     *
     * You can create your own extensions or use the Amazon Web Services authored extensions provided by AppConfig. For an AppConfig extension that uses Lambda, you must create a Lambda function to perform any computation and processing defined in the extension. If you plan to create custom versions of the Amazon Web Services authored notification extensions, you only need to specify an Amazon Resource Name (ARN) in the `Uri` field for the new extension version.
     * + For a custom EventBridge notification extension, enter the ARN of the EventBridge default events in the `Uri` field.
     * + For a custom Amazon SNS notification extension, enter the ARN of an Amazon SNS topic in the `Uri` field.
     * + For a custom Amazon SQS notification extension, enter the ARN of an Amazon SQS message queue in the `Uri` field.
     *
     * For more information about extensions, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
     */
    public suspend fun createExtension(input: CreateExtensionRequest): CreateExtensionResponse

    /**
     * When you create an extension or configure an Amazon Web Services authored extension, you associate the extension with an AppConfig application, environment, or configuration profile. For example, you can choose to run the `AppConfig deployment events to Amazon SNS` Amazon Web Services authored extension and receive notifications on an Amazon SNS topic anytime a configuration deployment is started for a specific application. Defining which extension to associate with an AppConfig resource is called an *extension association*. An extension association is a specified relationship between an extension and an AppConfig resource, such as an application or a configuration profile. For more information about extensions and associations, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
     */
    public suspend fun createExtensionAssociation(input: CreateExtensionAssociationRequest): CreateExtensionAssociationResponse

    /**
     * Creates a new configuration in the AppConfig hosted configuration store. If you're creating a feature flag, we recommend you familiarize yourself with the JSON schema for feature flag data. For more information, see [Type reference for AWS.AppConfig.FeatureFlags](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile-feature-flags.html#appconfig-type-reference-feature-flags) in the *AppConfig User Guide*.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.CreateHostedConfigurationVersion.sample
     */
    public suspend fun createHostedConfigurationVersion(input: CreateHostedConfigurationVersionRequest): CreateHostedConfigurationVersionResponse

    /**
     * Deletes an application.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteApplication.sample
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes a configuration profile.
     *
     * To prevent users from unintentionally deleting actively-used configuration profiles, enable [deletion protection](https://docs.aws.amazon.com/appconfig/latest/userguide/deletion-protection.html).
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteConfigurationProfile.sample
     */
    public suspend fun deleteConfigurationProfile(input: DeleteConfigurationProfileRequest): DeleteConfigurationProfileResponse

    /**
     * Deletes a deployment strategy.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteDeploymentStrategy.sample
     */
    public suspend fun deleteDeploymentStrategy(input: DeleteDeploymentStrategyRequest): DeleteDeploymentStrategyResponse

    /**
     * Deletes an environment.
     *
     * To prevent users from unintentionally deleting actively-used environments, enable [deletion protection](https://docs.aws.amazon.com/appconfig/latest/userguide/deletion-protection.html).
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteEnvironment.sample
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes an AppConfig extension. You must delete all associations to an extension before you delete the extension.
     */
    public suspend fun deleteExtension(input: DeleteExtensionRequest): DeleteExtensionResponse

    /**
     * Deletes an extension association. This action doesn't delete extensions defined in the association.
     */
    public suspend fun deleteExtensionAssociation(input: DeleteExtensionAssociationRequest): DeleteExtensionAssociationResponse

    /**
     * Deletes a version of a configuration from the AppConfig hosted configuration store.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteHostedConfigurationVersion.sample
     */
    public suspend fun deleteHostedConfigurationVersion(input: DeleteHostedConfigurationVersionRequest): DeleteHostedConfigurationVersionResponse

    /**
     * Returns information about the status of the `DeletionProtection` parameter.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest = GetAccountSettingsRequest { }): GetAccountSettingsResponse

    /**
     * Retrieves information about an application.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.GetApplication.sample
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * (Deprecated) Retrieves the latest deployed configuration.
     *
     * Note the following important information.
     * + This API action is deprecated. Calls to receive configuration data should use the [StartConfigurationSession](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html) and [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) APIs instead.
     * + GetConfiguration is a priced call. For more information, see [Pricing](https://aws.amazon.com/systems-manager/pricing/).
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.GetConfiguration.sample
     */
    @Deprecated("This API has been deprecated in favor of the GetLatestConfiguration API used in conjunction with StartConfigurationSession.")
    public suspend fun getConfiguration(input: GetConfigurationRequest): GetConfigurationResponse

    /**
     * Retrieves information about a configuration profile.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.GetConfigurationProfile.sample
     */
    public suspend fun getConfigurationProfile(input: GetConfigurationProfileRequest): GetConfigurationProfileResponse

    /**
     * Retrieves information about a configuration deployment.
     */
    public suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Retrieves information about a deployment strategy. A deployment strategy defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.GetDeploymentStrategy.sample
     */
    public suspend fun getDeploymentStrategy(input: GetDeploymentStrategyRequest): GetDeploymentStrategyResponse

    /**
     * Retrieves information about an environment. An environment is a deployment group of AppConfig applications, such as applications in a `Production` environment or in an `EU_Region` environment. Each configuration deployment targets an environment. You can enable one or more Amazon CloudWatch alarms for an environment. If an alarm is triggered during a deployment, AppConfig roles back the configuration.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.GetEnvironment.sample
     */
    public suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse

    /**
     * Returns information about an AppConfig extension.
     */
    public suspend fun getExtension(input: GetExtensionRequest): GetExtensionResponse

    /**
     * Returns information about an AppConfig extension association. For more information about extensions and associations, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
     */
    public suspend fun getExtensionAssociation(input: GetExtensionAssociationRequest): GetExtensionAssociationResponse

    /**
     * Retrieves information about a specific configuration version.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.GetHostedConfigurationVersion.sample
     */
    public suspend fun getHostedConfigurationVersion(input: GetHostedConfigurationVersionRequest): GetHostedConfigurationVersionResponse

    /**
     * Lists all applications in your Amazon Web Services account.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.ListApplications.sample
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Lists the configuration profiles for an application.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.ListConfigurationProfiles.sample
     */
    public suspend fun listConfigurationProfiles(input: ListConfigurationProfilesRequest): ListConfigurationProfilesResponse

    /**
     * Lists deployment strategies.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.ListDeploymentStrategies.sample
     */
    public suspend fun listDeploymentStrategies(input: ListDeploymentStrategiesRequest = ListDeploymentStrategiesRequest { }): ListDeploymentStrategiesResponse

    /**
     * Lists the deployments for an environment in descending deployment number order.
     */
    public suspend fun listDeployments(input: ListDeploymentsRequest): ListDeploymentsResponse

    /**
     * Lists the environments for an application.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.ListEnvironments.sample
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest): ListEnvironmentsResponse

    /**
     * Lists all AppConfig extension associations in the account. For more information about extensions and associations, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
     */
    public suspend fun listExtensionAssociations(input: ListExtensionAssociationsRequest = ListExtensionAssociationsRequest { }): ListExtensionAssociationsResponse

    /**
     * Lists all custom and Amazon Web Services authored AppConfig extensions in the account. For more information about extensions, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
     */
    public suspend fun listExtensions(input: ListExtensionsRequest = ListExtensionsRequest { }): ListExtensionsResponse

    /**
     * Lists configurations stored in the AppConfig hosted configuration store by version.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.ListHostedConfigurationVersions.sample
     */
    public suspend fun listHostedConfigurationVersions(input: ListHostedConfigurationVersionsRequest): ListHostedConfigurationVersionsResponse

    /**
     * Retrieves the list of key-value tags assigned to the resource.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts a deployment.
     */
    public suspend fun startDeployment(input: StartDeploymentRequest): StartDeploymentResponse

    /**
     * Stops a deployment. This API action works only on deployments that have a status of `DEPLOYING`, unless an `AllowRevert` parameter is supplied. If the `AllowRevert` parameter is supplied, the status of an in-progress deployment will be `ROLLED_BACK`. The status of a completed deployment will be `REVERTED`. AppConfig only allows a revert within 72 hours of deployment completion.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.StopDeployment.sample
     */
    public suspend fun stopDeployment(input: StopDeploymentRequest): StopDeploymentResponse

    /**
     * Assigns metadata to an AppConfig resource. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.TagResource.sample
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes a tag key and value from an AppConfig resource.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.UntagResource.sample
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the value of the `DeletionProtection` parameter.
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest = UpdateAccountSettingsRequest { }): UpdateAccountSettingsResponse

    /**
     * Updates an application.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.UpdateApplication.sample
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates a configuration profile.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.UpdateConfigurationProfile.sample
     */
    public suspend fun updateConfigurationProfile(input: UpdateConfigurationProfileRequest): UpdateConfigurationProfileResponse

    /**
     * Updates a deployment strategy.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.UpdateDeploymentStrategy.sample
     */
    public suspend fun updateDeploymentStrategy(input: UpdateDeploymentStrategyRequest): UpdateDeploymentStrategyResponse

    /**
     * Updates an environment.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.UpdateEnvironment.sample
     */
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * Updates an AppConfig extension. For more information about extensions, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
     */
    public suspend fun updateExtension(input: UpdateExtensionRequest): UpdateExtensionResponse

    /**
     * Updates an association. For more information about extensions and associations, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
     */
    public suspend fun updateExtensionAssociation(input: UpdateExtensionAssociationRequest): UpdateExtensionAssociationResponse

    /**
     * Uses the validators in a configuration profile to validate a configuration.
     *
     * @sample aws.sdk.kotlin.services.appconfig.samples.ValidateConfiguration.sample
     */
    public suspend fun validateConfiguration(input: ValidateConfigurationRequest): ValidateConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppConfigClient.withConfig(block: AppConfigClient.Config.Builder.() -> Unit): AppConfigClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppConfigClient(newConfig)
}

/**
 * Creates an application. In AppConfig, an application is simply an organizational construct like a folder. This organizational construct has a relationship with some unit of executable code. For example, you could create an application called MyMobileApp to organize and manage configuration data for a mobile application installed by your users.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.CreateApplication.sample
 */
public suspend inline fun AppConfigClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates a configuration profile, which is information that enables AppConfig to access the configuration source. Valid configuration sources include the following:
 * + Configuration data in YAML, JSON, and other formats stored in the AppConfig hosted configuration store
 * + Configuration data stored as objects in an Amazon Simple Storage Service (Amazon S3) bucket
 * + Pipelines stored in CodePipeline
 * + Secrets stored in Secrets Manager
 * + Standard and secure string parameters stored in Amazon Web Services Systems Manager Parameter Store
 * + Configuration data in SSM documents stored in the Systems Manager document store
 *
 * A configuration profile includes the following information:
 * + The URI location of the configuration data.
 * + The Identity and Access Management (IAM) role that provides access to the configuration data.
 * + A validator for the configuration data. Available validators include either a JSON Schema or an Amazon Web Services Lambda function.
 *
 * For more information, see [Create a Configuration and a Configuration Profile](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile.html) in the *AppConfig User Guide*.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.CreateConfigurationProfile.sample
 */
public suspend inline fun AppConfigClient.createConfigurationProfile(crossinline block: CreateConfigurationProfileRequest.Builder.() -> Unit): CreateConfigurationProfileResponse = createConfigurationProfile(CreateConfigurationProfileRequest.Builder().apply(block).build())

/**
 * Creates a deployment strategy that defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.CreateDeploymentStrategy.sample
 */
public suspend inline fun AppConfigClient.createDeploymentStrategy(crossinline block: CreateDeploymentStrategyRequest.Builder.() -> Unit): CreateDeploymentStrategyResponse = createDeploymentStrategy(CreateDeploymentStrategyRequest.Builder().apply(block).build())

/**
 * Creates an environment. For each application, you define one or more environments. An environment is a deployment group of AppConfig targets, such as applications in a `Beta` or `Production` environment. You can also define environments for application subcomponents such as the `Web`, `Mobile` and `Back-end` components for your application. You can configure Amazon CloudWatch alarms for each environment. The system monitors alarms during a configuration deployment. If an alarm is triggered, the system rolls back the configuration.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.CreateEnvironment.sample
 */
public suspend inline fun AppConfigClient.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates an AppConfig extension. An extension augments your ability to inject logic or behavior at different points during the AppConfig workflow of creating or deploying a configuration.
 *
 * You can create your own extensions or use the Amazon Web Services authored extensions provided by AppConfig. For an AppConfig extension that uses Lambda, you must create a Lambda function to perform any computation and processing defined in the extension. If you plan to create custom versions of the Amazon Web Services authored notification extensions, you only need to specify an Amazon Resource Name (ARN) in the `Uri` field for the new extension version.
 * + For a custom EventBridge notification extension, enter the ARN of the EventBridge default events in the `Uri` field.
 * + For a custom Amazon SNS notification extension, enter the ARN of an Amazon SNS topic in the `Uri` field.
 * + For a custom Amazon SQS notification extension, enter the ARN of an Amazon SQS message queue in the `Uri` field.
 *
 * For more information about extensions, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
 */
public suspend inline fun AppConfigClient.createExtension(crossinline block: CreateExtensionRequest.Builder.() -> Unit): CreateExtensionResponse = createExtension(CreateExtensionRequest.Builder().apply(block).build())

/**
 * When you create an extension or configure an Amazon Web Services authored extension, you associate the extension with an AppConfig application, environment, or configuration profile. For example, you can choose to run the `AppConfig deployment events to Amazon SNS` Amazon Web Services authored extension and receive notifications on an Amazon SNS topic anytime a configuration deployment is started for a specific application. Defining which extension to associate with an AppConfig resource is called an *extension association*. An extension association is a specified relationship between an extension and an AppConfig resource, such as an application or a configuration profile. For more information about extensions and associations, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
 */
public suspend inline fun AppConfigClient.createExtensionAssociation(crossinline block: CreateExtensionAssociationRequest.Builder.() -> Unit): CreateExtensionAssociationResponse = createExtensionAssociation(CreateExtensionAssociationRequest.Builder().apply(block).build())

/**
 * Creates a new configuration in the AppConfig hosted configuration store. If you're creating a feature flag, we recommend you familiarize yourself with the JSON schema for feature flag data. For more information, see [Type reference for AWS.AppConfig.FeatureFlags](https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-configuration-and-profile-feature-flags.html#appconfig-type-reference-feature-flags) in the *AppConfig User Guide*.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.CreateHostedConfigurationVersion.sample
 */
public suspend inline fun AppConfigClient.createHostedConfigurationVersion(crossinline block: CreateHostedConfigurationVersionRequest.Builder.() -> Unit): CreateHostedConfigurationVersionResponse = createHostedConfigurationVersion(CreateHostedConfigurationVersionRequest.Builder().apply(block).build())

/**
 * Deletes an application.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteApplication.sample
 */
public suspend inline fun AppConfigClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a configuration profile.
 *
 * To prevent users from unintentionally deleting actively-used configuration profiles, enable [deletion protection](https://docs.aws.amazon.com/appconfig/latest/userguide/deletion-protection.html).
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteConfigurationProfile.sample
 */
public suspend inline fun AppConfigClient.deleteConfigurationProfile(crossinline block: DeleteConfigurationProfileRequest.Builder.() -> Unit): DeleteConfigurationProfileResponse = deleteConfigurationProfile(DeleteConfigurationProfileRequest.Builder().apply(block).build())

/**
 * Deletes a deployment strategy.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteDeploymentStrategy.sample
 */
public suspend inline fun AppConfigClient.deleteDeploymentStrategy(crossinline block: DeleteDeploymentStrategyRequest.Builder.() -> Unit): DeleteDeploymentStrategyResponse = deleteDeploymentStrategy(DeleteDeploymentStrategyRequest.Builder().apply(block).build())

/**
 * Deletes an environment.
 *
 * To prevent users from unintentionally deleting actively-used environments, enable [deletion protection](https://docs.aws.amazon.com/appconfig/latest/userguide/deletion-protection.html).
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteEnvironment.sample
 */
public suspend inline fun AppConfigClient.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes an AppConfig extension. You must delete all associations to an extension before you delete the extension.
 */
public suspend inline fun AppConfigClient.deleteExtension(crossinline block: DeleteExtensionRequest.Builder.() -> Unit): DeleteExtensionResponse = deleteExtension(DeleteExtensionRequest.Builder().apply(block).build())

/**
 * Deletes an extension association. This action doesn't delete extensions defined in the association.
 */
public suspend inline fun AppConfigClient.deleteExtensionAssociation(crossinline block: DeleteExtensionAssociationRequest.Builder.() -> Unit): DeleteExtensionAssociationResponse = deleteExtensionAssociation(DeleteExtensionAssociationRequest.Builder().apply(block).build())

/**
 * Deletes a version of a configuration from the AppConfig hosted configuration store.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.DeleteHostedConfigurationVersion.sample
 */
public suspend inline fun AppConfigClient.deleteHostedConfigurationVersion(crossinline block: DeleteHostedConfigurationVersionRequest.Builder.() -> Unit): DeleteHostedConfigurationVersionResponse = deleteHostedConfigurationVersion(DeleteHostedConfigurationVersionRequest.Builder().apply(block).build())

/**
 * Returns information about the status of the `DeletionProtection` parameter.
 */
public suspend inline fun AppConfigClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Retrieves information about an application.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.GetApplication.sample
 */
public suspend inline fun AppConfigClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * (Deprecated) Retrieves the latest deployed configuration.
 *
 * Note the following important information.
 * + This API action is deprecated. Calls to receive configuration data should use the [StartConfigurationSession](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_StartConfigurationSession.html) and [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) APIs instead.
 * + GetConfiguration is a priced call. For more information, see [Pricing](https://aws.amazon.com/systems-manager/pricing/).
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.GetConfiguration.sample
 */
@Deprecated("This API has been deprecated in favor of the GetLatestConfiguration API used in conjunction with StartConfigurationSession.")
public suspend inline fun AppConfigClient.getConfiguration(crossinline block: GetConfigurationRequest.Builder.() -> Unit): GetConfigurationResponse = getConfiguration(GetConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about a configuration profile.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.GetConfigurationProfile.sample
 */
public suspend inline fun AppConfigClient.getConfigurationProfile(crossinline block: GetConfigurationProfileRequest.Builder.() -> Unit): GetConfigurationProfileResponse = getConfigurationProfile(GetConfigurationProfileRequest.Builder().apply(block).build())

/**
 * Retrieves information about a configuration deployment.
 */
public suspend inline fun AppConfigClient.getDeployment(crossinline block: GetDeploymentRequest.Builder.() -> Unit): GetDeploymentResponse = getDeployment(GetDeploymentRequest.Builder().apply(block).build())

/**
 * Retrieves information about a deployment strategy. A deployment strategy defines important criteria for rolling out your configuration to the designated targets. A deployment strategy includes the overall duration required, a percentage of targets to receive the deployment during each interval, an algorithm that defines how percentage grows, and bake time.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.GetDeploymentStrategy.sample
 */
public suspend inline fun AppConfigClient.getDeploymentStrategy(crossinline block: GetDeploymentStrategyRequest.Builder.() -> Unit): GetDeploymentStrategyResponse = getDeploymentStrategy(GetDeploymentStrategyRequest.Builder().apply(block).build())

/**
 * Retrieves information about an environment. An environment is a deployment group of AppConfig applications, such as applications in a `Production` environment or in an `EU_Region` environment. Each configuration deployment targets an environment. You can enable one or more Amazon CloudWatch alarms for an environment. If an alarm is triggered during a deployment, AppConfig roles back the configuration.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.GetEnvironment.sample
 */
public suspend inline fun AppConfigClient.getEnvironment(crossinline block: GetEnvironmentRequest.Builder.() -> Unit): GetEnvironmentResponse = getEnvironment(GetEnvironmentRequest.Builder().apply(block).build())

/**
 * Returns information about an AppConfig extension.
 */
public suspend inline fun AppConfigClient.getExtension(crossinline block: GetExtensionRequest.Builder.() -> Unit): GetExtensionResponse = getExtension(GetExtensionRequest.Builder().apply(block).build())

/**
 * Returns information about an AppConfig extension association. For more information about extensions and associations, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
 */
public suspend inline fun AppConfigClient.getExtensionAssociation(crossinline block: GetExtensionAssociationRequest.Builder.() -> Unit): GetExtensionAssociationResponse = getExtensionAssociation(GetExtensionAssociationRequest.Builder().apply(block).build())

/**
 * Retrieves information about a specific configuration version.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.GetHostedConfigurationVersion.sample
 */
public suspend inline fun AppConfigClient.getHostedConfigurationVersion(crossinline block: GetHostedConfigurationVersionRequest.Builder.() -> Unit): GetHostedConfigurationVersionResponse = getHostedConfigurationVersion(GetHostedConfigurationVersionRequest.Builder().apply(block).build())

/**
 * Lists all applications in your Amazon Web Services account.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.ListApplications.sample
 */
public suspend inline fun AppConfigClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the configuration profiles for an application.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.ListConfigurationProfiles.sample
 */
public suspend inline fun AppConfigClient.listConfigurationProfiles(crossinline block: ListConfigurationProfilesRequest.Builder.() -> Unit): ListConfigurationProfilesResponse = listConfigurationProfiles(ListConfigurationProfilesRequest.Builder().apply(block).build())

/**
 * Lists deployment strategies.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.ListDeploymentStrategies.sample
 */
public suspend inline fun AppConfigClient.listDeploymentStrategies(crossinline block: ListDeploymentStrategiesRequest.Builder.() -> Unit): ListDeploymentStrategiesResponse = listDeploymentStrategies(ListDeploymentStrategiesRequest.Builder().apply(block).build())

/**
 * Lists the deployments for an environment in descending deployment number order.
 */
public suspend inline fun AppConfigClient.listDeployments(crossinline block: ListDeploymentsRequest.Builder.() -> Unit): ListDeploymentsResponse = listDeployments(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * Lists the environments for an application.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.ListEnvironments.sample
 */
public suspend inline fun AppConfigClient.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Lists all AppConfig extension associations in the account. For more information about extensions and associations, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
 */
public suspend inline fun AppConfigClient.listExtensionAssociations(crossinline block: ListExtensionAssociationsRequest.Builder.() -> Unit): ListExtensionAssociationsResponse = listExtensionAssociations(ListExtensionAssociationsRequest.Builder().apply(block).build())

/**
 * Lists all custom and Amazon Web Services authored AppConfig extensions in the account. For more information about extensions, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
 */
public suspend inline fun AppConfigClient.listExtensions(crossinline block: ListExtensionsRequest.Builder.() -> Unit): ListExtensionsResponse = listExtensions(ListExtensionsRequest.Builder().apply(block).build())

/**
 * Lists configurations stored in the AppConfig hosted configuration store by version.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.ListHostedConfigurationVersions.sample
 */
public suspend inline fun AppConfigClient.listHostedConfigurationVersions(crossinline block: ListHostedConfigurationVersionsRequest.Builder.() -> Unit): ListHostedConfigurationVersionsResponse = listHostedConfigurationVersions(ListHostedConfigurationVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of key-value tags assigned to the resource.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.ListTagsForResource.sample
 */
public suspend inline fun AppConfigClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts a deployment.
 */
public suspend inline fun AppConfigClient.startDeployment(crossinline block: StartDeploymentRequest.Builder.() -> Unit): StartDeploymentResponse = startDeployment(StartDeploymentRequest.Builder().apply(block).build())

/**
 * Stops a deployment. This API action works only on deployments that have a status of `DEPLOYING`, unless an `AllowRevert` parameter is supplied. If the `AllowRevert` parameter is supplied, the status of an in-progress deployment will be `ROLLED_BACK`. The status of a completed deployment will be `REVERTED`. AppConfig only allows a revert within 72 hours of deployment completion.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.StopDeployment.sample
 */
public suspend inline fun AppConfigClient.stopDeployment(crossinline block: StopDeploymentRequest.Builder.() -> Unit): StopDeploymentResponse = stopDeployment(StopDeploymentRequest.Builder().apply(block).build())

/**
 * Assigns metadata to an AppConfig resource. Tags help organize and categorize your AppConfig resources. Each tag consists of a key and an optional value, both of which you define. You can specify a maximum of 50 tags for a resource.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.TagResource.sample
 */
public suspend inline fun AppConfigClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes a tag key and value from an AppConfig resource.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.UntagResource.sample
 */
public suspend inline fun AppConfigClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the value of the `DeletionProtection` parameter.
 */
public suspend inline fun AppConfigClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Updates an application.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.UpdateApplication.sample
 */
public suspend inline fun AppConfigClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates a configuration profile.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.UpdateConfigurationProfile.sample
 */
public suspend inline fun AppConfigClient.updateConfigurationProfile(crossinline block: UpdateConfigurationProfileRequest.Builder.() -> Unit): UpdateConfigurationProfileResponse = updateConfigurationProfile(UpdateConfigurationProfileRequest.Builder().apply(block).build())

/**
 * Updates a deployment strategy.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.UpdateDeploymentStrategy.sample
 */
public suspend inline fun AppConfigClient.updateDeploymentStrategy(crossinline block: UpdateDeploymentStrategyRequest.Builder.() -> Unit): UpdateDeploymentStrategyResponse = updateDeploymentStrategy(UpdateDeploymentStrategyRequest.Builder().apply(block).build())

/**
 * Updates an environment.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.UpdateEnvironment.sample
 */
public suspend inline fun AppConfigClient.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

/**
 * Updates an AppConfig extension. For more information about extensions, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
 */
public suspend inline fun AppConfigClient.updateExtension(crossinline block: UpdateExtensionRequest.Builder.() -> Unit): UpdateExtensionResponse = updateExtension(UpdateExtensionRequest.Builder().apply(block).build())

/**
 * Updates an association. For more information about extensions and associations, see [Extending workflows](https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions.html) in the *AppConfig User Guide*.
 */
public suspend inline fun AppConfigClient.updateExtensionAssociation(crossinline block: UpdateExtensionAssociationRequest.Builder.() -> Unit): UpdateExtensionAssociationResponse = updateExtensionAssociation(UpdateExtensionAssociationRequest.Builder().apply(block).build())

/**
 * Uses the validators in a configuration profile to validate a configuration.
 *
 * @sample aws.sdk.kotlin.services.appconfig.samples.ValidateConfiguration.sample
 */
public suspend inline fun AppConfigClient.validateConfiguration(crossinline block: ValidateConfigurationRequest.Builder.() -> Unit): ValidateConfigurationResponse = validateConfiguration(ValidateConfigurationRequest.Builder().apply(block).build())
