// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.serde

import aws.sdk.kotlin.services.appconfig.model.AppConfigException
import aws.sdk.kotlin.services.appconfig.model.CreateHostedConfigurationVersionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateHostedConfigurationVersionOperationDeserializer: HttpDeserializer.NonStreaming<CreateHostedConfigurationVersionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateHostedConfigurationVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateHostedConfigurationVersionError(context, call, payload)
        }
        val builder = CreateHostedConfigurationVersionResponse.Builder()

        builder.applicationId = response.headers["Application-Id"]
        builder.configurationProfileId = response.headers["Configuration-Profile-Id"]
        builder.contentType = response.headers["Content-Type"]
        builder.description = response.headers["Description"]
        builder.kmsKeyArn = response.headers["KmsKeyArn"]
        builder.versionLabel = response.headers["VersionLabel"]
        builder.versionNumber = response.headers["Version-Number"]?.toInt() ?: 0

        builder.content = payload

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateHostedConfigurationVersionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppConfigException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PayloadTooLargeException" -> PayloadTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppConfigException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
