// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeleteEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The application ID that includes the environment that you want to delete.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting an environment if your application called either [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) or in the environment during the specified interval.
     *
     * This parameter supports the following values:
     * + `BYPASS`: Instructs AppConfig to bypass the deletion protection check and delete a configuration profile even if deletion protection would have otherwise prevented it.
     * + `APPLY`: Instructs the deletion protection check to run, even if deletion protection is disabled at the account level. `APPLY` also forces the deletion protection check to run against resources created in the past hour, which are normally excluded from deletion protection checks.
     * + `ACCOUNT_DEFAULT`: The default setting, which instructs AppConfig to implement the deletion protection value specified in the `UpdateAccountSettings` API.
     */
    public val deletionProtectionCheck: aws.sdk.kotlin.services.appconfig.model.DeletionProtectionCheck? = builder.deletionProtectionCheck
    /**
     * The ID of the environment that you want to delete.
     */
    public val environmentId: kotlin.String? = builder.environmentId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.DeleteEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteEnvironmentRequest(")
        append("applicationId=$applicationId,")
        append("deletionProtectionCheck=$deletionProtectionCheck,")
        append("environmentId=$environmentId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (deletionProtectionCheck?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteEnvironmentRequest

        if (applicationId != other.applicationId) return false
        if (deletionProtectionCheck != other.deletionProtectionCheck) return false
        if (environmentId != other.environmentId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.DeleteEnvironmentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The application ID that includes the environment that you want to delete.
         */
        public var applicationId: kotlin.String? = null
        /**
         * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting an environment if your application called either [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) or in the environment during the specified interval.
         *
         * This parameter supports the following values:
         * + `BYPASS`: Instructs AppConfig to bypass the deletion protection check and delete a configuration profile even if deletion protection would have otherwise prevented it.
         * + `APPLY`: Instructs the deletion protection check to run, even if deletion protection is disabled at the account level. `APPLY` also forces the deletion protection check to run against resources created in the past hour, which are normally excluded from deletion protection checks.
         * + `ACCOUNT_DEFAULT`: The default setting, which instructs AppConfig to implement the deletion protection value specified in the `UpdateAccountSettings` API.
         */
        public var deletionProtectionCheck: aws.sdk.kotlin.services.appconfig.model.DeletionProtectionCheck? = null
        /**
         * The ID of the environment that you want to delete.
         */
        public var environmentId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.DeleteEnvironmentRequest) : this() {
            this.applicationId = x.applicationId
            this.deletionProtectionCheck = x.deletionProtectionCheck
            this.environmentId = x.environmentId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.DeleteEnvironmentRequest = DeleteEnvironmentRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
