// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.serde

import aws.sdk.kotlin.services.appconfig.model.AppConfigException
import aws.sdk.kotlin.services.appconfig.model.UpdateConfigurationProfileResponse
import aws.sdk.kotlin.services.appconfig.model.Validator
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateConfigurationProfileOperationDeserializer: HttpDeserializer.NonStreaming<UpdateConfigurationProfileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateConfigurationProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateConfigurationProfileError(context, call, payload)
        }
        val builder = UpdateConfigurationProfileResponse.Builder()

        if (payload != null) {
            deserializeUpdateConfigurationProfileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateConfigurationProfileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppConfigException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppConfigException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateConfigurationProfileOperationBody(builder: UpdateConfigurationProfileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyArn"))
    val KMSKEYIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyIdentifier"))
    val LOCATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LocationUri"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RETRIEVALROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RetrievalRoleArn"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val VALIDATORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Validators"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(KMSKEYIDENTIFIER_DESCRIPTOR)
        field(LOCATIONURI_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RETRIEVALROLEARN_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(VALIDATORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                KMSKEYARN_DESCRIPTOR.index -> builder.kmsKeyArn = deserializeString()
                KMSKEYIDENTIFIER_DESCRIPTOR.index -> builder.kmsKeyIdentifier = deserializeString()
                LOCATIONURI_DESCRIPTOR.index -> builder.locationUri = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RETRIEVALROLEARN_DESCRIPTOR.index -> builder.retrievalRoleArn = deserializeString()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString()
                VALIDATORS_DESCRIPTOR.index -> builder.validators =
                    deserializer.deserializeList(VALIDATORS_DESCRIPTOR) {
                        val col0 = mutableListOf<Validator>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidatorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
