// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A parameter to configure deletion protection. If enabled, deletion protection prevents a user from deleting a configuration profile or an environment if AppConfig has called either [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) or for the configuration profile or from the environment during the specified interval.
 *
 * This setting uses the following default values:
 * + Deletion protection is disabled by default.
 * + The default interval specified by `ProtectionPeriodInMinutes` is 60.
 * + `DeletionProtectionCheck` skips configuration profiles and environments that were created in the past hour.
 */
public class DeletionProtectionSettings private constructor(builder: Builder) {
    /**
     * A parameter that indicates if deletion protection is enabled or not.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The time interval during which AppConfig monitors for calls to [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) or for a configuration profile or from an environment. AppConfig returns an error if a user calls or for the designated configuration profile or environment. To bypass the error and delete a configuration profile or an environment, specify `BYPASS` for the `DeletionProtectionCheck` parameter for either or .
     */
    public val protectionPeriodInMinutes: kotlin.Int? = builder.protectionPeriodInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfig.model.DeletionProtectionSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeletionProtectionSettings(")
        append("enabled=$enabled,")
        append("protectionPeriodInMinutes=$protectionPeriodInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (protectionPeriodInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeletionProtectionSettings

        if (enabled != other.enabled) return false
        if (protectionPeriodInMinutes != other.protectionPeriodInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfig.model.DeletionProtectionSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A parameter that indicates if deletion protection is enabled or not.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The time interval during which AppConfig monitors for calls to [GetLatestConfiguration](https://docs.aws.amazon.com/appconfig/2019-10-09/APIReference/API_appconfigdata_GetLatestConfiguration.html) or for a configuration profile or from an environment. AppConfig returns an error if a user calls or for the designated configuration profile or environment. To bypass the error and delete a configuration profile or an environment, specify `BYPASS` for the `DeletionProtectionCheck` parameter for either or .
         */
        public var protectionPeriodInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfig.model.DeletionProtectionSettings) : this() {
            this.enabled = x.enabled
            this.protectionPeriodInMinutes = x.protectionPeriodInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfig.model.DeletionProtectionSettings = DeletionProtectionSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
