// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfig.serde

import aws.sdk.kotlin.services.appconfig.model.AppConfigException
import aws.sdk.kotlin.services.appconfig.model.GrowthType
import aws.sdk.kotlin.services.appconfig.model.ReplicateTo
import aws.sdk.kotlin.services.appconfig.model.UpdateDeploymentStrategyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDeploymentStrategyOperationDeserializer: HttpDeserializer.NonStreaming<UpdateDeploymentStrategyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateDeploymentStrategyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDeploymentStrategyError(context, call, payload)
        }
        val builder = UpdateDeploymentStrategyResponse.Builder()

        if (payload != null) {
            deserializeUpdateDeploymentStrategyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateDeploymentStrategyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppConfigException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppConfigException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDeploymentStrategyOperationBody(builder: UpdateDeploymentStrategyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTDURATIONINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DeploymentDurationInMinutes"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FINALBAKETIMEINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("FinalBakeTimeInMinutes"))
    val GROWTHFACTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Float, JsonSerialName("GrowthFactor"))
    val GROWTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("GrowthType"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val REPLICATETO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ReplicateTo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTDURATIONINMINUTES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FINALBAKETIMEINMINUTES_DESCRIPTOR)
        field(GROWTHFACTOR_DESCRIPTOR)
        field(GROWTHTYPE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REPLICATETO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTDURATIONINMINUTES_DESCRIPTOR.index -> builder.deploymentDurationInMinutes = deserializeInt()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FINALBAKETIMEINMINUTES_DESCRIPTOR.index -> builder.finalBakeTimeInMinutes = deserializeInt()
                GROWTHFACTOR_DESCRIPTOR.index -> builder.growthFactor = deserializeFloat()
                GROWTHTYPE_DESCRIPTOR.index -> builder.growthType = deserializeString().let { GrowthType.fromValue(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REPLICATETO_DESCRIPTOR.index -> builder.replicateTo = deserializeString().let { ReplicateTo.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
