// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfigdata.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appconfigdata.model.AppConfigDataException
import aws.sdk.kotlin.services.appconfigdata.model.GetLatestConfigurationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class GetLatestConfigurationOperationDeserializer: HttpDeserialize<GetLatestConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetLatestConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwGetLatestConfigurationError(context, response)
        }
        val builder = GetLatestConfigurationResponse.Builder()

        builder.contentType = response.headers["Content-Type"]
        builder.nextPollConfigurationToken = response.headers["Next-Poll-Configuration-Token"]
        builder.nextPollIntervalInSeconds = response.headers["Next-Poll-Interval-In-Seconds"]?.toInt() ?: 0

        builder.configuration = response.body.readAll()

        return builder.build()
    }
}

private suspend fun throwGetLatestConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppConfigDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AppConfigDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
