// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfigdata

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.appconfigdata.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.appconfigdata.endpoints.EndpointProvider
import aws.sdk.kotlin.services.appconfigdata.model.*
import aws.sdk.kotlin.services.appconfigdata.model.GetLatestConfigurationRequest
import aws.sdk.kotlin.services.appconfigdata.model.GetLatestConfigurationResponse
import aws.sdk.kotlin.services.appconfigdata.model.StartConfigurationSessionRequest
import aws.sdk.kotlin.services.appconfigdata.model.StartConfigurationSessionResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * AppConfig Data provides the data plane APIs your application uses to retrieve configuration data. Here's how it works:
 *
 * Your application retrieves configuration data by first establishing a configuration session using the AppConfig Data StartConfigurationSession API action. Your session's client then makes periodic calls to GetLatestConfiguration to check for and retrieve the latest data available.
 *
 * When calling `StartConfigurationSession`, your code sends the following information:
 * + Identifiers (ID or name) of an AppConfig application, environment, and configuration profile that the session tracks.
 * + (Optional) The minimum amount of time the session's client must wait between calls to `GetLatestConfiguration`.
 *
 * In response, AppConfig provides an `InitialConfigurationToken` to be given to the session's client and used the first time it calls `GetLatestConfiguration` for that session.
 *
 * When calling `GetLatestConfiguration`, your client code sends the most recent `ConfigurationToken` value it has and receives in response:
 * + `NextPollConfigurationToken`: the `ConfigurationToken` value to use on the next call to `GetLatestConfiguration`.
 * + `NextPollIntervalInSeconds`: the duration the client should wait before making its next call to `GetLatestConfiguration`. This duration may vary over the course of the session, so it should be used instead of the value sent on the `StartConfigurationSession` call.
 * + The configuration: the latest data intended for the session. This may be empty if the client already has the latest version of the configuration.
 *
 * For more information and to view example CLI commands that show how to retrieve a configuration using the AppConfig Data `StartConfigurationSession` and `GetLatestConfiguration` API actions, see [Receiving the configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration) in the *AppConfig User Guide*.
 */
public interface AppConfigDataClient : SdkClient {

    override val serviceName: String
        get() = "AppConfigData"
    /**
     * AppConfigDataClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): AppConfigDataClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAppConfigDataClient(config)
        }

        public operator fun invoke(config: Config): AppConfigDataClient = DefaultAppConfigDataClient(config)

        /**
         * Construct a [AppConfigDataClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AppConfigDataClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultAppConfigDataClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "AppConfigData")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Retrieves the latest deployed configuration. This API may return empty configuration data if the client already has the latest version. For more information about this API action and to view example CLI commands that show how to use it with the StartConfigurationSession API action, see [Receiving the configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration) in the *AppConfig User Guide*.
     *
     * Note the following important information.
     * + Each configuration token is only valid for one call to `GetLatestConfiguration`. The `GetLatestConfiguration` response includes a `NextPollConfigurationToken` that should always replace the token used for the just-completed call in preparation for the next one.
     * + `GetLatestConfiguration` is a priced call. For more information, see [Pricing](https://aws.amazon.com/systems-manager/pricing/).
     */
    public suspend fun getLatestConfiguration(input: GetLatestConfigurationRequest): GetLatestConfigurationResponse

    /**
     * Starts a configuration session used to retrieve a deployed configuration. For more information about this API action and to view example CLI commands that show how to use it with the GetLatestConfiguration API action, see [Receiving the configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration) in the *AppConfig User Guide*.
     */
    public suspend fun startConfigurationSession(input: StartConfigurationSessionRequest): StartConfigurationSessionResponse
}

/**
 * Retrieves the latest deployed configuration. This API may return empty configuration data if the client already has the latest version. For more information about this API action and to view example CLI commands that show how to use it with the StartConfigurationSession API action, see [Receiving the configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration) in the *AppConfig User Guide*.
 *
 * Note the following important information.
 * + Each configuration token is only valid for one call to `GetLatestConfiguration`. The `GetLatestConfiguration` response includes a `NextPollConfigurationToken` that should always replace the token used for the just-completed call in preparation for the next one.
 * + `GetLatestConfiguration` is a priced call. For more information, see [Pricing](https://aws.amazon.com/systems-manager/pricing/).
 */
public suspend inline fun AppConfigDataClient.getLatestConfiguration(crossinline block: GetLatestConfigurationRequest.Builder.() -> Unit): GetLatestConfigurationResponse = getLatestConfiguration(GetLatestConfigurationRequest.Builder().apply(block).build())

/**
 * Starts a configuration session used to retrieve a deployed configuration. For more information about this API action and to view example CLI commands that show how to use it with the GetLatestConfiguration API action, see [Receiving the configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration) in the *AppConfig User Guide*.
 */
public suspend inline fun AppConfigDataClient.startConfigurationSession(crossinline block: StartConfigurationSessionRequest.Builder.() -> Unit): StartConfigurationSessionResponse = startConfigurationSession(StartConfigurationSessionRequest.Builder().apply(block).build())
