// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfigdata

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.appconfigdata.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.appconfigdata.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.appconfigdata.model.*
import aws.sdk.kotlin.services.appconfigdata.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "AppConfigData"
public const val ServiceApiVersion: String = "2021-11-11"
public const val SdkVersion: String = "0.19.1-beta"

internal class DefaultAppConfigDataClient(override val config: AppConfigDataClient.Config) : AppConfigDataClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Retrieves the latest deployed configuration. This API may return empty configuration data if the client already has the latest version. For more information about this API action and to view example CLI commands that show how to use it with the StartConfigurationSession API action, see [Receiving the configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration) in the *AppConfig User Guide*.
     *
     * Note the following important information.
     * + Each configuration token is only valid for one call to `GetLatestConfiguration`. The `GetLatestConfiguration` response includes a `NextPollConfigurationToken` that should always replace the token used for the just-completed call in preparation for the next one.
     * + `GetLatestConfiguration` is a priced call. For more information, see [Pricing](https://aws.amazon.com/systems-manager/pricing/).
     */
    override suspend fun getLatestConfiguration(input: GetLatestConfigurationRequest): GetLatestConfigurationResponse {
        val op = SdkHttpOperation.build<GetLatestConfigurationRequest, GetLatestConfigurationResponse> {
            serializer = GetLatestConfigurationOperationSerializer()
            deserializer = GetLatestConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLatestConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appconfig"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetLatestConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts a configuration session used to retrieve a deployed configuration. For more information about this API action and to view example CLI commands that show how to use it with the GetLatestConfiguration API action, see [Receiving the configuration](http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration) in the *AppConfig User Guide*.
     */
    override suspend fun startConfigurationSession(input: StartConfigurationSessionRequest): StartConfigurationSessionResponse {
        val op = SdkHttpOperation.build<StartConfigurationSessionRequest, StartConfigurationSessionResponse> {
            serializer = StartConfigurationSessionOperationSerializer()
            deserializer = StartConfigurationSessionOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "StartConfigurationSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "appconfig"
            }
        )
        val rootSpan = config.tracer.createRootSpan("StartConfigurationSession-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "appconfig")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
