// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfigdata.model



public class GetLatestConfigurationResponse private constructor(builder: Builder) {
    /**
     * The data of the configuration. This may be empty if the client already has the latest version of configuration.
     */
    public val configuration: kotlin.ByteArray? = builder.configuration
    /**
     * A standard MIME type describing the format of the configuration content.
     */
    public val contentType: kotlin.String? = builder.contentType
    /**
     * The latest token describing the current state of the configuration session. This MUST be provided to the next call to `GetLatestConfiguration.`
     */
    public val nextPollConfigurationToken: kotlin.String? = builder.nextPollConfigurationToken
    /**
     * The amount of time the client should wait before polling for configuration updates again. Use `RequiredMinimumPollIntervalInSeconds` to set the desired poll interval.
     */
    public val nextPollIntervalInSeconds: kotlin.Int = builder.nextPollIntervalInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appconfigdata.model.GetLatestConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetLatestConfigurationResponse(")
        append("configuration=*** Sensitive Data Redacted ***,")
        append("contentType=$contentType,")
        append("nextPollConfigurationToken=$nextPollConfigurationToken,")
        append("nextPollIntervalInSeconds=$nextPollIntervalInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.contentHashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (nextPollConfigurationToken?.hashCode() ?: 0)
        result = 31 * result + (nextPollIntervalInSeconds)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetLatestConfigurationResponse

        if (configuration != null) {
            if (other.configuration == null) return false
            if (!configuration.contentEquals(other.configuration)) return false
        } else if (other.configuration != null) return false
        if (contentType != other.contentType) return false
        if (nextPollConfigurationToken != other.nextPollConfigurationToken) return false
        if (nextPollIntervalInSeconds != other.nextPollIntervalInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appconfigdata.model.GetLatestConfigurationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data of the configuration. This may be empty if the client already has the latest version of configuration.
         */
        public var configuration: kotlin.ByteArray? = null
        /**
         * A standard MIME type describing the format of the configuration content.
         */
        public var contentType: kotlin.String? = null
        /**
         * The latest token describing the current state of the configuration session. This MUST be provided to the next call to `GetLatestConfiguration.`
         */
        public var nextPollConfigurationToken: kotlin.String? = null
        /**
         * The amount of time the client should wait before polling for configuration updates again. Use `RequiredMinimumPollIntervalInSeconds` to set the desired poll interval.
         */
        public var nextPollIntervalInSeconds: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appconfigdata.model.GetLatestConfigurationResponse) : this() {
            this.configuration = x.configuration
            this.contentType = x.contentType
            this.nextPollConfigurationToken = x.nextPollConfigurationToken
            this.nextPollIntervalInSeconds = x.nextPollIntervalInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appconfigdata.model.GetLatestConfigurationResponse = GetLatestConfigurationResponse(this)
    }
}
