// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appconfigdata.serde

import aws.sdk.kotlin.services.appconfigdata.model.AppConfigDataException
import aws.sdk.kotlin.services.appconfigdata.model.GetLatestConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetLatestConfigurationOperationDeserializer: HttpDeserialize<GetLatestConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetLatestConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetLatestConfigurationError(context, call)
        }
        val builder = GetLatestConfigurationResponse.Builder()

        builder.contentType = response.headers["Content-Type"]
        builder.nextPollConfigurationToken = response.headers["Next-Poll-Configuration-Token"]
        builder.nextPollIntervalInSeconds = response.headers["Next-Poll-Interval-In-Seconds"]?.toInt() ?: 0
        builder.versionLabel = response.headers["Version-Label"]

        builder.configuration = response.body.readAll()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetLatestConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppConfigDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AppConfigDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
