// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * Describes the data model of a connector field. For example, for an *account* entity, the fields would be *account name*, *account ID*, and so on.
 */
public class ConnectorEntityField private constructor(builder: Builder) {
    /**
     * A map that has specific properties related to the ConnectorEntityField.
     */
    public val customProperties: Map<String, String>? = builder.customProperties
    /**
     * Default value that can be assigned to this field.
     */
    public val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * A description of the connector entity field.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The properties applied to a field when the connector is being used as a destination.
     */
    public val destinationProperties: aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties? = builder.destinationProperties
    /**
     * The unique identifier of the connector field.
     */
    public val identifier: kotlin.String = requireNotNull(builder.identifier) { "A non-null value must be provided for identifier" }
    /**
     * Booelan value that indicates whether this field is deprecated or not.
     */
    public val isDeprecated: kotlin.Boolean = builder.isDeprecated
    /**
     * Booelan value that indicates whether this field can be used as a primary key.
     */
    public val isPrimaryKey: kotlin.Boolean = builder.isPrimaryKey
    /**
     * The label applied to a connector entity field.
     */
    public val label: kotlin.String? = builder.label
    /**
     * The parent identifier of the connector field.
     */
    public val parentIdentifier: kotlin.String? = builder.parentIdentifier
    /**
     * The properties that can be applied to a field when the connector is being used as a source.
     */
    public val sourceProperties: aws.sdk.kotlin.services.appflow.model.SourceFieldProperties? = builder.sourceProperties
    /**
     * Contains details regarding the supported `FieldType`, including the corresponding `filterOperators` and `supportedValues`.
     */
    public val supportedFieldTypeDetails: aws.sdk.kotlin.services.appflow.model.SupportedFieldTypeDetails? = builder.supportedFieldTypeDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ConnectorEntityField = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectorEntityField(")
        append("customProperties=$customProperties,")
        append("defaultValue=$defaultValue,")
        append("description=$description,")
        append("destinationProperties=$destinationProperties,")
        append("identifier=$identifier,")
        append("isDeprecated=$isDeprecated,")
        append("isPrimaryKey=$isPrimaryKey,")
        append("label=$label,")
        append("parentIdentifier=$parentIdentifier,")
        append("sourceProperties=$sourceProperties,")
        append("supportedFieldTypeDetails=$supportedFieldTypeDetails")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customProperties?.hashCode() ?: 0
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationProperties?.hashCode() ?: 0)
        result = 31 * result + (identifier.hashCode())
        result = 31 * result + (isDeprecated.hashCode())
        result = 31 * result + (isPrimaryKey.hashCode())
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (parentIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceProperties?.hashCode() ?: 0)
        result = 31 * result + (supportedFieldTypeDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectorEntityField

        if (customProperties != other.customProperties) return false
        if (defaultValue != other.defaultValue) return false
        if (description != other.description) return false
        if (destinationProperties != other.destinationProperties) return false
        if (identifier != other.identifier) return false
        if (isDeprecated != other.isDeprecated) return false
        if (isPrimaryKey != other.isPrimaryKey) return false
        if (label != other.label) return false
        if (parentIdentifier != other.parentIdentifier) return false
        if (sourceProperties != other.sourceProperties) return false
        if (supportedFieldTypeDetails != other.supportedFieldTypeDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ConnectorEntityField = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map that has specific properties related to the ConnectorEntityField.
         */
        public var customProperties: Map<String, String>? = null
        /**
         * Default value that can be assigned to this field.
         */
        public var defaultValue: kotlin.String? = null
        /**
         * A description of the connector entity field.
         */
        public var description: kotlin.String? = null
        /**
         * The properties applied to a field when the connector is being used as a destination.
         */
        public var destinationProperties: aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties? = null
        /**
         * The unique identifier of the connector field.
         */
        public var identifier: kotlin.String? = null
        /**
         * Booelan value that indicates whether this field is deprecated or not.
         */
        public var isDeprecated: kotlin.Boolean = false
        /**
         * Booelan value that indicates whether this field can be used as a primary key.
         */
        public var isPrimaryKey: kotlin.Boolean = false
        /**
         * The label applied to a connector entity field.
         */
        public var label: kotlin.String? = null
        /**
         * The parent identifier of the connector field.
         */
        public var parentIdentifier: kotlin.String? = null
        /**
         * The properties that can be applied to a field when the connector is being used as a source.
         */
        public var sourceProperties: aws.sdk.kotlin.services.appflow.model.SourceFieldProperties? = null
        /**
         * Contains details regarding the supported `FieldType`, including the corresponding `filterOperators` and `supportedValues`.
         */
        public var supportedFieldTypeDetails: aws.sdk.kotlin.services.appflow.model.SupportedFieldTypeDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ConnectorEntityField) : this() {
            this.customProperties = x.customProperties
            this.defaultValue = x.defaultValue
            this.description = x.description
            this.destinationProperties = x.destinationProperties
            this.identifier = x.identifier
            this.isDeprecated = x.isDeprecated
            this.isPrimaryKey = x.isPrimaryKey
            this.label = x.label
            this.parentIdentifier = x.parentIdentifier
            this.sourceProperties = x.sourceProperties
            this.supportedFieldTypeDetails = x.supportedFieldTypeDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ConnectorEntityField = ConnectorEntityField(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties] inside the given [block]
         */
        public fun destinationProperties(block: aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties.Builder.() -> kotlin.Unit) {
            this.destinationProperties = aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.SourceFieldProperties] inside the given [block]
         */
        public fun sourceProperties(block: aws.sdk.kotlin.services.appflow.model.SourceFieldProperties.Builder.() -> kotlin.Unit) {
            this.sourceProperties = aws.sdk.kotlin.services.appflow.model.SourceFieldProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.SupportedFieldTypeDetails] inside the given [block]
         */
        public fun supportedFieldTypeDetails(block: aws.sdk.kotlin.services.appflow.model.SupportedFieldTypeDetails.Builder.() -> kotlin.Unit) {
            this.supportedFieldTypeDetails = aws.sdk.kotlin.services.appflow.model.SupportedFieldTypeDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (identifier == null) identifier = ""
            return this
        }
    }
}
