// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The API of the connector application that Amazon AppFlow uses to transfer your data.
 */
public class DataTransferApi private constructor(builder: Builder) {
    /**
     * The name of the connector application API.
     */
    public val name: kotlin.String? = builder.name
    /**
     * You can specify one of the following types:
     *
     * ## AUTOMATIC
     * The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run, Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run transfers.
     *
     * ## SYNC
     * A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
     *
     * ## ASYNC
     * An asynchronous API. This type of API optimizes a flow for large datasets.
     */
    public val type: aws.sdk.kotlin.services.appflow.model.DataTransferApiType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.DataTransferApi = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataTransferApi(")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataTransferApi

        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.DataTransferApi = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the connector application API.
         */
        public var name: kotlin.String? = null
        /**
         * You can specify one of the following types:
         *
         * ## AUTOMATIC
         * The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run, Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run transfers.
         *
         * ## SYNC
         * A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.
         *
         * ## ASYNC
         * An asynchronous API. This type of API optimizes a flow for large datasets.
         */
        public var type: aws.sdk.kotlin.services.appflow.model.DataTransferApiType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.DataTransferApi) : this() {
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.DataTransferApi = DataTransferApi(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
