// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The configuration settings related to a given connector.
 */
public class ConnectorConfiguration private constructor(builder: Builder) {
    /**
     * The authentication config required for the connector.
     */
    public val authenticationConfig: aws.sdk.kotlin.services.appflow.model.AuthenticationConfig? = builder.authenticationConfig
    /**
     * Specifies whether the connector can be used as a destination.
     */
    public val canUseAsDestination: kotlin.Boolean = builder.canUseAsDestination
    /**
     * Specifies whether the connector can be used as a source.
     */
    public val canUseAsSource: kotlin.Boolean = builder.canUseAsSource
    /**
     * The Amazon Resource Name (ARN) for the registered connector.
     */
    public val connectorArn: kotlin.String? = builder.connectorArn
    /**
     * A description about the connector.
     */
    public val connectorDescription: kotlin.String? = builder.connectorDescription
    /**
     * The label used for registering the connector.
     */
    public val connectorLabel: kotlin.String? = builder.connectorLabel
    /**
     * Specifies connector-specific metadata such as `oAuthScopes`, `supportedRegions`, `privateLinkServiceUrl`, and so on.
     */
    public val connectorMetadata: aws.sdk.kotlin.services.appflow.model.ConnectorMetadata? = builder.connectorMetadata
    /**
     * The connection modes that the connector supports.
     */
    public val connectorModes: List<String>? = builder.connectorModes
    /**
     * The connector name.
     */
    public val connectorName: kotlin.String? = builder.connectorName
    /**
     * The owner who developed the connector.
     */
    public val connectorOwner: kotlin.String? = builder.connectorOwner
    /**
     * The configuration required for registering the connector.
     */
    public val connectorProvisioningConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig? = builder.connectorProvisioningConfig
    /**
     * The provisioning type used to register the connector.
     */
    public val connectorProvisioningType: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningType? = builder.connectorProvisioningType
    /**
     * The required connector runtime settings.
     */
    public val connectorRuntimeSettings: List<ConnectorRuntimeSetting>? = builder.connectorRuntimeSettings
    /**
     * The connector type.
     */
    public val connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = builder.connectorType
    /**
     * The connector version.
     */
    public val connectorVersion: kotlin.String? = builder.connectorVersion
    /**
     * Specifies if PrivateLink is enabled for that connector.
     */
    public val isPrivateLinkEnabled: kotlin.Boolean = builder.isPrivateLinkEnabled
    /**
     * Specifies if a PrivateLink endpoint URL is required.
     */
    public val isPrivateLinkEndpointUrlRequired: kotlin.Boolean = builder.isPrivateLinkEndpointUrlRequired
    /**
     * Logo URL of the connector.
     */
    public val logoUrl: kotlin.String? = builder.logoUrl
    /**
     * The date on which the connector was registered.
     */
    public val registeredAt: aws.smithy.kotlin.runtime.time.Instant? = builder.registeredAt
    /**
     * Information about who registered the connector.
     */
    public val registeredBy: kotlin.String? = builder.registeredBy
    /**
     * A list of API versions that are supported by the connector.
     */
    public val supportedApiVersions: List<String>? = builder.supportedApiVersions
    /**
     * The APIs of the connector application that Amazon AppFlow can use to transfer your data.
     */
    public val supportedDataTransferApis: List<DataTransferApi>? = builder.supportedDataTransferApis
    /**
     * The data transfer types that the connector supports.
     *
     * ## RECORD
     * Structured records.
     *
     * ## FILE
     * Files or binary data.
     */
    public val supportedDataTransferTypes: List<SupportedDataTransferType>? = builder.supportedDataTransferTypes
    /**
     * Lists the connectors that are available for use as destinations.
     */
    public val supportedDestinationConnectors: List<ConnectorType>? = builder.supportedDestinationConnectors
    /**
     * A list of operators supported by the connector.
     */
    public val supportedOperators: List<Operators>? = builder.supportedOperators
    /**
     * Specifies the supported flow frequency for that connector.
     */
    public val supportedSchedulingFrequencies: List<ScheduleFrequencyType>? = builder.supportedSchedulingFrequencies
    /**
     * Specifies the supported trigger types for the flow.
     */
    public val supportedTriggerTypes: List<TriggerType>? = builder.supportedTriggerTypes
    /**
     * A list of write operations supported by the connector.
     */
    public val supportedWriteOperations: List<WriteOperationType>? = builder.supportedWriteOperations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ConnectorConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectorConfiguration(")
        append("authenticationConfig=$authenticationConfig,")
        append("canUseAsDestination=$canUseAsDestination,")
        append("canUseAsSource=$canUseAsSource,")
        append("connectorArn=$connectorArn,")
        append("connectorDescription=$connectorDescription,")
        append("connectorLabel=$connectorLabel,")
        append("connectorMetadata=$connectorMetadata,")
        append("connectorModes=$connectorModes,")
        append("connectorName=$connectorName,")
        append("connectorOwner=$connectorOwner,")
        append("connectorProvisioningConfig=$connectorProvisioningConfig,")
        append("connectorProvisioningType=$connectorProvisioningType,")
        append("connectorRuntimeSettings=$connectorRuntimeSettings,")
        append("connectorType=$connectorType,")
        append("connectorVersion=$connectorVersion,")
        append("isPrivateLinkEnabled=$isPrivateLinkEnabled,")
        append("isPrivateLinkEndpointUrlRequired=$isPrivateLinkEndpointUrlRequired,")
        append("logoUrl=$logoUrl,")
        append("registeredAt=$registeredAt,")
        append("registeredBy=$registeredBy,")
        append("supportedApiVersions=$supportedApiVersions,")
        append("supportedDataTransferApis=$supportedDataTransferApis,")
        append("supportedDataTransferTypes=$supportedDataTransferTypes,")
        append("supportedDestinationConnectors=$supportedDestinationConnectors,")
        append("supportedOperators=$supportedOperators,")
        append("supportedSchedulingFrequencies=$supportedSchedulingFrequencies,")
        append("supportedTriggerTypes=$supportedTriggerTypes,")
        append("supportedWriteOperations=$supportedWriteOperations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationConfig?.hashCode() ?: 0
        result = 31 * result + (canUseAsDestination.hashCode())
        result = 31 * result + (canUseAsSource.hashCode())
        result = 31 * result + (connectorArn?.hashCode() ?: 0)
        result = 31 * result + (connectorDescription?.hashCode() ?: 0)
        result = 31 * result + (connectorLabel?.hashCode() ?: 0)
        result = 31 * result + (connectorMetadata?.hashCode() ?: 0)
        result = 31 * result + (connectorModes?.hashCode() ?: 0)
        result = 31 * result + (connectorName?.hashCode() ?: 0)
        result = 31 * result + (connectorOwner?.hashCode() ?: 0)
        result = 31 * result + (connectorProvisioningConfig?.hashCode() ?: 0)
        result = 31 * result + (connectorProvisioningType?.hashCode() ?: 0)
        result = 31 * result + (connectorRuntimeSettings?.hashCode() ?: 0)
        result = 31 * result + (connectorType?.hashCode() ?: 0)
        result = 31 * result + (connectorVersion?.hashCode() ?: 0)
        result = 31 * result + (isPrivateLinkEnabled.hashCode())
        result = 31 * result + (isPrivateLinkEndpointUrlRequired.hashCode())
        result = 31 * result + (logoUrl?.hashCode() ?: 0)
        result = 31 * result + (registeredAt?.hashCode() ?: 0)
        result = 31 * result + (registeredBy?.hashCode() ?: 0)
        result = 31 * result + (supportedApiVersions?.hashCode() ?: 0)
        result = 31 * result + (supportedDataTransferApis?.hashCode() ?: 0)
        result = 31 * result + (supportedDataTransferTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedDestinationConnectors?.hashCode() ?: 0)
        result = 31 * result + (supportedOperators?.hashCode() ?: 0)
        result = 31 * result + (supportedSchedulingFrequencies?.hashCode() ?: 0)
        result = 31 * result + (supportedTriggerTypes?.hashCode() ?: 0)
        result = 31 * result + (supportedWriteOperations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectorConfiguration

        if (authenticationConfig != other.authenticationConfig) return false
        if (canUseAsDestination != other.canUseAsDestination) return false
        if (canUseAsSource != other.canUseAsSource) return false
        if (connectorArn != other.connectorArn) return false
        if (connectorDescription != other.connectorDescription) return false
        if (connectorLabel != other.connectorLabel) return false
        if (connectorMetadata != other.connectorMetadata) return false
        if (connectorModes != other.connectorModes) return false
        if (connectorName != other.connectorName) return false
        if (connectorOwner != other.connectorOwner) return false
        if (connectorProvisioningConfig != other.connectorProvisioningConfig) return false
        if (connectorProvisioningType != other.connectorProvisioningType) return false
        if (connectorRuntimeSettings != other.connectorRuntimeSettings) return false
        if (connectorType != other.connectorType) return false
        if (connectorVersion != other.connectorVersion) return false
        if (isPrivateLinkEnabled != other.isPrivateLinkEnabled) return false
        if (isPrivateLinkEndpointUrlRequired != other.isPrivateLinkEndpointUrlRequired) return false
        if (logoUrl != other.logoUrl) return false
        if (registeredAt != other.registeredAt) return false
        if (registeredBy != other.registeredBy) return false
        if (supportedApiVersions != other.supportedApiVersions) return false
        if (supportedDataTransferApis != other.supportedDataTransferApis) return false
        if (supportedDataTransferTypes != other.supportedDataTransferTypes) return false
        if (supportedDestinationConnectors != other.supportedDestinationConnectors) return false
        if (supportedOperators != other.supportedOperators) return false
        if (supportedSchedulingFrequencies != other.supportedSchedulingFrequencies) return false
        if (supportedTriggerTypes != other.supportedTriggerTypes) return false
        if (supportedWriteOperations != other.supportedWriteOperations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ConnectorConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authentication config required for the connector.
         */
        public var authenticationConfig: aws.sdk.kotlin.services.appflow.model.AuthenticationConfig? = null
        /**
         * Specifies whether the connector can be used as a destination.
         */
        public var canUseAsDestination: kotlin.Boolean = false
        /**
         * Specifies whether the connector can be used as a source.
         */
        public var canUseAsSource: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) for the registered connector.
         */
        public var connectorArn: kotlin.String? = null
        /**
         * A description about the connector.
         */
        public var connectorDescription: kotlin.String? = null
        /**
         * The label used for registering the connector.
         */
        public var connectorLabel: kotlin.String? = null
        /**
         * Specifies connector-specific metadata such as `oAuthScopes`, `supportedRegions`, `privateLinkServiceUrl`, and so on.
         */
        public var connectorMetadata: aws.sdk.kotlin.services.appflow.model.ConnectorMetadata? = null
        /**
         * The connection modes that the connector supports.
         */
        public var connectorModes: List<String>? = null
        /**
         * The connector name.
         */
        public var connectorName: kotlin.String? = null
        /**
         * The owner who developed the connector.
         */
        public var connectorOwner: kotlin.String? = null
        /**
         * The configuration required for registering the connector.
         */
        public var connectorProvisioningConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig? = null
        /**
         * The provisioning type used to register the connector.
         */
        public var connectorProvisioningType: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningType? = null
        /**
         * The required connector runtime settings.
         */
        public var connectorRuntimeSettings: List<ConnectorRuntimeSetting>? = null
        /**
         * The connector type.
         */
        public var connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = null
        /**
         * The connector version.
         */
        public var connectorVersion: kotlin.String? = null
        /**
         * Specifies if PrivateLink is enabled for that connector.
         */
        public var isPrivateLinkEnabled: kotlin.Boolean = false
        /**
         * Specifies if a PrivateLink endpoint URL is required.
         */
        public var isPrivateLinkEndpointUrlRequired: kotlin.Boolean = false
        /**
         * Logo URL of the connector.
         */
        public var logoUrl: kotlin.String? = null
        /**
         * The date on which the connector was registered.
         */
        public var registeredAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about who registered the connector.
         */
        public var registeredBy: kotlin.String? = null
        /**
         * A list of API versions that are supported by the connector.
         */
        public var supportedApiVersions: List<String>? = null
        /**
         * The APIs of the connector application that Amazon AppFlow can use to transfer your data.
         */
        public var supportedDataTransferApis: List<DataTransferApi>? = null
        /**
         * The data transfer types that the connector supports.
         *
         * ## RECORD
         * Structured records.
         *
         * ## FILE
         * Files or binary data.
         */
        public var supportedDataTransferTypes: List<SupportedDataTransferType>? = null
        /**
         * Lists the connectors that are available for use as destinations.
         */
        public var supportedDestinationConnectors: List<ConnectorType>? = null
        /**
         * A list of operators supported by the connector.
         */
        public var supportedOperators: List<Operators>? = null
        /**
         * Specifies the supported flow frequency for that connector.
         */
        public var supportedSchedulingFrequencies: List<ScheduleFrequencyType>? = null
        /**
         * Specifies the supported trigger types for the flow.
         */
        public var supportedTriggerTypes: List<TriggerType>? = null
        /**
         * A list of write operations supported by the connector.
         */
        public var supportedWriteOperations: List<WriteOperationType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ConnectorConfiguration) : this() {
            this.authenticationConfig = x.authenticationConfig
            this.canUseAsDestination = x.canUseAsDestination
            this.canUseAsSource = x.canUseAsSource
            this.connectorArn = x.connectorArn
            this.connectorDescription = x.connectorDescription
            this.connectorLabel = x.connectorLabel
            this.connectorMetadata = x.connectorMetadata
            this.connectorModes = x.connectorModes
            this.connectorName = x.connectorName
            this.connectorOwner = x.connectorOwner
            this.connectorProvisioningConfig = x.connectorProvisioningConfig
            this.connectorProvisioningType = x.connectorProvisioningType
            this.connectorRuntimeSettings = x.connectorRuntimeSettings
            this.connectorType = x.connectorType
            this.connectorVersion = x.connectorVersion
            this.isPrivateLinkEnabled = x.isPrivateLinkEnabled
            this.isPrivateLinkEndpointUrlRequired = x.isPrivateLinkEndpointUrlRequired
            this.logoUrl = x.logoUrl
            this.registeredAt = x.registeredAt
            this.registeredBy = x.registeredBy
            this.supportedApiVersions = x.supportedApiVersions
            this.supportedDataTransferApis = x.supportedDataTransferApis
            this.supportedDataTransferTypes = x.supportedDataTransferTypes
            this.supportedDestinationConnectors = x.supportedDestinationConnectors
            this.supportedOperators = x.supportedOperators
            this.supportedSchedulingFrequencies = x.supportedSchedulingFrequencies
            this.supportedTriggerTypes = x.supportedTriggerTypes
            this.supportedWriteOperations = x.supportedWriteOperations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ConnectorConfiguration = ConnectorConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.AuthenticationConfig] inside the given [block]
         */
        public fun authenticationConfig(block: aws.sdk.kotlin.services.appflow.model.AuthenticationConfig.Builder.() -> kotlin.Unit) {
            this.authenticationConfig = aws.sdk.kotlin.services.appflow.model.AuthenticationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorMetadata] inside the given [block]
         */
        public fun connectorMetadata(block: aws.sdk.kotlin.services.appflow.model.ConnectorMetadata.Builder.() -> kotlin.Unit) {
            this.connectorMetadata = aws.sdk.kotlin.services.appflow.model.ConnectorMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig] inside the given [block]
         */
        public fun connectorProvisioningConfig(block: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig.Builder.() -> kotlin.Unit) {
            this.connectorProvisioningConfig = aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
