// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * Sets the page size for each *concurrent process* that transfers OData records from your SAP instance. A concurrent process is query that retrieves a batch of records as part of a flow run. Amazon AppFlow can run multiple concurrent processes in parallel to transfer data faster.
 */
public class SapoDataPaginationConfig private constructor(builder: Builder) {
    /**
     * The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP application. For transfers of OData records, the maximum page size is 3,000. For transfers of data that comes from an ODP provider, the maximum page size is 10,000.
     */
    public val maxPageSize: kotlin.Int = requireNotNull(builder.maxPageSize) { "A non-null value must be provided for maxPageSize" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SapoDataPaginationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SapoDataPaginationConfig(")
        append("maxPageSize=$maxPageSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxPageSize
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SapoDataPaginationConfig

        if (maxPageSize != other.maxPageSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SapoDataPaginationConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP application. For transfers of OData records, the maximum page size is 3,000. For transfers of data that comes from an ODP provider, the maximum page size is 10,000.
         */
        public var maxPageSize: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SapoDataPaginationConfig) : this() {
            this.maxPageSize = x.maxPageSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SapoDataPaginationConfig = SapoDataPaginationConfig(this)

        internal fun correctErrors(): Builder {
            if (maxPageSize == null) maxPageSize = 0
            return this
        }
    }
}
