// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an instance of a connector. This includes the provided name, credentials ARN, connection-mode, and so on. To keep the API intuitive and extensible, the fields that are common to all types of connector profiles are explicitly specified at the top level. The rest of the connector-specific properties are available via the `connectorProfileProperties` field.
 */
public class ConnectorProfile private constructor(builder: Builder) {
    /**
     * Indicates the connection mode and if it is public or private.
     */
    public val connectionMode: aws.sdk.kotlin.services.appflow.model.ConnectionMode? = builder.connectionMode
    /**
     * The label for the connector profile being created.
     */
    public val connectorLabel: kotlin.String? = builder.connectorLabel
    /**
     * The Amazon Resource Name (ARN) of the connector profile.
     */
    public val connectorProfileArn: kotlin.String? = builder.connectorProfileArn
    /**
     * The name of the connector profile. The name is unique for each `ConnectorProfile` in the Amazon Web Services account.
     */
    public val connectorProfileName: kotlin.String? = builder.connectorProfileName
    /**
     * The connector-specific properties of the profile configuration.
     */
    public val connectorProfileProperties: aws.sdk.kotlin.services.appflow.model.ConnectorProfileProperties? = builder.connectorProfileProperties
    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     */
    public val connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = builder.connectorType
    /**
     * Specifies when the connector profile was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon Resource Name (ARN) of the connector profile credentials.
     */
    public val credentialsArn: kotlin.String? = builder.credentialsArn
    /**
     * Specifies when the connector profile was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * Specifies the private connection provisioning state.
     */
    public val privateConnectionProvisioningState: aws.sdk.kotlin.services.appflow.model.PrivateConnectionProvisioningState? = builder.privateConnectionProvisioningState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ConnectorProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectorProfile(")
        append("connectionMode=$connectionMode,")
        append("connectorLabel=$connectorLabel,")
        append("connectorProfileArn=$connectorProfileArn,")
        append("connectorProfileName=$connectorProfileName,")
        append("connectorProfileProperties=$connectorProfileProperties,")
        append("connectorType=$connectorType,")
        append("createdAt=$createdAt,")
        append("credentialsArn=$credentialsArn,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("privateConnectionProvisioningState=$privateConnectionProvisioningState")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionMode?.hashCode() ?: 0
        result = 31 * result + (connectorLabel?.hashCode() ?: 0)
        result = 31 * result + (connectorProfileArn?.hashCode() ?: 0)
        result = 31 * result + (connectorProfileName?.hashCode() ?: 0)
        result = 31 * result + (connectorProfileProperties?.hashCode() ?: 0)
        result = 31 * result + (connectorType?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (credentialsArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (privateConnectionProvisioningState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectorProfile

        if (connectionMode != other.connectionMode) return false
        if (connectorLabel != other.connectorLabel) return false
        if (connectorProfileArn != other.connectorProfileArn) return false
        if (connectorProfileName != other.connectorProfileName) return false
        if (connectorProfileProperties != other.connectorProfileProperties) return false
        if (connectorType != other.connectorType) return false
        if (createdAt != other.createdAt) return false
        if (credentialsArn != other.credentialsArn) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (privateConnectionProvisioningState != other.privateConnectionProvisioningState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ConnectorProfile = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the connection mode and if it is public or private.
         */
        public var connectionMode: aws.sdk.kotlin.services.appflow.model.ConnectionMode? = null
        /**
         * The label for the connector profile being created.
         */
        public var connectorLabel: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the connector profile.
         */
        public var connectorProfileArn: kotlin.String? = null
        /**
         * The name of the connector profile. The name is unique for each `ConnectorProfile` in the Amazon Web Services account.
         */
        public var connectorProfileName: kotlin.String? = null
        /**
         * The connector-specific properties of the profile configuration.
         */
        public var connectorProfileProperties: aws.sdk.kotlin.services.appflow.model.ConnectorProfileProperties? = null
        /**
         * The type of connector, such as Salesforce, Amplitude, and so on.
         */
        public var connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = null
        /**
         * Specifies when the connector profile was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the connector profile credentials.
         */
        public var credentialsArn: kotlin.String? = null
        /**
         * Specifies when the connector profile was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the private connection provisioning state.
         */
        public var privateConnectionProvisioningState: aws.sdk.kotlin.services.appflow.model.PrivateConnectionProvisioningState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ConnectorProfile) : this() {
            this.connectionMode = x.connectionMode
            this.connectorLabel = x.connectorLabel
            this.connectorProfileArn = x.connectorProfileArn
            this.connectorProfileName = x.connectorProfileName
            this.connectorProfileProperties = x.connectorProfileProperties
            this.connectorType = x.connectorType
            this.createdAt = x.createdAt
            this.credentialsArn = x.credentialsArn
            this.lastUpdatedAt = x.lastUpdatedAt
            this.privateConnectionProvisioningState = x.privateConnectionProvisioningState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ConnectorProfile = ConnectorProfile(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorProfileProperties] inside the given [block]
         */
        public fun connectorProfileProperties(block: aws.sdk.kotlin.services.appflow.model.ConnectorProfileProperties.Builder.() -> kotlin.Unit) {
            this.connectorProfileProperties = aws.sdk.kotlin.services.appflow.model.ConnectorProfileProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.PrivateConnectionProvisioningState] inside the given [block]
         */
        public fun privateConnectionProvisioningState(block: aws.sdk.kotlin.services.appflow.model.PrivateConnectionProvisioningState.Builder.() -> kotlin.Unit) {
            this.privateConnectionProvisioningState = aws.sdk.kotlin.services.appflow.model.PrivateConnectionProvisioningState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
