// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.appflow.auth.AppflowAuthSchemeProvider
import aws.sdk.kotlin.services.appflow.auth.DefaultAppflowAuthSchemeProvider
import aws.sdk.kotlin.services.appflow.endpoints.AppflowEndpointParameters
import aws.sdk.kotlin.services.appflow.endpoints.AppflowEndpointProvider
import aws.sdk.kotlin.services.appflow.endpoints.DefaultAppflowEndpointProvider
import aws.sdk.kotlin.services.appflow.model.CancelFlowExecutionsRequest
import aws.sdk.kotlin.services.appflow.model.CancelFlowExecutionsResponse
import aws.sdk.kotlin.services.appflow.model.CreateConnectorProfileRequest
import aws.sdk.kotlin.services.appflow.model.CreateConnectorProfileResponse
import aws.sdk.kotlin.services.appflow.model.CreateFlowRequest
import aws.sdk.kotlin.services.appflow.model.CreateFlowResponse
import aws.sdk.kotlin.services.appflow.model.DeleteConnectorProfileRequest
import aws.sdk.kotlin.services.appflow.model.DeleteConnectorProfileResponse
import aws.sdk.kotlin.services.appflow.model.DeleteFlowRequest
import aws.sdk.kotlin.services.appflow.model.DeleteFlowResponse
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorEntityRequest
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorEntityResponse
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorProfilesRequest
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorProfilesResponse
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorRequest
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorResponse
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorsRequest
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorsResponse
import aws.sdk.kotlin.services.appflow.model.DescribeFlowExecutionRecordsRequest
import aws.sdk.kotlin.services.appflow.model.DescribeFlowExecutionRecordsResponse
import aws.sdk.kotlin.services.appflow.model.DescribeFlowRequest
import aws.sdk.kotlin.services.appflow.model.DescribeFlowResponse
import aws.sdk.kotlin.services.appflow.model.ListConnectorEntitiesRequest
import aws.sdk.kotlin.services.appflow.model.ListConnectorEntitiesResponse
import aws.sdk.kotlin.services.appflow.model.ListConnectorsRequest
import aws.sdk.kotlin.services.appflow.model.ListConnectorsResponse
import aws.sdk.kotlin.services.appflow.model.ListFlowsRequest
import aws.sdk.kotlin.services.appflow.model.ListFlowsResponse
import aws.sdk.kotlin.services.appflow.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appflow.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appflow.model.RegisterConnectorRequest
import aws.sdk.kotlin.services.appflow.model.RegisterConnectorResponse
import aws.sdk.kotlin.services.appflow.model.ResetConnectorMetadataCacheRequest
import aws.sdk.kotlin.services.appflow.model.ResetConnectorMetadataCacheResponse
import aws.sdk.kotlin.services.appflow.model.StartFlowRequest
import aws.sdk.kotlin.services.appflow.model.StartFlowResponse
import aws.sdk.kotlin.services.appflow.model.StopFlowRequest
import aws.sdk.kotlin.services.appflow.model.StopFlowResponse
import aws.sdk.kotlin.services.appflow.model.TagResourceRequest
import aws.sdk.kotlin.services.appflow.model.TagResourceResponse
import aws.sdk.kotlin.services.appflow.model.UnregisterConnectorRequest
import aws.sdk.kotlin.services.appflow.model.UnregisterConnectorResponse
import aws.sdk.kotlin.services.appflow.model.UntagResourceRequest
import aws.sdk.kotlin.services.appflow.model.UntagResourceResponse
import aws.sdk.kotlin.services.appflow.model.UpdateConnectorProfileRequest
import aws.sdk.kotlin.services.appflow.model.UpdateConnectorProfileResponse
import aws.sdk.kotlin.services.appflow.model.UpdateConnectorRegistrationRequest
import aws.sdk.kotlin.services.appflow.model.UpdateConnectorRegistrationResponse
import aws.sdk.kotlin.services.appflow.model.UpdateFlowRequest
import aws.sdk.kotlin.services.appflow.model.UpdateFlowResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Appflow"
public const val SdkVersion: String = "1.0.66"
public const val ServiceApiVersion: String = "2020-08-23"

/**
 * Welcome to the Amazon AppFlow API reference. This guide is for developers who need detailed information about the Amazon AppFlow API operations, data types, and errors.
 *
 * Amazon AppFlow is a fully managed integration service that enables you to securely transfer data between software as a service (SaaS) applications like Salesforce, Marketo, Slack, and ServiceNow, and Amazon Web Services like Amazon S3 and Amazon Redshift.
 *
 * Use the following links to get started on the Amazon AppFlow API:
 * + [Actions](https://docs.aws.amazon.com/appflow/1.0/APIReference/API_Operations.html): An alphabetical list of all Amazon AppFlow API operations.
 * + [Data types](https://docs.aws.amazon.com/appflow/1.0/APIReference/API_Types.html): An alphabetical list of all Amazon AppFlow data types.
 * + [Common parameters](https://docs.aws.amazon.com/appflow/1.0/APIReference/CommonParameters.html): Parameters that all Query operations can use.
 * + [Common errors](https://docs.aws.amazon.com/appflow/1.0/APIReference/CommonErrors.html): Client and server errors that all operations can return.
 *
 * If you're new to Amazon AppFlow, we recommend that you review the [Amazon AppFlow User Guide](https://docs.aws.amazon.com/appflow/latest/userguide/what-is-appflow.html).
 *
 * Amazon AppFlow API users can use vendor-specific mechanisms for OAuth, and include applicable OAuth attributes (such as `auth-code` and `redirecturi`) with the connector-specific `ConnectorProfileProperties` when creating a new connector profile using Amazon AppFlow API operations. For example, Salesforce users can refer to the *Authorize Apps with OAuth*[](https://help.salesforce.com/articleView?id=remoteaccess_authenticate.htm) documentation.
 */
public interface AppflowClient : SdkClient {
    /**
     * AppflowClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppflowClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Appflow",
                "APPFLOW",
                "appflow",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppflowClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppflowClient = DefaultAppflowClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppflowEndpointProvider = builder.endpointProvider ?: DefaultAppflowEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppflowAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppflowAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Appflow"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppflowEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppflowAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels active runs for a flow.
     *
     * You can cancel all of the active runs for a flow, or you can cancel specific runs by providing their IDs.
     *
     * You can cancel a flow run only when the run is in progress. You can't cancel a run that has already completed or failed. You also can't cancel a run that's scheduled to occur but hasn't started yet. To prevent a scheduled run, you can deactivate the flow with the `StopFlow` action.
     *
     * You cannot resume a run after you cancel it.
     *
     * When you send your request, the status for each run becomes `CancelStarted`. When the cancellation completes, the status becomes `Canceled`.
     *
     * When you cancel a run, you still incur charges for any data that the run already processed before the cancellation. If the run had already written some data to the flow destination, then that data remains in the destination. If you configured the flow to use a batch API (such as the Salesforce Bulk API 2.0), then the run will finish reading or writing its entire batch of data after the cancellation. For these operations, the data processing charges for Amazon AppFlow apply. For the pricing information, see [Amazon AppFlow pricing](http://aws.amazon.com/appflow/pricing/).
     */
    public suspend fun cancelFlowExecutions(input: CancelFlowExecutionsRequest): CancelFlowExecutionsResponse

    /**
     * Creates a new connector profile associated with your Amazon Web Services account. There is a soft quota of 100 connector profiles per Amazon Web Services account. If you need more connector profiles than this quota allows, you can submit a request to the Amazon AppFlow team through the Amazon AppFlow support channel. In each connector profile that you create, you can provide the credentials and properties for only one connector.
     */
    public suspend fun createConnectorProfile(input: CreateConnectorProfileRequest): CreateConnectorProfileResponse

    /**
     * Enables your application to create a new flow using Amazon AppFlow. You must create a connector profile before calling this API. Please note that the Request Syntax below shows syntax for multiple destinations, however, you can only transfer data to one item in this list at a time. Amazon AppFlow does not currently support flows to multiple destinations at once.
     */
    public suspend fun createFlow(input: CreateFlowRequest): CreateFlowResponse

    /**
     * Enables you to delete an existing connector profile.
     */
    public suspend fun deleteConnectorProfile(input: DeleteConnectorProfileRequest): DeleteConnectorProfileResponse

    /**
     * Enables your application to delete an existing flow. Before deleting the flow, Amazon AppFlow validates the request by checking the flow configuration and status. You can delete flows one at a time.
     */
    public suspend fun deleteFlow(input: DeleteFlowRequest): DeleteFlowResponse

    /**
     * Describes the given custom connector registered in your Amazon Web Services account. This API can be used for custom connectors that are registered in your account and also for Amazon authored connectors.
     */
    public suspend fun describeConnector(input: DescribeConnectorRequest): DescribeConnectorResponse

    /**
     * Provides details regarding the entity used with the connector, with a description of the data model for each field in that entity.
     */
    public suspend fun describeConnectorEntity(input: DescribeConnectorEntityRequest): DescribeConnectorEntityResponse

    /**
     * Returns a list of `connector-profile` details matching the provided `connector-profile` names and `connector-types`. Both input lists are optional, and you can use them to filter the result.
     *
     * If no names or `connector-types` are provided, returns all connector profiles in a paginated form. If there is no match, this operation returns an empty list.
     */
    public suspend fun describeConnectorProfiles(input: DescribeConnectorProfilesRequest = DescribeConnectorProfilesRequest { }): DescribeConnectorProfilesResponse

    /**
     * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be returned in one page, the response contains a `nextToken` object, which can be be passed in to the next call to the `DescribeConnectors` API operation to retrieve the next page.
     */
    public suspend fun describeConnectors(input: DescribeConnectorsRequest = DescribeConnectorsRequest { }): DescribeConnectorsResponse

    /**
     * Provides a description of the specified flow.
     */
    public suspend fun describeFlow(input: DescribeFlowRequest): DescribeFlowResponse

    /**
     * Fetches the execution history of the flow.
     */
    public suspend fun describeFlowExecutionRecords(input: DescribeFlowExecutionRecordsRequest): DescribeFlowExecutionRecordsResponse

    /**
     * Returns the list of available connector entities supported by Amazon AppFlow. For example, you can query Salesforce for *Account* and *Opportunity* entities, or query ServiceNow for the *Incident* entity.
     */
    public suspend fun listConnectorEntities(input: ListConnectorEntitiesRequest = ListConnectorEntitiesRequest { }): ListConnectorEntitiesResponse

    /**
     * Returns the list of all registered custom connectors in your Amazon Web Services account. This API lists only custom connectors registered in this account, not the Amazon Web Services authored connectors.
     */
    public suspend fun listConnectors(input: ListConnectorsRequest = ListConnectorsRequest { }): ListConnectorsResponse

    /**
     * Lists all of the flows associated with your account.
     */
    public suspend fun listFlows(input: ListFlowsRequest = ListFlowsRequest { }): ListFlowsResponse

    /**
     * Retrieves the tags that are associated with a specified flow.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Registers a new custom connector with your Amazon Web Services account. Before you can register the connector, you must deploy the associated AWS lambda function in your account.
     */
    public suspend fun registerConnector(input: RegisterConnectorRequest = RegisterConnectorRequest { }): RegisterConnectorResponse

    /**
     * Resets metadata about your connector entities that Amazon AppFlow stored in its cache. Use this action when you want Amazon AppFlow to return the latest information about the data that you have in a source application.
     *
     * Amazon AppFlow returns metadata about your entities when you use the ListConnectorEntities or DescribeConnectorEntities actions. Following these actions, Amazon AppFlow caches the metadata to reduce the number of API requests that it must send to the source application. Amazon AppFlow automatically resets the cache once every hour, but you can use this action when you want to get the latest metadata right away.
     */
    public suspend fun resetConnectorMetadataCache(input: ResetConnectorMetadataCacheRequest = ResetConnectorMetadataCacheRequest { }): ResetConnectorMetadataCacheResponse

    /**
     * Activates an existing flow. For on-demand flows, this operation runs the flow immediately. For schedule and event-triggered flows, this operation activates the flow.
     */
    public suspend fun startFlow(input: StartFlowRequest): StartFlowResponse

    /**
     * Deactivates the existing flow. For on-demand flows, this operation returns an `unsupportedOperationException` error message. For schedule and event-triggered flows, this operation deactivates the flow.
     */
    public suspend fun stopFlow(input: StopFlowRequest): StopFlowResponse

    /**
     * Applies a tag to the specified flow.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Unregisters the custom connector registered in your account that matches the connector label provided in the request.
     */
    public suspend fun unregisterConnector(input: UnregisterConnectorRequest): UnregisterConnectorResponse

    /**
     * Removes a tag from the specified flow.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a given connector profile associated with your account.
     */
    public suspend fun updateConnectorProfile(input: UpdateConnectorProfileRequest): UpdateConnectorProfileResponse

    /**
     * Updates a custom connector that you've previously registered. This operation updates the connector with one of the following:
     * + The latest version of the AWS Lambda function that's assigned to the connector
     * + A new AWS Lambda function that you specify
     */
    public suspend fun updateConnectorRegistration(input: UpdateConnectorRegistrationRequest): UpdateConnectorRegistrationResponse

    /**
     * Updates an existing flow.
     */
    public suspend fun updateFlow(input: UpdateFlowRequest): UpdateFlowResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppflowClient.withConfig(block: AppflowClient.Config.Builder.() -> Unit): AppflowClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppflowClient(newConfig)
}

/**
 * Cancels active runs for a flow.
 *
 * You can cancel all of the active runs for a flow, or you can cancel specific runs by providing their IDs.
 *
 * You can cancel a flow run only when the run is in progress. You can't cancel a run that has already completed or failed. You also can't cancel a run that's scheduled to occur but hasn't started yet. To prevent a scheduled run, you can deactivate the flow with the `StopFlow` action.
 *
 * You cannot resume a run after you cancel it.
 *
 * When you send your request, the status for each run becomes `CancelStarted`. When the cancellation completes, the status becomes `Canceled`.
 *
 * When you cancel a run, you still incur charges for any data that the run already processed before the cancellation. If the run had already written some data to the flow destination, then that data remains in the destination. If you configured the flow to use a batch API (such as the Salesforce Bulk API 2.0), then the run will finish reading or writing its entire batch of data after the cancellation. For these operations, the data processing charges for Amazon AppFlow apply. For the pricing information, see [Amazon AppFlow pricing](http://aws.amazon.com/appflow/pricing/).
 */
public suspend inline fun AppflowClient.cancelFlowExecutions(crossinline block: CancelFlowExecutionsRequest.Builder.() -> Unit): CancelFlowExecutionsResponse = cancelFlowExecutions(CancelFlowExecutionsRequest.Builder().apply(block).build())

/**
 * Creates a new connector profile associated with your Amazon Web Services account. There is a soft quota of 100 connector profiles per Amazon Web Services account. If you need more connector profiles than this quota allows, you can submit a request to the Amazon AppFlow team through the Amazon AppFlow support channel. In each connector profile that you create, you can provide the credentials and properties for only one connector.
 */
public suspend inline fun AppflowClient.createConnectorProfile(crossinline block: CreateConnectorProfileRequest.Builder.() -> Unit): CreateConnectorProfileResponse = createConnectorProfile(CreateConnectorProfileRequest.Builder().apply(block).build())

/**
 * Enables your application to create a new flow using Amazon AppFlow. You must create a connector profile before calling this API. Please note that the Request Syntax below shows syntax for multiple destinations, however, you can only transfer data to one item in this list at a time. Amazon AppFlow does not currently support flows to multiple destinations at once.
 */
public suspend inline fun AppflowClient.createFlow(crossinline block: CreateFlowRequest.Builder.() -> Unit): CreateFlowResponse = createFlow(CreateFlowRequest.Builder().apply(block).build())

/**
 * Enables you to delete an existing connector profile.
 */
public suspend inline fun AppflowClient.deleteConnectorProfile(crossinline block: DeleteConnectorProfileRequest.Builder.() -> Unit): DeleteConnectorProfileResponse = deleteConnectorProfile(DeleteConnectorProfileRequest.Builder().apply(block).build())

/**
 * Enables your application to delete an existing flow. Before deleting the flow, Amazon AppFlow validates the request by checking the flow configuration and status. You can delete flows one at a time.
 */
public suspend inline fun AppflowClient.deleteFlow(crossinline block: DeleteFlowRequest.Builder.() -> Unit): DeleteFlowResponse = deleteFlow(DeleteFlowRequest.Builder().apply(block).build())

/**
 * Describes the given custom connector registered in your Amazon Web Services account. This API can be used for custom connectors that are registered in your account and also for Amazon authored connectors.
 */
public suspend inline fun AppflowClient.describeConnector(crossinline block: DescribeConnectorRequest.Builder.() -> Unit): DescribeConnectorResponse = describeConnector(DescribeConnectorRequest.Builder().apply(block).build())

/**
 * Provides details regarding the entity used with the connector, with a description of the data model for each field in that entity.
 */
public suspend inline fun AppflowClient.describeConnectorEntity(crossinline block: DescribeConnectorEntityRequest.Builder.() -> Unit): DescribeConnectorEntityResponse = describeConnectorEntity(DescribeConnectorEntityRequest.Builder().apply(block).build())

/**
 * Returns a list of `connector-profile` details matching the provided `connector-profile` names and `connector-types`. Both input lists are optional, and you can use them to filter the result.
 *
 * If no names or `connector-types` are provided, returns all connector profiles in a paginated form. If there is no match, this operation returns an empty list.
 */
public suspend inline fun AppflowClient.describeConnectorProfiles(crossinline block: DescribeConnectorProfilesRequest.Builder.() -> Unit): DescribeConnectorProfilesResponse = describeConnectorProfiles(DescribeConnectorProfilesRequest.Builder().apply(block).build())

/**
 * Describes the connectors vended by Amazon AppFlow for specified connector types. If you don't specify a connector type, this operation describes all connectors vended by Amazon AppFlow. If there are more connectors than can be returned in one page, the response contains a `nextToken` object, which can be be passed in to the next call to the `DescribeConnectors` API operation to retrieve the next page.
 */
public suspend inline fun AppflowClient.describeConnectors(crossinline block: DescribeConnectorsRequest.Builder.() -> Unit): DescribeConnectorsResponse = describeConnectors(DescribeConnectorsRequest.Builder().apply(block).build())

/**
 * Provides a description of the specified flow.
 */
public suspend inline fun AppflowClient.describeFlow(crossinline block: DescribeFlowRequest.Builder.() -> Unit): DescribeFlowResponse = describeFlow(DescribeFlowRequest.Builder().apply(block).build())

/**
 * Fetches the execution history of the flow.
 */
public suspend inline fun AppflowClient.describeFlowExecutionRecords(crossinline block: DescribeFlowExecutionRecordsRequest.Builder.() -> Unit): DescribeFlowExecutionRecordsResponse = describeFlowExecutionRecords(DescribeFlowExecutionRecordsRequest.Builder().apply(block).build())

/**
 * Returns the list of available connector entities supported by Amazon AppFlow. For example, you can query Salesforce for *Account* and *Opportunity* entities, or query ServiceNow for the *Incident* entity.
 */
public suspend inline fun AppflowClient.listConnectorEntities(crossinline block: ListConnectorEntitiesRequest.Builder.() -> Unit): ListConnectorEntitiesResponse = listConnectorEntities(ListConnectorEntitiesRequest.Builder().apply(block).build())

/**
 * Returns the list of all registered custom connectors in your Amazon Web Services account. This API lists only custom connectors registered in this account, not the Amazon Web Services authored connectors.
 */
public suspend inline fun AppflowClient.listConnectors(crossinline block: ListConnectorsRequest.Builder.() -> Unit): ListConnectorsResponse = listConnectors(ListConnectorsRequest.Builder().apply(block).build())

/**
 * Lists all of the flows associated with your account.
 */
public suspend inline fun AppflowClient.listFlows(crossinline block: ListFlowsRequest.Builder.() -> Unit): ListFlowsResponse = listFlows(ListFlowsRequest.Builder().apply(block).build())

/**
 * Retrieves the tags that are associated with a specified flow.
 */
public suspend inline fun AppflowClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Registers a new custom connector with your Amazon Web Services account. Before you can register the connector, you must deploy the associated AWS lambda function in your account.
 */
public suspend inline fun AppflowClient.registerConnector(crossinline block: RegisterConnectorRequest.Builder.() -> Unit): RegisterConnectorResponse = registerConnector(RegisterConnectorRequest.Builder().apply(block).build())

/**
 * Resets metadata about your connector entities that Amazon AppFlow stored in its cache. Use this action when you want Amazon AppFlow to return the latest information about the data that you have in a source application.
 *
 * Amazon AppFlow returns metadata about your entities when you use the ListConnectorEntities or DescribeConnectorEntities actions. Following these actions, Amazon AppFlow caches the metadata to reduce the number of API requests that it must send to the source application. Amazon AppFlow automatically resets the cache once every hour, but you can use this action when you want to get the latest metadata right away.
 */
public suspend inline fun AppflowClient.resetConnectorMetadataCache(crossinline block: ResetConnectorMetadataCacheRequest.Builder.() -> Unit): ResetConnectorMetadataCacheResponse = resetConnectorMetadataCache(ResetConnectorMetadataCacheRequest.Builder().apply(block).build())

/**
 * Activates an existing flow. For on-demand flows, this operation runs the flow immediately. For schedule and event-triggered flows, this operation activates the flow.
 */
public suspend inline fun AppflowClient.startFlow(crossinline block: StartFlowRequest.Builder.() -> Unit): StartFlowResponse = startFlow(StartFlowRequest.Builder().apply(block).build())

/**
 * Deactivates the existing flow. For on-demand flows, this operation returns an `unsupportedOperationException` error message. For schedule and event-triggered flows, this operation deactivates the flow.
 */
public suspend inline fun AppflowClient.stopFlow(crossinline block: StopFlowRequest.Builder.() -> Unit): StopFlowResponse = stopFlow(StopFlowRequest.Builder().apply(block).build())

/**
 * Applies a tag to the specified flow.
 */
public suspend inline fun AppflowClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Unregisters the custom connector registered in your account that matches the connector label provided in the request.
 */
public suspend inline fun AppflowClient.unregisterConnector(crossinline block: UnregisterConnectorRequest.Builder.() -> Unit): UnregisterConnectorResponse = unregisterConnector(UnregisterConnectorRequest.Builder().apply(block).build())

/**
 * Removes a tag from the specified flow.
 */
public suspend inline fun AppflowClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a given connector profile associated with your account.
 */
public suspend inline fun AppflowClient.updateConnectorProfile(crossinline block: UpdateConnectorProfileRequest.Builder.() -> Unit): UpdateConnectorProfileResponse = updateConnectorProfile(UpdateConnectorProfileRequest.Builder().apply(block).build())

/**
 * Updates a custom connector that you've previously registered. This operation updates the connector with one of the following:
 * + The latest version of the AWS Lambda function that's assigned to the connector
 * + A new AWS Lambda function that you specify
 */
public suspend inline fun AppflowClient.updateConnectorRegistration(crossinline block: UpdateConnectorRegistrationRequest.Builder.() -> Unit): UpdateConnectorRegistrationResponse = updateConnectorRegistration(UpdateConnectorRegistrationRequest.Builder().apply(block).build())

/**
 * Updates an existing flow.
 */
public suspend inline fun AppflowClient.updateFlow(crossinline block: UpdateFlowRequest.Builder.() -> Unit): UpdateFlowResponse = updateFlow(UpdateFlowRequest.Builder().apply(block).build())
