// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * Describes the status of an attempt from Amazon AppFlow to register a resource.
 *
 * When you run a flow that you've configured to use a metadata catalog, Amazon AppFlow registers a metadata table and data partitions with that catalog. This operation provides the status of that registration attempt. The operation also indicates how many related resources Amazon AppFlow created or updated.
 */
public class RegistrationOutput private constructor(builder: Builder) {
    /**
     * Explains the status of the registration attempt from Amazon AppFlow. If the attempt fails, the message explains why.
     */
    public val message: kotlin.String? = builder.message
    /**
     * Indicates the number of resources that Amazon AppFlow created or updated. Possible resources include metadata tables and data partitions.
     */
    public val result: kotlin.String? = builder.result
    /**
     * Indicates the status of the registration attempt from Amazon AppFlow.
     */
    public val status: aws.sdk.kotlin.services.appflow.model.ExecutionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.RegistrationOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegistrationOutput(")
        append("message=$message,")
        append("result=$result,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (result?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegistrationOutput

        if (message != other.message) return false
        if (result != other.result) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.RegistrationOutput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Explains the status of the registration attempt from Amazon AppFlow. If the attempt fails, the message explains why.
         */
        public var message: kotlin.String? = null
        /**
         * Indicates the number of resources that Amazon AppFlow created or updated. Possible resources include metadata tables and data partitions.
         */
        public var result: kotlin.String? = null
        /**
         * Indicates the status of the registration attempt from Amazon AppFlow.
         */
        public var status: aws.sdk.kotlin.services.appflow.model.ExecutionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.RegistrationOutput) : this() {
            this.message = x.message
            this.result = x.result
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.RegistrationOutput = RegistrationOutput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
