// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



public class CreateConnectorProfileRequest private constructor(builder: Builder) {
    /**
     * The `clientToken` parameter is an idempotency token. It ensures that your `CreateConnectorProfile` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
     *
     * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
     *
     * If you specify input parameters that differ from your first request, an error occurs. If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `CreateConnectorProfile`. The token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet.
     */
    public val connectionMode: aws.sdk.kotlin.services.appflow.model.ConnectionMode? = builder.connectionMode
    /**
     * The label of the connector. The label is unique for each `ConnectorRegistration` in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
     */
    public val connectorLabel: kotlin.String? = builder.connectorLabel
    /**
     * Defines the connector-specific configuration and credentials.
     */
    public val connectorProfileConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig? = builder.connectorProfileConfig
    /**
     * The name of the connector profile. The name is unique for each `ConnectorProfile` in your Amazon Web Services account.
     */
    public val connectorProfileName: kotlin.String? = builder.connectorProfileName
    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     */
    public val connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = builder.connectorType
    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    public val kmsArn: kotlin.String? = builder.kmsArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.CreateConnectorProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConnectorProfileRequest(")
        append("clientToken=$clientToken,")
        append("connectionMode=$connectionMode,")
        append("connectorLabel=$connectorLabel,")
        append("connectorProfileConfig=$connectorProfileConfig,")
        append("connectorProfileName=$connectorProfileName,")
        append("connectorType=$connectorType,")
        append("kmsArn=$kmsArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (connectionMode?.hashCode() ?: 0)
        result = 31 * result + (connectorLabel?.hashCode() ?: 0)
        result = 31 * result + (connectorProfileConfig?.hashCode() ?: 0)
        result = 31 * result + (connectorProfileName?.hashCode() ?: 0)
        result = 31 * result + (connectorType?.hashCode() ?: 0)
        result = 31 * result + (kmsArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConnectorProfileRequest

        if (clientToken != other.clientToken) return false
        if (connectionMode != other.connectionMode) return false
        if (connectorLabel != other.connectorLabel) return false
        if (connectorProfileConfig != other.connectorProfileConfig) return false
        if (connectorProfileName != other.connectorProfileName) return false
        if (connectorType != other.connectorType) return false
        if (kmsArn != other.kmsArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.CreateConnectorProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `clientToken` parameter is an idempotency token. It ensures that your `CreateConnectorProfile` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
         *
         * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
         *
         * If you specify input parameters that differ from your first request, an error occurs. If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `CreateConnectorProfile`. The token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Indicates the connection mode and specifies whether it is public or private. Private flows use Amazon Web Services PrivateLink to route data over Amazon Web Services infrastructure without exposing it to the public internet.
         */
        public var connectionMode: aws.sdk.kotlin.services.appflow.model.ConnectionMode? = null
        /**
         * The label of the connector. The label is unique for each `ConnectorRegistration` in your Amazon Web Services account. Only needed if calling for CUSTOMCONNECTOR connector type/.
         */
        public var connectorLabel: kotlin.String? = null
        /**
         * Defines the connector-specific configuration and credentials.
         */
        public var connectorProfileConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig? = null
        /**
         * The name of the connector profile. The name is unique for each `ConnectorProfile` in your Amazon Web Services account.
         */
        public var connectorProfileName: kotlin.String? = null
        /**
         * The type of connector, such as Salesforce, Amplitude, and so on.
         */
        public var connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = null
        /**
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         */
        public var kmsArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.CreateConnectorProfileRequest) : this() {
            this.clientToken = x.clientToken
            this.connectionMode = x.connectionMode
            this.connectorLabel = x.connectorLabel
            this.connectorProfileConfig = x.connectorProfileConfig
            this.connectorProfileName = x.connectorProfileName
            this.connectorType = x.connectorType
            this.kmsArn = x.kmsArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.CreateConnectorProfileRequest = CreateConnectorProfileRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig] inside the given [block]
         */
        public fun connectorProfileConfig(block: aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig.Builder.() -> kotlin.Unit) {
            this.connectorProfileConfig = aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
