// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeFlowResponse private constructor(builder: Builder) {
    /**
     * Specifies when the flow was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The ARN of the user who created the flow.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * A description of the flow.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
     */
    public val destinationFlowConfigList: List<DestinationFlowConfig>? = builder.destinationFlowConfigList
    /**
     * The flow's Amazon Resource Name (ARN).
     */
    public val flowArn: kotlin.String? = builder.flowArn
    /**
     * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    public val flowName: kotlin.String? = builder.flowName
    /**
     * Indicates the current status of the flow.
     */
    public val flowStatus: aws.sdk.kotlin.services.appflow.model.FlowStatus? = builder.flowStatus
    /**
     * Contains an error message if the flow status is in a suspended or error state. This applies only to scheduled or event-triggered flows.
     */
    public val flowStatusMessage: kotlin.String? = builder.flowStatusMessage
    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    public val kmsArn: kotlin.String? = builder.kmsArn
    /**
     * Describes the details of the most recent flow run.
     */
    public val lastRunExecutionDetails: aws.sdk.kotlin.services.appflow.model.ExecutionDetails? = builder.lastRunExecutionDetails
    /**
     * Describes the metadata catalog, metadata table, and data partitions that Amazon AppFlow used for the associated flow run.
     */
    public val lastRunMetadataCatalogDetails: List<MetadataCatalogDetail>? = builder.lastRunMetadataCatalogDetails
    /**
     * Specifies when the flow was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * Specifies the user name of the account that performed the most recent update.
     */
    public val lastUpdatedBy: kotlin.String? = builder.lastUpdatedBy
    /**
     * Specifies the configuration that Amazon AppFlow uses when it catalogs the data that's transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
     */
    public val metadataCatalogConfig: aws.sdk.kotlin.services.appflow.model.MetadataCatalogConfig? = builder.metadataCatalogConfig
    /**
     * The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases by one when you change any of the following settings in your flow configuration:
     * + Source-to-destination field mappings
     * + Field data types
     * + Partition keys
     */
    public val schemaVersion: kotlin.Long? = builder.schemaVersion
    /**
     * The configuration that controls how Amazon AppFlow retrieves data from the source connector.
     */
    public val sourceFlowConfig: aws.sdk.kotlin.services.appflow.model.SourceFlowConfig? = builder.sourceFlowConfig
    /**
     * The tags used to organize, track, or control access for your flow.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    public val tasks: List<Task>? = builder.tasks
    /**
     * The trigger settings that determine how and when the flow runs.
     */
    public val triggerConfig: aws.sdk.kotlin.services.appflow.model.TriggerConfig? = builder.triggerConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.DescribeFlowResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFlowResponse(")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("destinationFlowConfigList=$destinationFlowConfigList,")
        append("flowArn=$flowArn,")
        append("flowName=$flowName,")
        append("flowStatus=$flowStatus,")
        append("flowStatusMessage=$flowStatusMessage,")
        append("kmsArn=$kmsArn,")
        append("lastRunExecutionDetails=$lastRunExecutionDetails,")
        append("lastRunMetadataCatalogDetails=$lastRunMetadataCatalogDetails,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lastUpdatedBy=$lastUpdatedBy,")
        append("metadataCatalogConfig=$metadataCatalogConfig,")
        append("schemaVersion=$schemaVersion,")
        append("sourceFlowConfig=$sourceFlowConfig,")
        append("tags=$tags,")
        append("tasks=$tasks,")
        append("triggerConfig=$triggerConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationFlowConfigList?.hashCode() ?: 0)
        result = 31 * result + (flowArn?.hashCode() ?: 0)
        result = 31 * result + (flowName?.hashCode() ?: 0)
        result = 31 * result + (flowStatus?.hashCode() ?: 0)
        result = 31 * result + (flowStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (kmsArn?.hashCode() ?: 0)
        result = 31 * result + (lastRunExecutionDetails?.hashCode() ?: 0)
        result = 31 * result + (lastRunMetadataCatalogDetails?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (metadataCatalogConfig?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (sourceFlowConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tasks?.hashCode() ?: 0)
        result = 31 * result + (triggerConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFlowResponse

        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (destinationFlowConfigList != other.destinationFlowConfigList) return false
        if (flowArn != other.flowArn) return false
        if (flowName != other.flowName) return false
        if (flowStatus != other.flowStatus) return false
        if (flowStatusMessage != other.flowStatusMessage) return false
        if (kmsArn != other.kmsArn) return false
        if (lastRunExecutionDetails != other.lastRunExecutionDetails) return false
        if (lastRunMetadataCatalogDetails != other.lastRunMetadataCatalogDetails) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lastUpdatedBy != other.lastUpdatedBy) return false
        if (metadataCatalogConfig != other.metadataCatalogConfig) return false
        if (schemaVersion != other.schemaVersion) return false
        if (sourceFlowConfig != other.sourceFlowConfig) return false
        if (tags != other.tags) return false
        if (tasks != other.tasks) return false
        if (triggerConfig != other.triggerConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.DescribeFlowResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies when the flow was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the user who created the flow.
         */
        public var createdBy: kotlin.String? = null
        /**
         * A description of the flow.
         */
        public var description: kotlin.String? = null
        /**
         * The configuration that controls how Amazon AppFlow transfers data to the destination connector.
         */
        public var destinationFlowConfigList: List<DestinationFlowConfig>? = null
        /**
         * The flow's Amazon Resource Name (ARN).
         */
        public var flowArn: kotlin.String? = null
        /**
         * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         */
        public var flowName: kotlin.String? = null
        /**
         * Indicates the current status of the flow.
         */
        public var flowStatus: aws.sdk.kotlin.services.appflow.model.FlowStatus? = null
        /**
         * Contains an error message if the flow status is in a suspended or error state. This applies only to scheduled or event-triggered flows.
         */
        public var flowStatusMessage: kotlin.String? = null
        /**
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         */
        public var kmsArn: kotlin.String? = null
        /**
         * Describes the details of the most recent flow run.
         */
        public var lastRunExecutionDetails: aws.sdk.kotlin.services.appflow.model.ExecutionDetails? = null
        /**
         * Describes the metadata catalog, metadata table, and data partitions that Amazon AppFlow used for the associated flow run.
         */
        public var lastRunMetadataCatalogDetails: List<MetadataCatalogDetail>? = null
        /**
         * Specifies when the flow was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the user name of the account that performed the most recent update.
         */
        public var lastUpdatedBy: kotlin.String? = null
        /**
         * Specifies the configuration that Amazon AppFlow uses when it catalogs the data that's transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
         */
        public var metadataCatalogConfig: aws.sdk.kotlin.services.appflow.model.MetadataCatalogConfig? = null
        /**
         * The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases by one when you change any of the following settings in your flow configuration:
         * + Source-to-destination field mappings
         * + Field data types
         * + Partition keys
         */
        public var schemaVersion: kotlin.Long? = null
        /**
         * The configuration that controls how Amazon AppFlow retrieves data from the source connector.
         */
        public var sourceFlowConfig: aws.sdk.kotlin.services.appflow.model.SourceFlowConfig? = null
        /**
         * The tags used to organize, track, or control access for your flow.
         */
        public var tags: Map<String, String>? = null
        /**
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         */
        public var tasks: List<Task>? = null
        /**
         * The trigger settings that determine how and when the flow runs.
         */
        public var triggerConfig: aws.sdk.kotlin.services.appflow.model.TriggerConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.DescribeFlowResponse) : this() {
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.destinationFlowConfigList = x.destinationFlowConfigList
            this.flowArn = x.flowArn
            this.flowName = x.flowName
            this.flowStatus = x.flowStatus
            this.flowStatusMessage = x.flowStatusMessage
            this.kmsArn = x.kmsArn
            this.lastRunExecutionDetails = x.lastRunExecutionDetails
            this.lastRunMetadataCatalogDetails = x.lastRunMetadataCatalogDetails
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lastUpdatedBy = x.lastUpdatedBy
            this.metadataCatalogConfig = x.metadataCatalogConfig
            this.schemaVersion = x.schemaVersion
            this.sourceFlowConfig = x.sourceFlowConfig
            this.tags = x.tags
            this.tasks = x.tasks
            this.triggerConfig = x.triggerConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.DescribeFlowResponse = DescribeFlowResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ExecutionDetails] inside the given [block]
         */
        public fun lastRunExecutionDetails(block: aws.sdk.kotlin.services.appflow.model.ExecutionDetails.Builder.() -> kotlin.Unit) {
            this.lastRunExecutionDetails = aws.sdk.kotlin.services.appflow.model.ExecutionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.MetadataCatalogConfig] inside the given [block]
         */
        public fun metadataCatalogConfig(block: aws.sdk.kotlin.services.appflow.model.MetadataCatalogConfig.Builder.() -> kotlin.Unit) {
            this.metadataCatalogConfig = aws.sdk.kotlin.services.appflow.model.MetadataCatalogConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.SourceFlowConfig] inside the given [block]
         */
        public fun sourceFlowConfig(block: aws.sdk.kotlin.services.appflow.model.SourceFlowConfig.Builder.() -> kotlin.Unit) {
            this.sourceFlowConfig = aws.sdk.kotlin.services.appflow.model.SourceFlowConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.TriggerConfig] inside the given [block]
         */
        public fun triggerConfig(block: aws.sdk.kotlin.services.appflow.model.TriggerConfig.Builder.() -> kotlin.Unit) {
            this.triggerConfig = aws.sdk.kotlin.services.appflow.model.TriggerConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
