// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * Custom parameter required for OAuth 2.0 authentication.
 */
public class OAuth2CustomParameter private constructor(builder: Builder) {
    /**
     * Contains default values for this authentication parameter that are supplied by the connector.
     */
    public val connectorSuppliedValues: List<String>? = builder.connectorSuppliedValues
    /**
     * A description about the custom parameter used for OAuth 2.0 authentication.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether the custom parameter for OAuth 2.0 authentication is required.
     */
    public val isRequired: kotlin.Boolean = builder.isRequired
    /**
     * Indicates whether this authentication custom parameter is a sensitive field.
     */
    public val isSensitiveField: kotlin.Boolean = builder.isSensitiveField
    /**
     * The key of the custom parameter required for OAuth 2.0 authentication.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The label of the custom parameter used for OAuth 2.0 authentication.
     */
    public val label: kotlin.String? = builder.label
    /**
     * Indicates whether custom parameter is used with TokenUrl or AuthUrl.
     */
    public val type: aws.sdk.kotlin.services.appflow.model.OAuth2CustomPropType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.OAuth2CustomParameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OAuth2CustomParameter(")
        append("connectorSuppliedValues=$connectorSuppliedValues,")
        append("description=$description,")
        append("isRequired=$isRequired,")
        append("isSensitiveField=$isSensitiveField,")
        append("key=$key,")
        append("label=$label,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectorSuppliedValues?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isRequired.hashCode())
        result = 31 * result + (isSensitiveField.hashCode())
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OAuth2CustomParameter

        if (connectorSuppliedValues != other.connectorSuppliedValues) return false
        if (description != other.description) return false
        if (isRequired != other.isRequired) return false
        if (isSensitiveField != other.isSensitiveField) return false
        if (key != other.key) return false
        if (label != other.label) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.OAuth2CustomParameter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains default values for this authentication parameter that are supplied by the connector.
         */
        public var connectorSuppliedValues: List<String>? = null
        /**
         * A description about the custom parameter used for OAuth 2.0 authentication.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether the custom parameter for OAuth 2.0 authentication is required.
         */
        public var isRequired: kotlin.Boolean = false
        /**
         * Indicates whether this authentication custom parameter is a sensitive field.
         */
        public var isSensitiveField: kotlin.Boolean = false
        /**
         * The key of the custom parameter required for OAuth 2.0 authentication.
         */
        public var key: kotlin.String? = null
        /**
         * The label of the custom parameter used for OAuth 2.0 authentication.
         */
        public var label: kotlin.String? = null
        /**
         * Indicates whether custom parameter is used with TokenUrl or AuthUrl.
         */
        public var type: aws.sdk.kotlin.services.appflow.model.OAuth2CustomPropType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.OAuth2CustomParameter) : this() {
            this.connectorSuppliedValues = x.connectorSuppliedValues
            this.description = x.description
            this.isRequired = x.isRequired
            this.isSensitiveField = x.isSensitiveField
            this.key = x.key
            this.label = x.label
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.OAuth2CustomParameter = OAuth2CustomParameter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
