// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The properties that can be applied to a field when connector is being used as a destination.
 */
public class DestinationFieldProperties private constructor(builder: Builder) {
    /**
     * Specifies if the destination field can be created by the current user.
     */
    public val isCreatable: kotlin.Boolean = builder.isCreatable
    /**
     * Specifies whether the field can use the default value during a Create operation.
     */
    public val isDefaultedOnCreate: kotlin.Boolean = builder.isDefaultedOnCreate
    /**
     * Specifies if the destination field can have a null value.
     */
    public val isNullable: kotlin.Boolean = builder.isNullable
    /**
     * Specifies whether the field can be updated during an `UPDATE` or `UPSERT` write operation.
     */
    public val isUpdatable: kotlin.Boolean = builder.isUpdatable
    /**
     * Specifies if the flow run can either insert new rows in the destination field if they do not already exist, or update them if they do.
     */
    public val isUpsertable: kotlin.Boolean = builder.isUpsertable
    /**
     * A list of supported write operations. For each write operation listed, this field can be used in `idFieldNames` when that write operation is present as a destination option.
     */
    public val supportedWriteOperations: List<WriteOperationType>? = builder.supportedWriteOperations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationFieldProperties(")
        append("isCreatable=$isCreatable,")
        append("isDefaultedOnCreate=$isDefaultedOnCreate,")
        append("isNullable=$isNullable,")
        append("isUpdatable=$isUpdatable,")
        append("isUpsertable=$isUpsertable,")
        append("supportedWriteOperations=$supportedWriteOperations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isCreatable.hashCode()
        result = 31 * result + (isDefaultedOnCreate.hashCode())
        result = 31 * result + (isNullable.hashCode())
        result = 31 * result + (isUpdatable.hashCode())
        result = 31 * result + (isUpsertable.hashCode())
        result = 31 * result + (supportedWriteOperations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationFieldProperties

        if (isCreatable != other.isCreatable) return false
        if (isDefaultedOnCreate != other.isDefaultedOnCreate) return false
        if (isNullable != other.isNullable) return false
        if (isUpdatable != other.isUpdatable) return false
        if (isUpsertable != other.isUpsertable) return false
        if (supportedWriteOperations != other.supportedWriteOperations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies if the destination field can be created by the current user.
         */
        public var isCreatable: kotlin.Boolean = false
        /**
         * Specifies whether the field can use the default value during a Create operation.
         */
        public var isDefaultedOnCreate: kotlin.Boolean = false
        /**
         * Specifies if the destination field can have a null value.
         */
        public var isNullable: kotlin.Boolean = false
        /**
         * Specifies whether the field can be updated during an `UPDATE` or `UPSERT` write operation.
         */
        public var isUpdatable: kotlin.Boolean = false
        /**
         * Specifies if the flow run can either insert new rows in the destination field if they do not already exist, or update them if they do.
         */
        public var isUpsertable: kotlin.Boolean = false
        /**
         * A list of supported write operations. For each write operation listed, this field can be used in `idFieldNames` when that write operation is present as a destination option.
         */
        public var supportedWriteOperations: List<WriteOperationType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties) : this() {
            this.isCreatable = x.isCreatable
            this.isDefaultedOnCreate = x.isDefaultedOnCreate
            this.isNullable = x.isNullable
            this.isUpdatable = x.isUpdatable
            this.isUpsertable = x.isUpsertable
            this.supportedWriteOperations = x.supportedWriteOperations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.DestinationFieldProperties = DestinationFieldProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
