// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The connector-specific profile properties when using Amazon Redshift.
 */
public class RedshiftConnectorProfileProperties private constructor(builder: Builder) {
    /**
     * A name for the associated Amazon S3 bucket.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    public val bucketPrefix: kotlin.String? = builder.bucketPrefix
    /**
     * The unique ID that's assigned to an Amazon Redshift cluster.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to access your Amazon Redshift database through the Data API. For more information, and for the polices that you attach to this role, see [Allow Amazon AppFlow to access Amazon Redshift databases with the Data API](https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift).
     */
    public val dataApiRoleArn: kotlin.String? = builder.dataApiRoleArn
    /**
     * The name of an Amazon Redshift database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The JDBC URL of the Amazon Redshift cluster.
     */
    public val databaseUrl: kotlin.String? = builder.databaseUrl
    /**
     * Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data warehouse.
     */
    public val isRedshiftServerless: kotlin.Boolean = builder.isRedshiftServerless
    /**
     * The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift read-only access to Amazon S3. For more information, and for the polices that you attach to this role, see [Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3](https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3).
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The name of an Amazon Redshift workgroup.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.RedshiftConnectorProfileProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftConnectorProfileProperties(")
        append("bucketName=$bucketName,")
        append("bucketPrefix=$bucketPrefix,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("dataApiRoleArn=$dataApiRoleArn,")
        append("databaseName=$databaseName,")
        append("databaseUrl=$databaseUrl,")
        append("isRedshiftServerless=$isRedshiftServerless,")
        append("roleArn=$roleArn,")
        append("workgroupName=$workgroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (bucketPrefix?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dataApiRoleArn?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (databaseUrl?.hashCode() ?: 0)
        result = 31 * result + (isRedshiftServerless.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftConnectorProfileProperties

        if (bucketName != other.bucketName) return false
        if (bucketPrefix != other.bucketPrefix) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (dataApiRoleArn != other.dataApiRoleArn) return false
        if (databaseName != other.databaseName) return false
        if (databaseUrl != other.databaseUrl) return false
        if (isRedshiftServerless != other.isRedshiftServerless) return false
        if (roleArn != other.roleArn) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.RedshiftConnectorProfileProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A name for the associated Amazon S3 bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * The unique ID that's assigned to an Amazon Redshift cluster.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that permits Amazon AppFlow to access your Amazon Redshift database through the Data API. For more information, and for the polices that you attach to this role, see [Allow Amazon AppFlow to access Amazon Redshift databases with the Data API](https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#access-redshift).
         */
        public var dataApiRoleArn: kotlin.String? = null
        /**
         * The name of an Amazon Redshift database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The JDBC URL of the Amazon Redshift cluster.
         */
        public var databaseUrl: kotlin.String? = null
        /**
         * Indicates whether the connector profile defines a connection to an Amazon Redshift Serverless data warehouse.
         */
        public var isRedshiftServerless: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of IAM role that grants Amazon Redshift read-only access to Amazon S3. For more information, and for the polices that you attach to this role, see [Allow Amazon Redshift to access your Amazon AppFlow data in Amazon S3](https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_service-role-policies.html#redshift-access-s3).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name of an Amazon Redshift workgroup.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.RedshiftConnectorProfileProperties) : this() {
            this.bucketName = x.bucketName
            this.bucketPrefix = x.bucketPrefix
            this.clusterIdentifier = x.clusterIdentifier
            this.dataApiRoleArn = x.dataApiRoleArn
            this.databaseName = x.databaseName
            this.databaseUrl = x.databaseUrl
            this.isRedshiftServerless = x.isRedshiftServerless
            this.roleArn = x.roleArn
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.RedshiftConnectorProfileProperties = RedshiftConnectorProfileProperties(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (roleArn == null) roleArn = ""
            return this
        }
    }
}
