// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The properties that are applied when the custom connector is being used as a destination.
 */
public class CustomConnectorDestinationProperties private constructor(builder: Builder) {
    /**
     * The custom properties that are specific to the connector when it's used as a destination in the flow.
     */
    public val customProperties: Map<String, String>? = builder.customProperties
    /**
     * The entity specified in the custom connector as a destination in the flow.
     */
    public val entityName: kotlin.String = requireNotNull(builder.entityName) { "A non-null value must be provided for entityName" }
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.
     */
    public val errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = builder.errorHandlingConfig
    /**
     * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
     */
    public val idFieldNames: List<String>? = builder.idFieldNames
    /**
     * Specifies the type of write operation to be performed in the custom connector when it's used as destination.
     */
    public val writeOperationType: aws.sdk.kotlin.services.appflow.model.WriteOperationType? = builder.writeOperationType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.CustomConnectorDestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomConnectorDestinationProperties(")
        append("customProperties=$customProperties,")
        append("entityName=$entityName,")
        append("errorHandlingConfig=$errorHandlingConfig,")
        append("idFieldNames=$idFieldNames,")
        append("writeOperationType=$writeOperationType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customProperties?.hashCode() ?: 0
        result = 31 * result + (entityName.hashCode())
        result = 31 * result + (errorHandlingConfig?.hashCode() ?: 0)
        result = 31 * result + (idFieldNames?.hashCode() ?: 0)
        result = 31 * result + (writeOperationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomConnectorDestinationProperties

        if (customProperties != other.customProperties) return false
        if (entityName != other.entityName) return false
        if (errorHandlingConfig != other.errorHandlingConfig) return false
        if (idFieldNames != other.idFieldNames) return false
        if (writeOperationType != other.writeOperationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.CustomConnectorDestinationProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The custom properties that are specific to the connector when it's used as a destination in the flow.
         */
        public var customProperties: Map<String, String>? = null
        /**
         * The entity specified in the custom connector as a destination in the flow.
         */
        public var entityName: kotlin.String? = null
        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.
         */
        public var errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = null
        /**
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
         */
        public var idFieldNames: List<String>? = null
        /**
         * Specifies the type of write operation to be performed in the custom connector when it's used as destination.
         */
        public var writeOperationType: aws.sdk.kotlin.services.appflow.model.WriteOperationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.CustomConnectorDestinationProperties) : this() {
            this.customProperties = x.customProperties
            this.entityName = x.entityName
            this.errorHandlingConfig = x.errorHandlingConfig
            this.idFieldNames = x.idFieldNames
            this.writeOperationType = x.writeOperationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.CustomConnectorDestinationProperties = CustomConnectorDestinationProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig] inside the given [block]
         */
        public fun errorHandlingConfig(block: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.Builder.() -> kotlin.Unit) {
            this.errorHandlingConfig = aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (entityName == null) entityName = ""
            return this
        }
    }
}
