// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.serde

import aws.sdk.kotlin.services.appflow.model.AppflowException
import aws.sdk.kotlin.services.appflow.model.DescribeFlowResponse
import aws.sdk.kotlin.services.appflow.model.DestinationFlowConfig
import aws.sdk.kotlin.services.appflow.model.ExecutionDetails
import aws.sdk.kotlin.services.appflow.model.FlowStatus
import aws.sdk.kotlin.services.appflow.model.MetadataCatalogConfig
import aws.sdk.kotlin.services.appflow.model.MetadataCatalogDetail
import aws.sdk.kotlin.services.appflow.model.SourceFlowConfig
import aws.sdk.kotlin.services.appflow.model.Task
import aws.sdk.kotlin.services.appflow.model.TriggerConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeFlowOperationDeserializer: HttpDeserializer.NonStreaming<DescribeFlowResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeFlowResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeFlowError(context, call, payload)
        }
        val builder = DescribeFlowResponse.Builder()

        if (payload != null) {
            deserializeDescribeFlowOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeFlowError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AppflowException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AppflowException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFlowOperationBody(builder: DescribeFlowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("createdBy"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DESTINATIONFLOWCONFIGLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("destinationFlowConfigList"))
    val FLOWARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("flowArn"))
    val FLOWNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("flowName"))
    val FLOWSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("flowStatus"))
    val FLOWSTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("flowStatusMessage"))
    val KMSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsArn"))
    val LASTRUNEXECUTIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lastRunExecutionDetails"))
    val LASTRUNMETADATACATALOGDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("lastRunMetadataCatalogDetails"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedAt"))
    val LASTUPDATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lastUpdatedBy"))
    val METADATACATALOGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metadataCatalogConfig"))
    val SCHEMAVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("schemaVersion"))
    val SOURCEFLOWCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sourceFlowConfig"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TASKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tasks"))
    val TRIGGERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("triggerConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DESTINATIONFLOWCONFIGLIST_DESCRIPTOR)
        field(FLOWARN_DESCRIPTOR)
        field(FLOWNAME_DESCRIPTOR)
        field(FLOWSTATUS_DESCRIPTOR)
        field(FLOWSTATUSMESSAGE_DESCRIPTOR)
        field(KMSARN_DESCRIPTOR)
        field(LASTRUNEXECUTIONDETAILS_DESCRIPTOR)
        field(LASTRUNMETADATACATALOGDETAILS_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(LASTUPDATEDBY_DESCRIPTOR)
        field(METADATACATALOGCONFIG_DESCRIPTOR)
        field(SCHEMAVERSION_DESCRIPTOR)
        field(SOURCEFLOWCONFIG_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TASKS_DESCRIPTOR)
        field(TRIGGERCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DESTINATIONFLOWCONFIGLIST_DESCRIPTOR.index -> builder.destinationFlowConfigList =
                    deserializer.deserializeList(DESTINATIONFLOWCONFIGLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<DestinationFlowConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDestinationFlowConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FLOWARN_DESCRIPTOR.index -> builder.flowArn = deserializeString()
                FLOWNAME_DESCRIPTOR.index -> builder.flowName = deserializeString()
                FLOWSTATUS_DESCRIPTOR.index -> builder.flowStatus = deserializeString().let { FlowStatus.fromValue(it) }
                FLOWSTATUSMESSAGE_DESCRIPTOR.index -> builder.flowStatusMessage = deserializeString()
                KMSARN_DESCRIPTOR.index -> builder.kmsArn = deserializeString()
                LASTRUNEXECUTIONDETAILS_DESCRIPTOR.index -> builder.lastRunExecutionDetails = deserializeExecutionDetailsDocument(deserializer)
                LASTRUNMETADATACATALOGDETAILS_DESCRIPTOR.index -> builder.lastRunMetadataCatalogDetails =
                    deserializer.deserializeList(LASTRUNMETADATACATALOGDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<MetadataCatalogDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMetadataCatalogDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTUPDATEDBY_DESCRIPTOR.index -> builder.lastUpdatedBy = deserializeString()
                METADATACATALOGCONFIG_DESCRIPTOR.index -> builder.metadataCatalogConfig = deserializeMetadataCatalogConfigDocument(deserializer)
                SCHEMAVERSION_DESCRIPTOR.index -> builder.schemaVersion = deserializeLong()
                SOURCEFLOWCONFIG_DESCRIPTOR.index -> builder.sourceFlowConfig = deserializeSourceFlowConfigDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TASKS_DESCRIPTOR.index -> builder.tasks =
                    deserializer.deserializeList(TASKS_DESCRIPTOR) {
                        val col0 = mutableListOf<Task>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTaskDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TRIGGERCONFIG_DESCRIPTOR.index -> builder.triggerConfig = deserializeTriggerConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
