// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the authentication config that the connector supports.
 */
public class AuthenticationConfig private constructor(builder: Builder) {
    /**
     * Contains information required for custom authentication.
     */
    public val customAuthConfigs: List<CustomAuthConfig>? = builder.customAuthConfigs
    /**
     * Indicates whether API key authentication is supported by the connector
     */
    public val isApiKeyAuthSupported: kotlin.Boolean = builder.isApiKeyAuthSupported
    /**
     * Indicates whether basic authentication is supported by the connector.
     */
    public val isBasicAuthSupported: kotlin.Boolean = builder.isBasicAuthSupported
    /**
     * Indicates whether custom authentication is supported by the connector
     */
    public val isCustomAuthSupported: kotlin.Boolean = builder.isCustomAuthSupported
    /**
     * Indicates whether OAuth 2.0 authentication is supported by the connector.
     */
    public val isOAuth2Supported: kotlin.Boolean = builder.isOAuth2Supported
    /**
     * Contains the default values required for OAuth 2.0 authentication.
     */
    public val oAuth2Defaults: aws.sdk.kotlin.services.appflow.model.OAuth2Defaults? = builder.oAuth2Defaults

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.AuthenticationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthenticationConfig(")
        append("customAuthConfigs=$customAuthConfigs,")
        append("isApiKeyAuthSupported=$isApiKeyAuthSupported,")
        append("isBasicAuthSupported=$isBasicAuthSupported,")
        append("isCustomAuthSupported=$isCustomAuthSupported,")
        append("isOAuth2Supported=$isOAuth2Supported,")
        append("oAuth2Defaults=$oAuth2Defaults")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customAuthConfigs?.hashCode() ?: 0
        result = 31 * result + (isApiKeyAuthSupported.hashCode())
        result = 31 * result + (isBasicAuthSupported.hashCode())
        result = 31 * result + (isCustomAuthSupported.hashCode())
        result = 31 * result + (isOAuth2Supported.hashCode())
        result = 31 * result + (oAuth2Defaults?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthenticationConfig

        if (customAuthConfigs != other.customAuthConfigs) return false
        if (isApiKeyAuthSupported != other.isApiKeyAuthSupported) return false
        if (isBasicAuthSupported != other.isBasicAuthSupported) return false
        if (isCustomAuthSupported != other.isCustomAuthSupported) return false
        if (isOAuth2Supported != other.isOAuth2Supported) return false
        if (oAuth2Defaults != other.oAuth2Defaults) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.AuthenticationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains information required for custom authentication.
         */
        public var customAuthConfigs: List<CustomAuthConfig>? = null
        /**
         * Indicates whether API key authentication is supported by the connector
         */
        public var isApiKeyAuthSupported: kotlin.Boolean = false
        /**
         * Indicates whether basic authentication is supported by the connector.
         */
        public var isBasicAuthSupported: kotlin.Boolean = false
        /**
         * Indicates whether custom authentication is supported by the connector
         */
        public var isCustomAuthSupported: kotlin.Boolean = false
        /**
         * Indicates whether OAuth 2.0 authentication is supported by the connector.
         */
        public var isOAuth2Supported: kotlin.Boolean = false
        /**
         * Contains the default values required for OAuth 2.0 authentication.
         */
        public var oAuth2Defaults: aws.sdk.kotlin.services.appflow.model.OAuth2Defaults? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.AuthenticationConfig) : this() {
            this.customAuthConfigs = x.customAuthConfigs
            this.isApiKeyAuthSupported = x.isApiKeyAuthSupported
            this.isBasicAuthSupported = x.isBasicAuthSupported
            this.isCustomAuthSupported = x.isCustomAuthSupported
            this.isOAuth2Supported = x.isOAuth2Supported
            this.oAuth2Defaults = x.oAuth2Defaults
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.AuthenticationConfig = AuthenticationConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.OAuth2Defaults] inside the given [block]
         */
        public fun oAuth2Defaults(block: aws.sdk.kotlin.services.appflow.model.OAuth2Defaults.Builder.() -> kotlin.Unit) {
            this.oAuth2Defaults = aws.sdk.kotlin.services.appflow.model.OAuth2Defaults.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
