// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The high-level entity that can be queried in Amazon AppFlow. For example, a Salesforce entity might be an *Account* or *Opportunity*, whereas a ServiceNow entity might be an *Incident*.
 */
public class ConnectorEntity private constructor(builder: Builder) {
    /**
     * Specifies whether the connector entity is a parent or a category and has more entities nested underneath it. If another call is made with `entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"`, then it returns the nested entities underneath it. This provides a way to retrieve all supported entities in a recursive fashion.
     */
    public val hasNestedEntities: kotlin.Boolean = builder.hasNestedEntities
    /**
     * The label applied to the connector entity.
     */
    public val label: kotlin.String? = builder.label
    /**
     * The name of the connector entity.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ConnectorEntity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectorEntity(")
        append("hasNestedEntities=$hasNestedEntities,")
        append("label=$label,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hasNestedEntities.hashCode()
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectorEntity

        if (hasNestedEntities != other.hasNestedEntities) return false
        if (label != other.label) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ConnectorEntity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the connector entity is a parent or a category and has more entities nested underneath it. If another call is made with `entitiesPath = "the_current_entity_name_with_hasNestedEntities_true"`, then it returns the nested entities underneath it. This provides a way to retrieve all supported entities in a recursive fashion.
         */
        public var hasNestedEntities: kotlin.Boolean = false
        /**
         * The label applied to the connector entity.
         */
        public var label: kotlin.String? = null
        /**
         * The name of the connector entity.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ConnectorEntity) : this() {
            this.hasNestedEntities = x.hasNestedEntities
            this.label = x.label
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ConnectorEntity = ConnectorEntity(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
