// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the default values required for OAuth 2.0 authentication.
 */
public class OAuth2Defaults private constructor(builder: Builder) {
    /**
     * Auth code URLs that can be used for OAuth 2.0 authentication.
     */
    public val authCodeUrls: List<String>? = builder.authCodeUrls
    /**
     * List of custom parameters required for OAuth 2.0 authentication.
     */
    public val oauth2CustomProperties: List<OAuth2CustomParameter>? = builder.oauth2CustomProperties
    /**
     * OAuth 2.0 grant types supported by the connector.
     */
    public val oauth2GrantTypesSupported: List<OAuth2GrantType>? = builder.oauth2GrantTypesSupported
    /**
     * OAuth 2.0 scopes that the connector supports.
     */
    public val oauthScopes: List<String>? = builder.oauthScopes
    /**
     * Token URLs that can be used for OAuth 2.0 authentication.
     */
    public val tokenUrls: List<String>? = builder.tokenUrls

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.OAuth2Defaults = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OAuth2Defaults(")
        append("authCodeUrls=$authCodeUrls,")
        append("oauth2CustomProperties=$oauth2CustomProperties,")
        append("oauth2GrantTypesSupported=$oauth2GrantTypesSupported,")
        append("oauthScopes=$oauthScopes,")
        append("tokenUrls=$tokenUrls")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authCodeUrls?.hashCode() ?: 0
        result = 31 * result + (oauth2CustomProperties?.hashCode() ?: 0)
        result = 31 * result + (oauth2GrantTypesSupported?.hashCode() ?: 0)
        result = 31 * result + (oauthScopes?.hashCode() ?: 0)
        result = 31 * result + (tokenUrls?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OAuth2Defaults

        if (authCodeUrls != other.authCodeUrls) return false
        if (oauth2CustomProperties != other.oauth2CustomProperties) return false
        if (oauth2GrantTypesSupported != other.oauth2GrantTypesSupported) return false
        if (oauthScopes != other.oauthScopes) return false
        if (tokenUrls != other.tokenUrls) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.OAuth2Defaults = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Auth code URLs that can be used for OAuth 2.0 authentication.
         */
        public var authCodeUrls: List<String>? = null
        /**
         * List of custom parameters required for OAuth 2.0 authentication.
         */
        public var oauth2CustomProperties: List<OAuth2CustomParameter>? = null
        /**
         * OAuth 2.0 grant types supported by the connector.
         */
        public var oauth2GrantTypesSupported: List<OAuth2GrantType>? = null
        /**
         * OAuth 2.0 scopes that the connector supports.
         */
        public var oauthScopes: List<String>? = null
        /**
         * Token URLs that can be used for OAuth 2.0 authentication.
         */
        public var tokenUrls: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.OAuth2Defaults) : this() {
            this.authCodeUrls = x.authCodeUrls
            this.oauth2CustomProperties = x.oauth2CustomProperties
            this.oauth2GrantTypesSupported = x.oauth2GrantTypesSupported
            this.oauthScopes = x.oauthScopes
            this.tokenUrls = x.tokenUrls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.OAuth2Defaults = OAuth2Defaults(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
