// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The properties that are applied when Amazon S3 is being used as the flow source.
 */
public class S3SourceProperties private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket name where the source files are stored.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The object key for the Amazon S3 bucket in which the source files are stored.
     */
    public val bucketPrefix: kotlin.String? = builder.bucketPrefix
    /**
     * When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
     */
    public val s3InputFormatConfig: aws.sdk.kotlin.services.appflow.model.S3InputFormatConfig? = builder.s3InputFormatConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.S3SourceProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3SourceProperties(")
        append("bucketName=$bucketName,")
        append("bucketPrefix=$bucketPrefix,")
        append("s3InputFormatConfig=$s3InputFormatConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (bucketPrefix?.hashCode() ?: 0)
        result = 31 * result + (s3InputFormatConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3SourceProperties

        if (bucketName != other.bucketName) return false
        if (bucketPrefix != other.bucketPrefix) return false
        if (s3InputFormatConfig != other.s3InputFormatConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.S3SourceProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 bucket name where the source files are stored.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The object key for the Amazon S3 bucket in which the source files are stored.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
         */
        public var s3InputFormatConfig: aws.sdk.kotlin.services.appflow.model.S3InputFormatConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.S3SourceProperties) : this() {
            this.bucketName = x.bucketName
            this.bucketPrefix = x.bucketPrefix
            this.s3InputFormatConfig = x.s3InputFormatConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.S3SourceProperties = S3SourceProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.S3InputFormatConfig] inside the given [block]
         */
        public fun s3InputFormatConfig(block: aws.sdk.kotlin.services.appflow.model.S3InputFormatConfig.Builder.() -> kotlin.Unit) {
            this.s3InputFormatConfig = aws.sdk.kotlin.services.appflow.model.S3InputFormatConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            return this
        }
    }
}
