// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
 */
public class S3OutputFormatConfig private constructor(builder: Builder) {
    /**
     * The aggregation settings that you can use to customize the output format of your flow data.
     */
    public val aggregationConfig: aws.sdk.kotlin.services.appflow.model.AggregationConfig? = builder.aggregationConfig
    /**
     * Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
     */
    public val fileType: aws.sdk.kotlin.services.appflow.model.FileType? = builder.fileType
    /**
     * Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date.
     */
    public val prefixConfig: aws.sdk.kotlin.services.appflow.model.PrefixConfig? = builder.prefixConfig
    /**
     * If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data types in your source data when it writes the output to Amazon S3.
     * + `true`: Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an integer or `1` in your source data is still an integer in your output.
     * + `false`: Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3. For example, an integer of `1` in your source data becomes the string `"1"` in the output.
     */
    public val preserveSourceDataTyping: kotlin.Boolean? = builder.preserveSourceDataTyping

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3OutputFormatConfig(")
        append("aggregationConfig=$aggregationConfig,")
        append("fileType=$fileType,")
        append("prefixConfig=$prefixConfig,")
        append("preserveSourceDataTyping=$preserveSourceDataTyping")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationConfig?.hashCode() ?: 0
        result = 31 * result + (fileType?.hashCode() ?: 0)
        result = 31 * result + (prefixConfig?.hashCode() ?: 0)
        result = 31 * result + (preserveSourceDataTyping?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3OutputFormatConfig

        if (aggregationConfig != other.aggregationConfig) return false
        if (fileType != other.fileType) return false
        if (prefixConfig != other.prefixConfig) return false
        if (preserveSourceDataTyping != other.preserveSourceDataTyping) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The aggregation settings that you can use to customize the output format of your flow data.
         */
        public var aggregationConfig: aws.sdk.kotlin.services.appflow.model.AggregationConfig? = null
        /**
         * Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
         */
        public var fileType: aws.sdk.kotlin.services.appflow.model.FileType? = null
        /**
         * Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date.
         */
        public var prefixConfig: aws.sdk.kotlin.services.appflow.model.PrefixConfig? = null
        /**
         * If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data types in your source data when it writes the output to Amazon S3.
         * + `true`: Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an integer or `1` in your source data is still an integer in your output.
         * + `false`: Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3. For example, an integer of `1` in your source data becomes the string `"1"` in the output.
         */
        public var preserveSourceDataTyping: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig) : this() {
            this.aggregationConfig = x.aggregationConfig
            this.fileType = x.fileType
            this.prefixConfig = x.prefixConfig
            this.preserveSourceDataTyping = x.preserveSourceDataTyping
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig = S3OutputFormatConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.AggregationConfig] inside the given [block]
         */
        public fun aggregationConfig(block: aws.sdk.kotlin.services.appflow.model.AggregationConfig.Builder.() -> kotlin.Unit) {
            this.aggregationConfig = aws.sdk.kotlin.services.appflow.model.AggregationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.PrefixConfig] inside the given [block]
         */
        public fun prefixConfig(block: aws.sdk.kotlin.services.appflow.model.PrefixConfig.Builder.() -> kotlin.Unit) {
            this.prefixConfig = aws.sdk.kotlin.services.appflow.model.PrefixConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
