// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies information about the past flow run instances for a given flow.
 */
public class ExecutionRecord private constructor(builder: Builder) {
    /**
     * The timestamp that indicates the last new or updated record to be transferred in the flow run.
     */
    public val dataPullEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.dataPullEndTime
    /**
     * The timestamp that determines the first new or updated record to be transferred in the flow run.
     */
    public val dataPullStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.dataPullStartTime
    /**
     * Specifies the identifier of the given flow run.
     */
    public val executionId: kotlin.String? = builder.executionId
    /**
     * Describes the result of the given flow run.
     */
    public val executionResult: aws.sdk.kotlin.services.appflow.model.ExecutionResult? = builder.executionResult
    /**
     * Specifies the flow run status and whether it is in progress, has completed successfully, or has failed.
     */
    public val executionStatus: aws.sdk.kotlin.services.appflow.model.ExecutionStatus? = builder.executionStatus
    /**
     * Specifies the time of the most recent update.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * Describes the metadata catalog, metadata table, and data partitions that Amazon AppFlow used for the associated flow run.
     */
    public val metadataCatalogDetails: List<MetadataCatalogDetail>? = builder.metadataCatalogDetails
    /**
     * Specifies the start time of the flow run.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ExecutionRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutionRecord(")
        append("dataPullEndTime=$dataPullEndTime,")
        append("dataPullStartTime=$dataPullStartTime,")
        append("executionId=$executionId,")
        append("executionResult=$executionResult,")
        append("executionStatus=$executionStatus,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("metadataCatalogDetails=$metadataCatalogDetails,")
        append("startedAt=$startedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataPullEndTime?.hashCode() ?: 0
        result = 31 * result + (dataPullStartTime?.hashCode() ?: 0)
        result = 31 * result + (executionId?.hashCode() ?: 0)
        result = 31 * result + (executionResult?.hashCode() ?: 0)
        result = 31 * result + (executionStatus?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (metadataCatalogDetails?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutionRecord

        if (dataPullEndTime != other.dataPullEndTime) return false
        if (dataPullStartTime != other.dataPullStartTime) return false
        if (executionId != other.executionId) return false
        if (executionResult != other.executionResult) return false
        if (executionStatus != other.executionStatus) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (metadataCatalogDetails != other.metadataCatalogDetails) return false
        if (startedAt != other.startedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ExecutionRecord = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp that indicates the last new or updated record to be transferred in the flow run.
         */
        public var dataPullEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp that determines the first new or updated record to be transferred in the flow run.
         */
        public var dataPullStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the identifier of the given flow run.
         */
        public var executionId: kotlin.String? = null
        /**
         * Describes the result of the given flow run.
         */
        public var executionResult: aws.sdk.kotlin.services.appflow.model.ExecutionResult? = null
        /**
         * Specifies the flow run status and whether it is in progress, has completed successfully, or has failed.
         */
        public var executionStatus: aws.sdk.kotlin.services.appflow.model.ExecutionStatus? = null
        /**
         * Specifies the time of the most recent update.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the metadata catalog, metadata table, and data partitions that Amazon AppFlow used for the associated flow run.
         */
        public var metadataCatalogDetails: List<MetadataCatalogDetail>? = null
        /**
         * Specifies the start time of the flow run.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ExecutionRecord) : this() {
            this.dataPullEndTime = x.dataPullEndTime
            this.dataPullStartTime = x.dataPullStartTime
            this.executionId = x.executionId
            this.executionResult = x.executionResult
            this.executionStatus = x.executionStatus
            this.lastUpdatedAt = x.lastUpdatedAt
            this.metadataCatalogDetails = x.metadataCatalogDetails
            this.startedAt = x.startedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ExecutionRecord = ExecutionRecord(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ExecutionResult] inside the given [block]
         */
        public fun executionResult(block: aws.sdk.kotlin.services.appflow.model.ExecutionResult.Builder.() -> kotlin.Unit) {
            this.executionResult = aws.sdk.kotlin.services.appflow.model.ExecutionResult.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
